/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.wikitext.core.ast;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.docmlet.wikitext.core.ast.ContainerNode;
import org.eclipse.statet.docmlet.wikitext.core.ast.WikitextAst;
import org.eclipse.statet.docmlet.wikitext.core.ast.WikitextAstNode;
import org.eclipse.statet.docmlet.wikitext.core.ast.WikitextAstVisitor;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.AstVisitor;
import org.eclipse.statet.ltk.ast.core.EmbeddingAstNode;

public class Embedded
extends ContainerNode
implements EmbeddingAstNode {
    private final String foreignType;
    private final int embedDescr;
    private AstNode foreignNode;

    Embedded(WikitextAstNode parent, int startOffset, int endOffset, String foreignType, int embedDescr) {
        super(parent, startOffset, endOffset);
        this.foreignType = foreignType;
        this.embedDescr = embedDescr;
    }

    @Override
    public WikitextAst.NodeType getNodeType() {
        return WikitextAst.NodeType.EMBEDDED;
    }

    public String getForeignTypeId() {
        return this.foreignType;
    }

    public int getEmbedDescr() {
        return this.embedDescr;
    }

    public String getText() {
        return this.foreignType;
    }

    public void setForeignNode(AstNode node) {
        this.foreignNode = node;
    }

    public AstNode getForeignNode() {
        return this.foreignNode;
    }

    @Override
    public void acceptInChildren(AstVisitor visitor) throws InvocationTargetException {
        if (this.foreignNode != null) {
            this.foreignNode.accept(visitor);
        } else {
            super.acceptInChildren(visitor);
        }
    }

    @Override
    public void acceptInWikitext(WikitextAstVisitor visitor) throws InvocationTargetException {
        visitor.visit(this);
    }
}

