/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.statet.ecommons.text.TextUtil;
import org.eclipse.statet.ecommons.ui.dialogs.DialogUtils;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.internal.r.ui.wizards.Messages;
import org.eclipse.statet.internal.r.ui.wizards.NewRFileCreationWizardPage;
import org.eclipse.statet.ltk.core.LTK;
import org.eclipse.statet.ltk.ui.templates.TemplateUtils;
import org.eclipse.statet.ltk.ui.wizards.NewElementWizard;
import org.eclipse.statet.ltk.ui.wizards.NewElementWizardPage;
import org.eclipse.statet.r.codegeneration.CodeGeneration;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.core.model.IRSourceUnit;
import org.eclipse.statet.r.ui.RUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class NewRFileCreationWizard
extends NewElementWizard {
    private NewRFileCreationWizardPage firstPage;
    private NewElementWizard.NewFile newRFile;

    public NewRFileCreationWizard() {
        this.setDialogSettings(DialogUtils.getDialogSettings((AbstractUIPlugin)RUIPlugin.getInstance(), (String)"NewElementWizard"));
        this.setDefaultPageImageDescriptor(RUI.getImageDescriptor("org.eclipse.statet.r.ui/image/wizban/new.r-file"));
        this.setWindowTitle(Messages.NewRScriptFileWizard_title);
    }

    public void addPages() {
        super.addPages();
        this.firstPage = new NewRFileCreationWizardPage(this.getSelection());
        this.addPage((IWizardPage)this.firstPage);
    }

    protected ISchedulingRule getSchedulingRule() {
        ISchedulingRule rule = this.createRule((IResource)this.newRFile.getResource());
        if (rule != null) {
            return rule;
        }
        return super.getSchedulingRule();
    }

    public boolean performFinish() {
        NewElementWizardPage.ResourceGroup resourceGroup = this.firstPage.getResourceGroup();
        this.newRFile = new NewRFile(resourceGroup.getContainerFullPath(), resourceGroup.getResourceName());
        boolean result = super.performFinish();
        if (result && this.newRFile.getResource() != null) {
            this.selectAndReveal((IResource)this.newRFile.getResource());
            this.openResource(this.newRFile);
        }
        return result;
    }

    protected void performOperations(IProgressMonitor monitor) throws InterruptedException, CoreException, InvocationTargetException {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (String)"Create new R file...", (int)11);
        this.newRFile.createFile((IProgressMonitor)m.newChild(10));
        this.firstPage.saveSettings();
        m.worked(1);
    }

    private static class NewRFile
    extends NewElementWizard.NewFile {
        public NewRFile(IPath containerPath, String resourceName) {
            super(containerPath, resourceName, RCore.R_CONTENT_TYPE);
        }

        protected String getInitialFileContent(IFile newFileHandle, SubMonitor m) {
            String lineDelimiter = TextUtil.getLineDelimiter((IProject)newFileHandle.getProject());
            IRSourceUnit su = (IRSourceUnit)LTK.getSourceUnitManager().getSourceUnit(LTK.PERSISTENCE_CONTEXT, (Object)newFileHandle, this.getContentType(newFileHandle), true, (IProgressMonitor)m);
            try {
                TemplateUtils.EvaluatedTemplate data = CodeGeneration.getNewRFileContent(su, lineDelimiter);
                if (data != null) {
                    this.initialSelection = data.getRegionToSelect();
                    String string = data.getContent();
                    return string;
                }
            }
            catch (CoreException e) {
                RUIPlugin.logError(0, "An error occured when applying template to new R script file.", e);
            }
            finally {
                if (su != null) {
                    su.disconnect((IProgressMonitor)m);
                }
            }
            return null;
        }
    }
}

