/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.ui.preferences;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.SelectObservableValue;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.statet.ecommons.databinding.jface.DataBindingSupport;
import org.eclipse.statet.ecommons.ui.dialogs.ExtStatusDialog;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.VariableFilterUtils;
import org.eclipse.statet.ecommons.ui.workbench.ResourceInputComposite;
import org.eclipse.statet.internal.r.debug.ui.preferences.Messages;
import org.eclipse.statet.r.core.renv.IREnvConfiguration;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class RemoteREnvConfigDialog
extends ExtStatusDialog {
    private final IREnvConfiguration.WorkingCopy configModel;
    private final boolean isNewConfig;
    private final Set<String> existingNames;
    private Text nameControl;
    private Button indexDirectorySelectionControl;
    private ResourceInputComposite indexDirectorResourceControl;
    private Button indexServerSelectionControl;
    private Text indexServerUrlControl;

    public RemoteREnvConfigDialog(Shell parent, IREnvConfiguration.WorkingCopy config, boolean isNewConfig, Collection<IREnvConfiguration> existingConfigs) {
        super(parent, 1 | (isNewConfig ? 2 : 6));
        this.configModel = config;
        this.isNewConfig = isNewConfig;
        this.existingNames = new HashSet<String>();
        for (IREnvConfiguration ec : existingConfigs) {
            this.existingNames.add(ec.getName());
        }
        this.setTitle(this.isNewConfig ? Messages.REnv_Detail_AddDialog_title : Messages.REnv_Detail_Edit_Dialog_title);
    }

    public void create() {
        super.create();
        this.updateEditable();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "org.eclipse.statet.r.ui.r_env");
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        area.setLayoutData((Object)new GridData(4, 4, true, true));
        area.setLayout((Layout)LayoutUtils.newDialogGrid((int)2));
        Label label = new Label(area, 16384);
        label.setText("R Environment configuration for remote R installations (consoles).");
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        LayoutUtils.addSmallFiller((Composite)area, (boolean)false);
        label = new Label(area, 16384);
        label.setText(String.valueOf(Messages.REnv_Detail_Name_label) + ':');
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Text text = new Text(area, 2048);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.widthHint = LayoutUtils.hintWidth((Text)text, (int)60);
        text.setLayoutData((Object)gd);
        this.nameControl = text;
        LayoutUtils.addSmallFiller((Composite)area, (boolean)false);
        Composite composite = this.createStateOptions(area);
        composite.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        LayoutUtils.addSmallFiller((Composite)area, (boolean)true);
        RemoteREnvConfigDialog.applyDialogFont((Control)area);
        return area;
    }

    protected Composite createStateOptions(Composite parent) {
        Group composite = new Group(parent, 0);
        composite.setText("R-Help / Index:");
        composite.setLayout((Layout)LayoutUtils.newGroupGrid((int)1));
        Button button = new Button((Composite)composite, 16);
        button.setText("&Directory (empty for default location):");
        button.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.indexDirectorySelectionControl = button;
        ResourceInputComposite text = new ResourceInputComposite((Composite)composite, 0, 10, "R_DOC_DIR");
        text.setShowInsertVariable(true, (List)VariableFilterUtils.DEFAULT_NON_ITERACTIVE_FILTERS, null);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.horizontalIndent = LayoutUtils.defaultIndent();
        text.setLayoutData((Object)gd);
        this.indexDirectorResourceControl = text;
        button = new Button((Composite)composite, 16);
        button.setText("R-Help &Server:");
        button.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.indexServerSelectionControl = button;
        text = new Text((Composite)composite, 18436);
        gd = new GridData(4, 0x1000000, true, false);
        gd.horizontalIndent = LayoutUtils.defaultIndent();
        text.setLayoutData((Object)gd);
        this.indexServerUrlControl = text;
        return composite;
    }

    protected void addBindings(DataBindingSupport db) {
        db.getContext().bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.nameControl), BeanProperties.value((String)"name", String.class).observe((Object)this.configModel), new UpdateValueStrategy().setAfterGetValidator(value -> {
            String s = (String)value;
            if ((s = s.trim()).isEmpty()) {
                return ValidationStatus.error((String)Messages.REnv_Detail_Name_error_Missing_message);
            }
            if (this.existingNames.contains(s)) {
                return ValidationStatus.error((String)Messages.REnv_Detail_Name_error_Duplicate_message);
            }
            if (s.contains("/")) {
                return ValidationStatus.error((String)Messages.REnv_Detail_Name_error_InvalidChar_message);
            }
            return ValidationStatus.ok();
        }), null);
        ISWTObservableValue indexDirectoryValue = WidgetProperties.selection().observe((Widget)this.indexDirectorySelectionControl);
        ISWTObservableValue indexServerValue = WidgetProperties.selection().observe((Widget)this.indexServerSelectionControl);
        SelectObservableValue typeValue = new SelectObservableValue();
        typeValue.addOption((Object)"directory", (IObservableValue)indexDirectoryValue);
        typeValue.addOption((Object)"server", (IObservableValue)indexServerValue);
        db.getContext().bindValue((IObservableValue)typeValue, BeanProperties.value((String)"stateSharedType", String.class).observe((Object)this.configModel));
        db.getContext().bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)this.indexDirectorResourceControl), (IObservableValue)indexDirectoryValue);
        db.getContext().bindValue(this.indexDirectorResourceControl.getObservable(), BeanProperties.value((String)"stateSharedDirectory", String.class).observe((Object)this.configModel));
        db.getContext().bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)this.indexServerUrlControl), (IObservableValue)indexServerValue);
        db.getContext().bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.indexServerUrlControl), BeanProperties.value((String)"stateSharedServer", String.class).observe((Object)this.configModel));
    }

    private void updateEditable() {
        boolean isEditable = this.configModel.isEditable();
        this.nameControl.setEditable(isEditable);
        this.indexDirectorySelectionControl.setEnabled(isEditable || this.indexDirectorySelectionControl.getSelection());
        this.indexDirectorResourceControl.setEditable(isEditable);
        this.indexServerSelectionControl.setEnabled(isEditable || this.indexServerSelectionControl.getSelection());
        this.indexServerUrlControl.setEditable(isEditable);
    }
}

