/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.builder;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.statet.ecommons.text.core.JFaceTextRegion;
import org.eclipse.statet.internal.r.core.builder.RTaskMarkerHandler;
import org.eclipse.statet.jcommons.collections.IntArrayList;
import org.eclipse.statet.jcommons.collections.IntList;
import org.eclipse.statet.jcommons.text.core.TextLineInformation;
import org.eclipse.statet.jcommons.text.core.TextRegion;

public class RdParser {
    private static final char[][] PLATFORM_KEYWORDS = new char[][]{"ifdef".toCharArray(), "ifndef".toCharArray(), "endif".toCharArray()};
    private final RTaskMarkerHandler markers;
    private final char[] content;
    private int currentOffset = 0;
    private final int currentLine = 1;
    private Last lastChar = Last.NONE;
    private final LineInformation lineStructure;

    public RdParser(char[] content, RTaskMarkerHandler markers) {
        this.content = content;
        this.markers = markers;
        this.lineStructure = new LineInformation();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void check() throws CoreException {
        while (this.currentOffset < this.content.length) {
            if (!this.checkNewLine() && !this.checkBackslash()) {
                char current = this.content[this.currentOffset];
                switch (current) {
                    case '%': {
                        this.readComment();
                        break;
                    }
                    case '#': {
                        if (this.lastChar != Last.NEWLINE) break;
                        int i = 0;
                        while (i < PLATFORM_KEYWORDS.length) {
                            int offset = this.currentOffset + 1;
                            int j = 0;
                            while (true) {
                                if (j >= PLATFORM_KEYWORDS[i].length) {
                                    this.readPlatformInstruction(PLATFORM_KEYWORDS[i]);
                                    break;
                                }
                                if (offset >= this.content.length || PLATFORM_KEYWORDS[i][j] != this.content[offset++]) break;
                                ++j;
                            }
                            ++i;
                        }
                        break;
                    }
                }
            }
            ++this.currentOffset;
        }
    }

    private void readPlatformInstruction(char[] keyword) {
        int start = this.currentOffset;
        int end = this.currentOffset++;
        while (this.currentOffset < this.content.length) {
            end = this.currentOffset++;
            if (this.checkNewLine()) break;
        }
    }

    private void readComment() throws CoreException {
        int start = this.currentOffset;
        int end = this.currentOffset++;
        while (this.currentOffset < this.content.length) {
            end = this.currentOffset++;
            if (!this.checkNewLine()) continue;
            --end;
            break;
        }
        try {
            this.markers.checkForTasks(new String(this.content, start, end - start + 1), start, this.lineStructure);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private boolean checkNewLine() {
        char current = this.content[this.currentOffset];
        if (current == '\r' || current == '\n') {
            if (current == '\r' && this.currentOffset + 1 < this.content.length && this.content[this.currentOffset + 1] == '\n') {
                ++this.currentOffset;
            }
            this.lineStructure.addLine(this.currentOffset);
            this.lastChar = Last.NEWLINE;
            return true;
        }
        return false;
    }

    private boolean checkBackslash() {
        if (this.content[this.currentOffset] == '\\') {
            this.lastChar = Last.BACKSLASH;
            return true;
        }
        if (this.lastChar == Last.BACKSLASH) {
            this.lastChar = Last.NONE;
            return true;
        }
        return false;
    }

    private static enum Last {
        NONE,
        NEWLINE,
        BACKSLASH;

    }

    public class LineInformation
    implements TextLineInformation {
        private final IntList offsets = new IntArrayList();

        public void addLine(int offset) {
            this.offsets.add(offset);
        }

        public int getNumberOfLines() {
            return this.offsets.size();
        }

        public int getLineOfOffset(int offset) {
            if (this.offsets.size() == 0) {
                return -1;
            }
            int low = 0;
            int high = this.offsets.size() - 1;
            while (low <= high) {
                int mid = low + high >> 1;
                int lineOffset = this.offsets.getAt(mid);
                if (lineOffset < offset) {
                    low = mid + 1;
                    continue;
                }
                if (lineOffset > offset) {
                    high = mid - 1;
                    continue;
                }
                return mid;
            }
            return low - 1;
        }

        public int getStartOffset(int line) {
            if (line < 0 || line >= this.offsets.size()) {
                return -1;
            }
            return this.offsets.getAt(line);
        }

        public int getEndOffset(int line) {
            return line + 1 == this.offsets.size() ? RdParser.this.content.length : this.offsets.getAt(line + 1);
        }

        public int getLength(int line) {
            return line + 1 == this.offsets.size() ? RdParser.this.content.length - this.offsets.getAt(line) : this.offsets.getAt(line + 1) - this.offsets.getAt(line);
        }

        public TextRegion getRegion(int line) {
            return JFaceTextRegion.newByStartEnd((int)this.offsets.getAt(line), (int)(line + 1 == this.offsets.size() ? RdParser.this.content.length : this.offsets.getAt(line + 1)));
        }
    }
}

