/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.apps.ui.variables;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.r.apps.ui.variables.AppVarInput;
import org.eclipse.statet.internal.r.apps.ui.variables.AppVarView;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.model.core.elements.IModelElement;
import org.eclipse.statet.r.apps.ui.RApp;
import org.eclipse.statet.r.apps.ui.VariablesData;
import org.eclipse.statet.r.console.core.RProcessREnvironment;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.ui.util.RNameSearchPattern;
import org.eclipse.ui.dialogs.SearchPattern;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

@NonNullByDefault
class ContentJob
extends Job
implements RApp.Listener {
    private final AppVarView view;
    private @Nullable RApp updateSource;
    private @Nullable RApp lastSource;
    private boolean force;
    private @Nullable VariablesData rawInput;
    private volatile boolean isScheduled;

    public ContentJob(AppVarView view) {
        super("R Object Browser Update");
        this.view = view;
        this.setSystem(true);
        this.setUser(false);
    }

    @Override
    public void onVariablesChanged(RApp.AppEvent event) {
        this.schedule(event.getApp());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceUpdate(@Nullable RApp app) {
        Object object = this.view.sourceLock;
        synchronized (object) {
            if (app != this.view.getApp()) {
                return;
            }
            this.updateSource = app;
            this.force = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(RApp app) {
        if (app != null) {
            Object object = this.view.sourceLock;
            synchronized (object) {
                if (app != this.view.getApp()) {
                    return;
                }
                this.updateSource = app;
            }
        }
        this.schedule();
    }

    public boolean shouldSchedule() {
        this.isScheduled = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected IStatus run(IProgressMonitor monitor) {
        List<RProcessREnvironment> toUpdate;
        AppVarInput input;
        RApp app;
        block15: {
            boolean sourceChanged;
            IWorkbenchSiteProgressService progressService;
            block14: {
                if (!this.isScheduled) {
                    return Status.CANCEL_STATUS;
                }
                progressService = (IWorkbenchSiteProgressService)this.view.getViewSite().getService(IWorkbenchSiteProgressService.class);
                if (progressService != null) {
                    progressService.incrementBusy();
                }
                Object object = this.view.sourceLock;
                // MONITORENTER : object
                this.isScheduled = false;
                app = this.view.getApp();
                sourceChanged = app != this.lastSource;
                boolean updateInput = sourceChanged || this.updateSource != null;
                this.lastSource = app;
                this.updateSource = null;
                this.force = false;
                // MONITOREXIT : object
                input = app != null ? this.createInput(app) : null;
                toUpdate = updateInput ? this.updateFromSource(input) : null;
                this.prepare(input);
                Object object2 = this.view.sourceLock;
                // MONITORENTER : object2
                if (app == this.view.getApp()) break block14;
                this.lastSource = null;
                IStatus iStatus = Status.CANCEL_STATUS;
                // MONITOREXIT : object2
                if (progressService == null) return iStatus;
                progressService.decrementBusy();
                return iStatus;
            }
            if ((sourceChanged || !this.isScheduled) && !monitor.isCanceled()) break block15;
            IStatus iStatus = Status.CANCEL_STATUS;
            // MONITOREXIT : object2
            if (progressService == null) return iStatus;
            progressService.decrementBusy();
            return iStatus;
        }
        // MONITOREXIT : object2
        UIAccess.getDisplay().syncExec(() -> {
            if (app != this.view.getApp()) {
                return;
            }
            this.view.updateView(input, toUpdate);
        });
        return Status.OK_STATUS;
    }

    private AppVarInput createInput(RApp source) {
        ContentFilter otherFilter;
        ContentFilter envFilter;
        boolean filterInternal = !this.view.getFilterIncludeInternal();
        String filterText = this.view.getFilterSearchText();
        if (filterText != null && filterText.length() > 0) {
            RNameSearchPattern filterPattern = new RNameSearchPattern();
            filterPattern.setPattern(filterText);
            envFilter = new ContentFilter(filterInternal, (SearchPattern)filterPattern);
            otherFilter = filterInternal ? new ContentFilter(filterInternal, null) : null;
        } else if (filterInternal) {
            envFilter = new ContentFilter(filterInternal, null);
            otherFilter = new ContentFilter(filterInternal, null);
        } else {
            envFilter = null;
            otherFilter = null;
        }
        return new AppVarInput(source, envFilter, otherFilter);
    }

    private @Nullable List<RProcessREnvironment> updateFromSource(@Nullable AppVarInput input) {
        VariablesData data;
        if (input == null) {
            this.rawInput = null;
            return null;
        }
        RApp app = (RApp)input.getSource();
        VariablesData oldInput = this.rawInput;
        this.rawInput = data = app.getVariables();
        if (data != null) {
            List<RProcessREnvironment> updateEntries = null;
            return updateEntries;
        }
        return null;
    }

    private void prepare(@Nullable AppVarInput input) {
        CombinedRElement[] array;
        VariablesData rawInput = this.rawInput;
        if (input == null || rawInput == null) {
            return;
        }
        ImList<CombinedRElement> elements = rawInput.getElements();
        if (elements != null) {
            array = elements.toArray((CombinedRElement[])new CombinedRElement[elements.size()]);
            if (input.hasEnvFilter()) {
                int i = 0;
                while (i < array.length) {
                    input.getEnvChildren(array[i]);
                    ++i;
                }
            }
        } else {
            array = null;
        }
        input.setRootElements(array);
    }

    static class ContentFilter
    implements IModelElement.Filter {
        private final boolean filterInternal;
        private final @Nullable SearchPattern searchPattern;

        public ContentFilter(boolean filterInternal, @Nullable SearchPattern pattern) {
            this.filterInternal = filterInternal;
            this.searchPattern = pattern;
        }

        public boolean include(IModelElement element) {
            String name = element.getElementName().getSegmentName();
            if (name != null) {
                if (this.filterInternal && name.length() > 0 && name.charAt(0) == '.') {
                    return false;
                }
                return this.searchPattern == null || this.searchPattern.matches(name);
            }
            return true;
        }
    }
}

