/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.refactoring.core;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ContentStamp;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.statet.internal.ltk.core.LTKCorePlugin;
import org.eclipse.statet.ltk.model.core.elements.IModelElement;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;
import org.eclipse.statet.ltk.refactoring.core.UndoSourceUnitChange;
import org.eclipse.text.edits.UndoEdit;

public final class SourceUnitChange
extends TextFileChange {
    private final ISourceUnit sourceUnit;
    private Position insertPosition;

    public SourceUnitChange(ISourceUnit su) {
        super(su.getElementName().getDisplayName(), (IFile)su.getResource());
        assert (su != null);
        this.sourceUnit = su;
        try {
            this.setTextType(this.getFile().getContentDescription().getContentType().getFileSpecs(10)[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object getModifiedElement() {
        return this.sourceUnit;
    }

    public ISourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    public void setInsertPosition(Position position) {
        this.insertPosition = new Position(position.getOffset(), 0);
    }

    public Position getInsertPosition() {
        return this.insertPosition;
    }

    protected IDocument acquireDocument(IProgressMonitor monitor) throws CoreException {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        this.sourceUnit.connect((IProgressMonitor)m.newChild(1));
        IDocument document = super.acquireDocument((IProgressMonitor)m.newChild(2));
        if (this.insertPosition != null) {
            this.insertPosition = new Position(this.insertPosition.getOffset(), document.getLength() - this.insertPosition.getOffset());
            try {
                document.addPosition(this.insertPosition);
            }
            catch (BadLocationException e) {
                this.insertPosition = null;
            }
        }
        return document;
    }

    protected void releaseDocument(IDocument document, IProgressMonitor monitor) throws CoreException {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        if (this.insertPosition != null) {
            document.removePosition(this.insertPosition);
        }
        super.releaseDocument(document, (IProgressMonitor)m.newChild(2));
        this.sourceUnit.disconnect((IProgressMonitor)m.newChild(1));
    }

    protected Change createUndoChange(UndoEdit edit, ContentStamp stampToRestore) {
        try {
            return new UndoSourceUnitChange(this.getName(), this.sourceUnit, (IFile)super.getModifiedElement(), edit, stampToRestore, this.getSaveMode());
        }
        catch (CoreException e) {
            LTKCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.ltk.core", -1, "Failed to create Refactoring Undo", (Throwable)e));
            return null;
        }
    }

    public <T> T getAdapter(Class<T> adapterType) {
        if (adapterType == ISourceUnit.class || adapterType == IModelElement.class) {
            return (T)this.sourceUnit;
        }
        return (T)super.getAdapter(adapterType);
    }
}

