/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.buildpaths.core;

import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.internal.ltk.buildpaths.core.Messages;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.ltk.buildpaths.core.IBuildpathAttribute;
import org.eclipse.statet.ltk.buildpaths.core.IBuildpathElement;

public abstract class BuildpathInitializer {
    public static final int NOT_SUPPORTED = 65536;
    public static final int READ_ONLY = 131072;
    public static final int INVALID_BUILDPATH = 964;
    public static final int NAME_COLLISION = 977;
    private static final IStatus VERIFIED_OK = new Status(0, "org.eclipse.statet.ltk.buildpaths.core", 0, "OK", null);

    public boolean canUpdateContainer(IPath path, IProject project) {
        return false;
    }

    public IStatus getAttributeStatus(IPath path, IProject project, String key) {
        return null;
    }

    public IResource getWorkspaceTarget(IPath path) {
        if (path == null || path.getDevice() != null) {
            return null;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace == null) {
            return null;
        }
        return workspace.getRoot().findMember(path);
    }

    protected String getEntryPathMsg(IProject project, IPath path) {
        return project.getName().equals(path.segment(0)) ? path.removeFirstSegments(1).makeRelative().toString() : path.toString();
    }

    public IStatus validateBuildpath(IProject project, List<IBuildpathElement> rawBuildpath) {
        if (rawBuildpath == null) {
            return VERIFIED_OK;
        }
        HashSet<IPath> pathes = new HashSet<IPath>(rawBuildpath.size());
        for (IBuildpathElement element : rawBuildpath) {
            IPath path = element.getPath();
            if (pathes.add(path)) continue;
            return this.createErrorStatus(977, NLS.bind((String)Messages.BuildpathStatus_DuplicateEntryPath_message, (Object)this.getEntryPathMsg(project, path), (Object)project.getName()));
        }
        for (IBuildpathElement element : rawBuildpath) {
            IStatus status = this.validateBuildpathEntry(project, element);
            if (status.getSeverity() != 4) continue;
            return status;
        }
        return VERIFIED_OK;
    }

    protected IStatus validateBuildpathEntry(IProject project, IBuildpathElement entry) {
        IPath path = entry.getPath();
        String projectName = project.getName();
        switch (entry.getTypeName()) {
            case "Source": {
                if (!path.isAbsolute() || path.isEmpty()) {
                    return this.createErrorStatus(964, NLS.bind((String)Messages.BuildpathStatus_Entry_IllegalSourceFolderPath_message, (Object)this.getEntryPathMsg(project, path), (Object)projectName));
                }
                IPath projectPath = project.getProject().getFullPath();
                if (projectPath.isPrefixOf(path) && this.getWorkspaceTarget(path) != null) break;
                return this.createErrorStatus(964, NLS.bind((String)Messages.BuildpathStatus_Entry_UnboundSourceFolder_message, (Object)this.getEntryPathMsg(project, path), (Object)projectName));
            }
        }
        ImList<IBuildpathAttribute> extraAttributes = entry.getExtraAttributes();
        if (extraAttributes != null) {
            int length = extraAttributes.size();
            HashSet<String> set = new HashSet<String>(length);
            for (IBuildpathAttribute attribute : extraAttributes) {
                if (set.add(attribute.getName())) continue;
                return this.createErrorStatus(977, NLS.bind((String)Messages.BuildpathStatus_Entry_DuplicateExtraAttribute_message, (Object[])new String[]{attribute.getName(), this.getEntryPathMsg(project, path), projectName}));
            }
        }
        return VERIFIED_OK;
    }

    protected IStatus createErrorStatus(int code, String message) {
        return new Status(4, "org.eclipse.statet.ltk.buildpaths.core", code, message, null);
    }
}

