/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.painter.cell.decorator;

import org.eclipse.statet.ecommons.waltable.config.IConfigRegistry;
import org.eclipse.statet.ecommons.waltable.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCell;
import org.eclipse.statet.ecommons.waltable.painter.cell.CellPainterWrapper;
import org.eclipse.statet.ecommons.waltable.painter.cell.GraphicsUtils;
import org.eclipse.statet.ecommons.waltable.painter.cell.ICellPainter;
import org.eclipse.statet.ecommons.waltable.style.CellStyleAttributes;
import org.eclipse.statet.ecommons.waltable.style.CellStyleUtil;
import org.eclipse.statet.ecommons.waltable.style.HorizontalAlignment;
import org.eclipse.statet.ecommons.waltable.style.IStyle;
import org.eclipse.statet.ecommons.waltable.style.VerticalAlignment;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;

public class PaddingDecorator
extends CellPainterWrapper {
    private final long topPadding;
    private final long rightPadding;
    private final long bottomPadding;
    private final long leftPadding;

    public PaddingDecorator(ICellPainter interiorPainter) {
        this(interiorPainter, 2L);
    }

    public PaddingDecorator(ICellPainter interiorPainter, long padding) {
        this(interiorPainter, padding, padding, padding, padding);
    }

    public PaddingDecorator(ICellPainter interiorPainter, long topPadding, long rightPadding, long bottomPadding, long leftPadding) {
        super(interiorPainter);
        this.topPadding = topPadding;
        this.rightPadding = rightPadding;
        this.bottomPadding = bottomPadding;
        this.leftPadding = leftPadding;
    }

    @Override
    public long getPreferredWidth(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        return this.leftPadding + super.getPreferredWidth(cell, gc, configRegistry) + this.rightPadding;
    }

    @Override
    public long getPreferredHeight(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        return this.topPadding + super.getPreferredHeight(cell, gc, configRegistry) + this.bottomPadding;
    }

    @Override
    public void paintCell(ILayerCell cell, GC gc, LRectangle adjustedCellBounds, IConfigRegistry configRegistry) {
        Color originalBg = gc.getBackground();
        Color cellStyleBackground = this.getBackgroundColor(cell, configRegistry);
        if (cellStyleBackground != null) {
            gc.setBackground(cellStyleBackground);
            gc.fillRectangle(GraphicsUtils.safe(adjustedCellBounds));
            gc.setBackground(originalBg);
        } else {
            gc.fillRectangle(GraphicsUtils.safe(adjustedCellBounds));
        }
        LRectangle interiorBounds = this.getInteriorBounds(adjustedCellBounds);
        if (interiorBounds.width > 0L && interiorBounds.height > 0L) {
            super.paintCell(cell, gc, interiorBounds, configRegistry);
        }
    }

    protected LRectangle getInteriorBounds(LRectangle adjustedCellBounds) {
        return new LRectangle(adjustedCellBounds.x + this.leftPadding, adjustedCellBounds.y + this.topPadding, adjustedCellBounds.width - this.leftPadding - this.rightPadding, adjustedCellBounds.height - this.topPadding - this.bottomPadding);
    }

    protected Color getBackgroundColor(ILayerCell cell, IConfigRegistry configRegistry) {
        return CellStyleUtil.getCellStyle(cell, configRegistry).getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR);
    }

    @Override
    public ICellPainter getCellPainterAt(long x, long y, ILayerCell cell, GC gc, LRectangle adjustedCellBounds, IConfigRegistry configRegistry) {
        IStyle cellStyle = CellStyleUtil.getCellStyle(cell, configRegistry);
        HorizontalAlignment horizontalAlignment = cellStyle.getAttributeValue(CellStyleAttributes.HORIZONTAL_ALIGNMENT);
        long horizontalAlignmentPadding = 0L;
        switch (horizontalAlignment) {
            case LEFT: {
                horizontalAlignmentPadding = this.leftPadding;
                break;
            }
            case CENTER: {
                horizontalAlignmentPadding = this.leftPadding / 2L;
            }
        }
        VerticalAlignment verticalAlignment = cellStyle.getAttributeValue(CellStyleAttributes.VERTICAL_ALIGNMENT);
        long verticalAlignmentPadding = 0L;
        switch (verticalAlignment) {
            case TOP: {
                verticalAlignmentPadding = this.topPadding;
                break;
            }
            case MIDDLE: {
                verticalAlignmentPadding = this.topPadding / 2L;
            }
        }
        return super.getCellPainterAt(x - horizontalAlignmentPadding, y - verticalAlignmentPadding, cell, gc, adjustedCellBounds, configRegistry);
    }
}

