/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.preferences.ui;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.statet.ecommons.databinding.jface.AbstractSWTObservableValue;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Widget;

public class ColorSelectorObservableValue
extends AbstractSWTObservableValue {
    private final ColorSelector fSelector;
    private RGB fValue;
    private final IPropertyChangeListener fUpdateListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            ColorSelectorObservableValue.this.fValue = (RGB)event.getNewValue();
            ColorSelectorObservableValue.this.fireValueChange(Diffs.createValueDiff((Object)event.getOldValue(), (Object)ColorSelectorObservableValue.this.fValue));
        }
    };

    public ColorSelectorObservableValue(ColorSelector selector) {
        super((Widget)selector.getButton());
        this.fSelector = selector;
        this.fSelector.addListener(this.fUpdateListener);
    }

    public synchronized void dispose() {
        this.fSelector.removeListener(this.fUpdateListener);
        super.dispose();
    }

    public Object getValueType() {
        return RGB.class;
    }

    public void doSetValue(Object value) {
        RGB oldValue = this.fValue;
        this.fValue = (RGB)value;
        this.fSelector.setColorValue(this.fValue != null ? this.fValue : new RGB(0, 0, 0));
        this.fireValueChange(Diffs.createValueDiff((Object)oldValue, (Object)this.fValue));
    }

    public Object doGetValue() {
        return this.fSelector.getColorValue();
    }
}

