/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.debug.ui.config;

import java.util.Map;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.statet.ecommons.ui.components.CustomizableVariableSelectionDialog;
import org.eclipse.statet.ecommons.ui.components.WidgetToolsButton;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.variables.core.VariableText2;
import org.eclipse.statet.internal.ecommons.debug.ui.Messages;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;

public class InputArgumentsComposite
extends Composite {
    public static final int STYLE_LABEL = 16;
    public static final int STYLE_SINGLE = 4;
    public static final int STYLE_MULTI = 2;
    private static final int DEFAULT_STYLE = 18;
    private final int style;
    private final String label;
    private Text textControl;
    private VariableText2 variableResolver;
    private ImList<StringVariableSelectionDialog.VariableFilter> variableFilters;

    public InputArgumentsComposite(Composite parent) {
        this(parent, 18, Messages.InputArguments_label);
    }

    public InputArgumentsComposite(Composite parent, String label) {
        this(parent, 18, label);
    }

    public InputArgumentsComposite(Composite parent, int style, String label) {
        super(parent, 0);
        this.style = style;
        this.label = label;
        this.createControls();
    }

    public void setVariableResolver(VariableText2 variableResolver) {
        this.variableResolver = variableResolver;
    }

    public VariableText2 getVariableResolver() {
        return this.variableResolver;
    }

    public void setVariableFilter(ImList<StringVariableSelectionDialog.VariableFilter> variableFilters) {
        this.variableFilters = variableFilters;
    }

    public ImList<StringVariableSelectionDialog.VariableFilter> getVariableFilters() {
        return this.variableFilters;
    }

    private void createControls() {
        InputArgumentsComposite container = this;
        GridLayout layout = LayoutUtils.newCompositeGrid((int)2);
        layout.horizontalSpacing = 0;
        container.setLayout((Layout)layout);
        if ((this.style & 0x10) != 0) {
            Label label = new Label((Composite)container, 16384);
            label.setText(this.label);
            label.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        }
        this.textControl = new Text((Composite)container, (this.style & 4) != 0 ? 18436 : 19010);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = LayoutUtils.hintWidth((Text)this.textControl, (int)-1);
        if ((this.style & 0x10) != 0) {
            gd.heightHint = new PixelConverter((Control)this.textControl).convertHeightInCharsToPixels(4);
        }
        this.textControl.setLayoutData((Object)gd);
        WidgetToolsButton tools = new WidgetToolsButton((Control)this.textControl){

            protected void fillMenu(Menu menu) {
                InputArgumentsComposite.this.fillToolMenu(menu);
            }
        };
        tools.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
    }

    protected void fillToolMenu(Menu menu) {
        MenuItem item = new MenuItem(menu, 8);
        item.setText(Messages.InsertVariable_label);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputArgumentsComposite.this.handleVariablesButton();
            }
        });
    }

    protected void handleVariablesButton() {
        Map extraVariables;
        CustomizableVariableSelectionDialog dialog = new CustomizableVariableSelectionDialog(this.getShell());
        if (this.variableResolver != null && (extraVariables = this.variableResolver.getExtraVariables()) != null) {
            dialog.setAdditionals(extraVariables.values());
        }
        if (this.variableFilters != null) {
            dialog.setFilters(this.variableFilters);
        }
        if (dialog.open() != 0) {
            return;
        }
        String variable = dialog.getVariableExpression();
        if (variable == null) {
            return;
        }
        this.insertText(variable);
    }

    protected void insertText(String text) {
        this.getTextControl().insert(text);
        this.getTextControl().setFocus();
    }

    public Text getTextControl() {
        return this.textControl;
    }

    public String getNoteText() {
        return Messages.InputArguments_note;
    }
}

