/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.statet.docmlet.wikitext.core.IWikitextCoreAccess;
import org.eclipse.statet.ecommons.preferences.core.util.PreferenceUtils;
import org.eclipse.statet.internal.docmlet.wikitext.core.WikitextCoreAccess;
import org.eclipse.statet.internal.docmlet.wikitext.core.model.WikitextModelManager;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.osgi.framework.BundleContext;

public class WikitextCorePlugin
extends Plugin {
    private static WikitextCorePlugin instance;
    private boolean started;
    private List<Disposable> disposables;
    private WikitextModelManager wikitextModelManager;
    private WikitextCoreAccess workbenchCoreAccess;
    private WikitextCoreAccess defaultsCoreAccess;

    public static WikitextCorePlugin getInstance() {
        return instance;
    }

    public static final void log(IStatus status) {
        WikitextCorePlugin plugin = WikitextCorePlugin.getInstance();
        if (plugin != null) {
            plugin.getLog().log(status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
        this.disposables = new ArrayList<Disposable>();
        this.workbenchCoreAccess = new WikitextCoreAccess(PreferenceUtils.getInstancePrefs());
        this.wikitextModelManager = new WikitextModelManager();
        this.disposables.add(this.wikitextModelManager);
        WikitextCorePlugin wikitextCorePlugin = this;
        synchronized (wikitextCorePlugin) {
            this.started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        try {
            WikitextCorePlugin wikitextCorePlugin = this;
            synchronized (wikitextCorePlugin) {
                this.started = false;
                this.wikitextModelManager = null;
            }
            if (this.workbenchCoreAccess != null) {
                this.workbenchCoreAccess.dispose();
                this.workbenchCoreAccess = null;
            }
            if (this.defaultsCoreAccess != null) {
                this.defaultsCoreAccess.dispose();
                this.defaultsCoreAccess = null;
            }
            for (Disposable listener : this.disposables) {
                try {
                    listener.dispose();
                }
                catch (Throwable e) {
                    WikitextCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.docmlet.wikitext.core", "Error occured while disposing a module.", e));
                }
            }
            this.disposables = null;
        }
        finally {
            instance = null;
            super.stop(context);
        }
    }

    private void checkStarted() {
        if (!this.started) {
            throw new IllegalStateException("Plug-in is not started.");
        }
    }

    public WikitextModelManager getWikidocModelManager() {
        return this.wikitextModelManager;
    }

    public synchronized IWikitextCoreAccess getWorkbenchAccess() {
        if (this.workbenchCoreAccess == null) {
            this.checkStarted();
        }
        return this.workbenchCoreAccess;
    }

    public synchronized IWikitextCoreAccess getDefaultsAccess() {
        if (this.defaultsCoreAccess == null) {
            this.checkStarted();
            this.defaultsCoreAccess = new WikitextCoreAccess(PreferenceUtils.getDefaultPrefs());
        }
        return this.defaultsCoreAccess;
    }
}

