/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.examples.hummingbird20.check.withcatalog;

import java.text.MessageFormat;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sphinx.emf.check.AbstractCheckValidator;
import org.eclipse.sphinx.emf.check.Check;
import org.eclipse.sphinx.emf.check.CheckValidatorRegistry;
import org.eclipse.sphinx.examples.hummingbird20.common.Common20Package;
import org.eclipse.sphinx.examples.hummingbird20.common.Identifiable;
import org.eclipse.sphinx.examples.hummingbird20.instancemodel.Application;
import org.eclipse.sphinx.examples.hummingbird20.instancemodel.Component;
import org.eclipse.sphinx.examples.hummingbird20.instancemodel.InstanceModel20Package;
import org.eclipse.sphinx.examples.hummingbird20.instancemodel.ParameterValue;

public class Hummingbird20NamingAndValuesCheckValidator
extends AbstractCheckValidator {
    private static final Pattern ILLEGAL_CHARACTERS_PATTERN = Pattern.compile("[ \\t\\.,;]");
    public static final String ISSUE_MSG_ARGUMENT_CATEGORIES_CASE1 = "(Case #1: part of Category1 and Category2 as per check catalog and blank check annotation)";
    public static final String ISSUE_MSG_ARGUMENT_CATEGORIES_CASE2 = "(Case #2: part of Category1 and Category2 as per check catalog and check annotation)";
    public static final String ISSUE_MSG_ARGUMENT_CATEGORIES_CASE3 = "(Case #3: only part of Category1 as per check catalog and narrowed down by check annotation)";
    public static final String ISSUE_MSG_ARGUMENT_CATEGORIES_CASE4 = "(Case #4: only part of Category2 as per intersection of check catalog with partly disjunct check annotation)";
    public static final String ISSUE_MSG_ARGUMENT_CATEGORIES_CASE5 = "(Case #5: not part of any category due to check catalog and check annotation being completely disjunct)";
    public static final String ISSUE_MSG_ARGUMENT_FORMAT_SUPERTYPE = "(Checked applicable subtype: {0})";

    public Hummingbird20NamingAndValuesCheckValidator() {
    }

    public Hummingbird20NamingAndValuesCheckValidator(CheckValidatorRegistry checkValidatorRegistry) {
        super(checkValidatorRegistry);
    }

    @Check(constraint="ApplicationNameNotValid")
    void checkApplicationName(Application application) {
        this.issue((EObject)application, (EStructuralFeature)Common20Package.Literals.IDENTIFIABLE__NAME, new Object[]{ISSUE_MSG_ARGUMENT_CATEGORIES_CASE1});
    }

    @Check(constraint="ApplicationNameNotValid", categories={"Category1", "Category2"})
    void checkApplicationNameForCategories1And2(Application application) {
        this.issue((EObject)application, (EStructuralFeature)Common20Package.Literals.IDENTIFIABLE__NAME, new Object[]{ISSUE_MSG_ARGUMENT_CATEGORIES_CASE2});
    }

    @Check(constraint="ApplicationNameNotValid", categories={"Category1"})
    void checkApplicationNameForCategory1(Application application) {
        this.issue((EObject)application, (EStructuralFeature)Common20Package.Literals.IDENTIFIABLE__NAME, new Object[]{ISSUE_MSG_ARGUMENT_CATEGORIES_CASE3});
    }

    @Check(constraint="ApplicationNameNotValid", categories={"Category2", "Category3"})
    void checkApplicationNameForCategory2And3(Application application) {
        this.issue((EObject)application, (EStructuralFeature)Common20Package.Literals.IDENTIFIABLE__NAME, new Object[]{ISSUE_MSG_ARGUMENT_CATEGORIES_CASE4});
    }

    @Check(constraint="ApplicationNameNotValid", categories={"Category3"})
    void checkApplicationNameForCategory3(Application application) {
        this.issue((EObject)application, (EStructuralFeature)Common20Package.Literals.IDENTIFIABLE__NAME, new Object[]{ISSUE_MSG_ARGUMENT_CATEGORIES_CASE5});
    }

    @Check(constraint="ComponentNameNotValid", categories={"Category1"})
    void checkComponentName(Component component) {
        if (!this.hasValidName((Identifiable)component)) {
            this.issue((EObject)component, (EStructuralFeature)Common20Package.Literals.IDENTIFIABLE__DESCRIPTION, new Object[]{component.getName()});
        }
    }

    @Check(constraint="ParameterValuesNotValid", categories={"Category2"})
    void checkComponentValues(Component component) {
        EList parameterValues = component.getParameterValues();
        for (ParameterValue value : parameterValues) {
            try {
                Integer.parseInt(value.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                this.issue((EObject)value, (EStructuralFeature)InstanceModel20Package.Literals.PARAMETER_VALUE__VALUE, new Object[0]);
            }
        }
    }

    @Check(constraint="IdentifiableNameNotValid")
    void checkIdentifiableName(Identifiable identifiable) {
        this.issue((EObject)identifiable, (EStructuralFeature)Common20Package.Literals.IDENTIFIABLE__NAME, new Object[]{MessageFormat.format(ISSUE_MSG_ARGUMENT_FORMAT_SUPERTYPE, identifiable.eClass().getName())});
    }

    private boolean hasValidName(Identifiable identifiable) {
        Assert.isNotNull((Object)identifiable);
        return !ILLEGAL_CHARACTERS_PATTERN.matcher(identifiable.getName()).find();
    }
}

