/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.check.services;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sphinx.emf.check.internal.Activator;
import org.eclipse.sphinx.emf.check.internal.messages.Messages;
import org.eclipse.sphinx.emf.check.services.CheckProblemMarkerFactory;
import org.eclipse.sphinx.emf.check.services.ICheckValidationProblemMarkerFactory;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.util.EcoreResourceUtil;
import org.eclipse.sphinx.platform.util.StatusUtil;

public class CheckProblemMarkerService {
    public static final String UPDATE_CHECK_PROBLEM_MARKER = "UPDATE_CHECK_PROBLEM_MARKER";
    public static CheckProblemMarkerService INSTANCE = new CheckProblemMarkerService();
    private ICheckValidationProblemMarkerFactory markerFactory = null;

    protected CheckProblemMarkerService() {
    }

    private ICheckValidationProblemMarkerFactory getProblemMarkerFactory() {
        if (this.markerFactory == null) {
            this.markerFactory = this.createProblemMarkerFactory();
        }
        return this.markerFactory;
    }

    private ICheckValidationProblemMarkerFactory createProblemMarkerFactory() {
        return new CheckProblemMarkerFactory();
    }

    public void updateProblemMarkers(EObject validationInput, final Diagnostic diagnostic) {
        WorkspaceJob job = new WorkspaceJob(Messages.job_handlingDiagnostics_label){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                try {
                    CheckProblemMarkerService.this.handleDiagnostic(diagnostic);
                }
                catch (CoreException ex) {
                    return ex.getStatus();
                }
                catch (Exception ex) {
                    return StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)ex);
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return CheckProblemMarkerService.UPDATE_CHECK_PROBLEM_MARKER.equals(family);
            }
        };
        ArrayList<ISchedulingRule> myRules = new ArrayList<ISchedulingRule>();
        IFile resource = EcorePlatformUtil.getFile((EObject)validationInput);
        if (resource != null) {
            IResourceRuleFactory ruleFactory = resource.getWorkspace().getRuleFactory();
            myRules.add(ruleFactory.modifyRule((IResource)resource));
            myRules.add(ruleFactory.createRule((IResource)resource));
        }
        job.setRule((ISchedulingRule)new MultiRule(myRules.toArray(new ISchedulingRule[myRules.size()])));
        job.setPriority(40);
        job.schedule();
    }

    public void handleDiagnostic(Diagnostic diagnostic) throws CoreException {
        this.handleDiagnostic(diagnostic, 2);
    }

    public void handleDiagnostic(Diagnostic diagnostic, int depth) throws CoreException {
        Assert.isNotNull((Object)diagnostic);
        if (diagnostic.getData() == null) {
            return;
        }
        List diagnosticData = diagnostic.getData();
        if (diagnosticData.isEmpty() || !(diagnosticData.get(0) instanceof EObject)) {
            return;
        }
        EObject eObject = (EObject)diagnosticData.get(0);
        if (diagnostic.getSeverity() == 0) {
            this.deleteMarkers(eObject, depth);
        } else {
            Resource resource = eObject.eResource();
            if (resource != null) {
                this.deleteMarkers(eObject, depth);
                this.addMarkers(resource, diagnostic);
            }
        }
    }

    private void addMarkers(Resource resource, Diagnostic diagnostic) throws CoreException {
        IFile file = EcorePlatformUtil.getFile((Resource)resource);
        if (file == null || !file.exists()) {
            return;
        }
        List diagnosticData = diagnostic.getData();
        if (diagnosticData == null || diagnosticData.size() == 0) {
            return;
        }
        for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
            if (childDiagnostic.getData().isEmpty()) continue;
            this.getProblemMarkerFactory().createMarker((IResource)file, childDiagnostic);
        }
    }

    private void deleteMarkers(EObject eObject, int depth) throws CoreException {
        this.deleteMarkers(eObject, depth, "org.eclipse.sphinx.emf.check.checkvalidationproblemmarker");
    }

    private void deleteMarkers(EObject eObject, int depth, String markerType) throws CoreException {
        EObject rootObject;
        Resource resource = eObject.eResource();
        if (resource != null && resource.getContents() != null && (rootObject = (EObject)resource.getContents().get(0)) == eObject && depth == 2) {
            this.getProblemMarkerFactory().deleteMarkers(resource);
            return;
        }
        IMarker[] markers = this.getValidationMarkers(eObject, depth, markerType);
        if (markers == null || markers.length == 0) {
            return;
        }
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            marker.delete();
            ++n2;
        }
    }

    public IMarker[] getValidationMarkers(EObject eObject) throws CoreException, InterruptedException {
        return this.getValidationMarkers(eObject, 2, "org.eclipse.sphinx.emf.check.checkvalidationproblemmarker");
    }

    public IMarker[] getValidationMarkers(EObject eObject, int depth) throws CoreException {
        Job[] jobs = Job.getJobManager().find((Object)UPDATE_CHECK_PROBLEM_MARKER);
        if (jobs.length > 0) {
            try {
                jobs[0].join();
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.getValidationMarkers(eObject, depth, "org.eclipse.sphinx.emf.check.checkvalidationproblemmarker");
    }

    private IMarker[] getValidationMarkers(EObject eObject, int depth, String markerType) throws CoreException {
        IFile resource = EcorePlatformUtil.getFile((EObject)eObject);
        if (resource == null || !resource.exists()) {
            return new IMarker[0];
        }
        IMarker[] allMarkers = resource.findMarkers(markerType, true, 2);
        ArrayList<IMarker> result = new ArrayList<IMarker>();
        URI referenceURI = EcoreResourceUtil.getURI((EObject)eObject);
        IMarker[] iMarkerArray = allMarkers;
        int n = allMarkers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker current = iMarkerArray[n2];
            String currentStringURI = (String)current.getAttribute("uri");
            if (currentStringURI != null) {
                URI currentURI = URI.createURI((String)currentStringURI);
                switch (depth) {
                    case 0: {
                        if (!currentURI.equals(referenceURI)) break;
                        result.add(current);
                        break;
                    }
                    case 1: {
                        if (!currentURI.equals(referenceURI)) break;
                        result.add(current);
                        break;
                    }
                    case 2: {
                        if (currentURI.equals(referenceURI)) {
                            result.add(current);
                            break;
                        }
                        if (!this.contains(currentURI, referenceURI)) break;
                        result.add(current);
                        break;
                    }
                }
            }
            ++n2;
        }
        return result.toArray(new IMarker[result.size()]);
    }

    protected boolean contains(URI uri, URI anotherURI) {
        if (uri != null && anotherURI != null) {
            return uri.toString().contains(anotherURI.toString());
        }
        return false;
    }
}

