/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.validation.ui.views;

import com.ibm.icu.text.CollationKey;
import com.ibm.icu.text.Collator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.sphinx.emf.validation.ui.views.MarkerMessages;
import org.eclipse.sphinx.emf.validation.ui.views.MarkerNode;
import org.eclipse.sphinx.emf.validation.ui.views.Util;
import org.eclipse.sphinx.emf.validation.util.ValidationUtil;

public class ConcreteMarker
extends MarkerNode {
    private String resourceName;
    private String inFolder;
    private String eObjectID;
    private String URIToDisplay;
    private String eObjectType;
    private CollationKey descriptionKey;
    private CollationKey resourceNameKey;
    private int line;
    private String locationString;
    private long creationTime;
    private String type;
    private IMarker marker;
    private long id = -1L;
    private MarkerNode markerCategory;
    private String shortFolder;
    private Object group;

    public ConcreteMarker(IMarker toCopy) {
        this.marker = toCopy;
        this.refresh();
    }

    public void clearCache() {
        this.resourceNameKey = null;
        this.descriptionKey = null;
    }

    public void refresh() {
        boolean validationProblem;
        this.clearCache();
        this.resourceName = Util.getResourceName(this.marker);
        this.inFolder = Util.getContainerName(this.marker);
        this.shortFolder = null;
        this.line = this.marker.getAttribute("lineNumber", -1);
        this.locationString = this.marker.getAttribute("location", Util.EMPTY_STRING);
        try {
            validationProblem = this.marker.isSubtypeOf("sphinx.emf.validation.problem.marker");
        }
        catch (CoreException coreException) {
            validationProblem = false;
        }
        if (validationProblem) {
            String uri = this.marker.getAttribute("uri", MarkerMessages.no_available_data);
            this.URIToDisplay = ValidationUtil.getSegment((String)uri);
            try {
                Object object = this.marker.getAttribute("eobject_id");
                this.eObjectID = object == null ? ValidationUtil.getObjectId((String)uri) : (String)object;
                this.eObjectType = ValidationUtil.getObjectType((String)uri);
            }
            catch (CoreException coreException) {
                this.eObjectID = MarkerMessages.no_available_data;
            }
        } else {
            this.eObjectID = MarkerMessages.no_available_data;
            this.URIToDisplay = MarkerMessages.no_available_data;
            this.eObjectType = MarkerMessages.no_available_data;
        }
        try {
            this.creationTime = this.marker.getCreationTime();
        }
        catch (CoreException coreException) {
            this.creationTime = 0L;
        }
        try {
            this.type = this.marker.getType();
        }
        catch (CoreException coreException) {
            this.type = Util.EMPTY_STRING;
        }
        this.id = this.marker.getId();
    }

    public IResource getResource() {
        return this.marker.getResource();
    }

    public String getType() {
        return this.type;
    }

    public String getEObjectID() {
        return this.eObjectID;
    }

    public String getEObjectType() {
        return this.eObjectType;
    }

    public String getURIToDisplay() {
        return this.URIToDisplay;
    }

    public String getDescription() {
        return Util.getProperty("message", this.marker);
    }

    public CollationKey getDescriptionKey() {
        if (this.descriptionKey == null) {
            this.descriptionKey = Collator.getInstance().getCollationKey(this.getDescription());
        }
        return this.descriptionKey;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public CollationKey getResourceNameKey() {
        if (this.resourceNameKey == null) {
            this.resourceNameKey = Collator.getInstance().getCollationKey(this.resourceName);
        }
        return this.resourceNameKey;
    }

    public int getLine() {
        return this.line;
    }

    public String getFolder() {
        return this.inFolder;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getId() {
        return this.id;
    }

    public IMarker getMarker() {
        return this.marker;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ConcreteMarker)) {
            return false;
        }
        ConcreteMarker other = (ConcreteMarker)object;
        return other.getMarker().equals((Object)this.getMarker());
    }

    public int hashCode() {
        return this.getMarker().hashCode();
    }

    public void setCategory(MarkerNode category) {
        this.markerCategory = category;
    }

    public MarkerNode[] getChildren() {
        return Util.EMPTY_MARKER_ARRAY;
    }

    public MarkerNode getParent() {
        return this.markerCategory;
    }

    public boolean isConcrete() {
        return true;
    }

    public String getShortFolder() {
        if (this.shortFolder == null) {
            this.shortFolder = Util.getShortContainerName(this.marker);
        }
        return this.shortFolder;
    }

    public String getLocationString() {
        return this.locationString;
    }

    public Object getGroup() {
        return this.group;
    }

    public void setGroup(Object group) {
        this.group = group;
    }

    public ConcreteMarker getConcreteRepresentative() {
        return this;
    }
}

