/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.validation.ui.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.sphinx.emf.validation.ui.views.ConcreteMarker;
import org.eclipse.sphinx.emf.validation.ui.views.MarkerFilter;
import org.eclipse.sphinx.emf.validation.ui.views.ProblemMarker;

public class MarkerList {
    private int[] markerCounts = null;
    private ConcreteMarker[] markers;
    private Map markerTable;

    public MarkerList() {
        this(new ConcreteMarker[0]);
    }

    public MarkerList(Collection markers) {
        this(markers.toArray(new ConcreteMarker[markers.size()]));
    }

    public MarkerList(ConcreteMarker[] markers) {
        this.markers = markers;
    }

    public void clearCache() {
        ConcreteMarker[] concreteMarkerArray = this.markers;
        int n = this.markers.length;
        int n2 = 0;
        while (n2 < n) {
            ConcreteMarker marker = concreteMarkerArray[n2];
            marker.clearCache();
            ++n2;
        }
        this.markerTable = null;
    }

    private Map getMarkerMap() {
        if (this.markerTable == null) {
            this.markerTable = new HashMap();
            ConcreteMarker[] concreteMarkerArray = this.markers;
            int n = this.markers.length;
            int n2 = 0;
            while (n2 < n) {
                ConcreteMarker marker = concreteMarkerArray[n2];
                this.markerTable.put(marker.getMarker(), marker);
                ++n2;
            }
        }
        return this.markerTable;
    }

    public ConcreteMarker getMarker(IMarker toFind) {
        return (ConcreteMarker)this.getMarkerMap().get(toFind);
    }

    public IMarker[] getIMarkers() {
        IMarker[] iMarkers = new IMarker[this.markers.length];
        int i = 0;
        while (i < this.markers.length) {
            iMarkers[i] = this.markers[i].getMarker();
            ++i;
        }
        return iMarkers;
    }

    public static ConcreteMarker createMarker(IMarker marker) throws CoreException {
        if (marker.isSubtypeOf("org.eclipse.core.resources.problemmarker")) {
            return new ProblemMarker(marker);
        }
        return new ConcreteMarker(marker);
    }

    public void refresh() {
        ConcreteMarker[] concreteMarkerArray = this.markers;
        int n = this.markers.length;
        int n2 = 0;
        while (n2 < n) {
            ConcreteMarker next = concreteMarkerArray[n2];
            next.refresh();
            ++n2;
        }
    }

    public List asList() {
        return Arrays.asList(this.markers);
    }

    public MarkerList findMarkers(Collection ofIMarker) {
        ArrayList<ConcreteMarker> result = new ArrayList<ConcreteMarker>(ofIMarker.size());
        for (IMarker next : ofIMarker) {
            ConcreteMarker marker = this.getMarker(next);
            if (marker == null) continue;
            result.add(marker);
        }
        return new MarkerList(result);
    }

    public static ConcreteMarker[] createMarkers(IMarker[] source) throws CoreException {
        ConcreteMarker[] result = new ConcreteMarker[source.length];
        int idx = 0;
        while (idx < source.length) {
            result[idx] = MarkerList.createMarker(source[idx]);
            ++idx;
        }
        return result;
    }

    public static MarkerList compute(MarkerFilter[] filters, IProgressMonitor mon, boolean ignoreExceptions) throws CoreException {
        HashSet returnMarkers = new HashSet();
        MarkerFilter[] markerFilterArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            MarkerFilter element = markerFilterArray[n2];
            returnMarkers.addAll(element.findMarkers(mon, ignoreExceptions));
            ++n2;
        }
        return new MarkerList(returnMarkers);
    }

    public static IMarker[] compute(String[] types) throws CoreException {
        ArrayList<IMarker> result = new ArrayList<IMarker>();
        IWorkspaceRoot input = ResourcesPlugin.getWorkspace().getRoot();
        String[] stringArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            IMarker[] newMarkers = input.findMarkers(element, true, 2);
            result.addAll(Arrays.asList(newMarkers));
            ++n2;
        }
        return result.toArray(new IMarker[result.size()]);
    }

    public ConcreteMarker[] toArray() {
        return this.markers;
    }

    public int getItemCount() {
        return this.markers.length;
    }

    public int getErrors() {
        return this.getMarkerCounts()[2];
    }

    public int getInfos() {
        return this.getMarkerCounts()[0];
    }

    public int getWarnings() {
        return this.getMarkerCounts()[1];
    }

    private int[] getMarkerCounts() {
        if (this.markerCounts == null) {
            this.markerCounts = new int[3];
            ConcreteMarker[] concreteMarkerArray = this.markers;
            int n = this.markers.length;
            int n2 = 0;
            while (n2 < n) {
                int severity;
                ConcreteMarker marker = concreteMarkerArray[n2];
                if (marker instanceof ProblemMarker && (severity = ((ProblemMarker)marker).getSeverity()) >= 0 && severity <= 2) {
                    int n3 = severity;
                    this.markerCounts[n3] = this.markerCounts[n3] + 1;
                }
                ++n2;
            }
        }
        return this.markerCounts;
    }

    public Object[] getArray() {
        return this.markers;
    }

    public int getSize() {
        return this.getArray().length;
    }

    public ConcreteMarker getMarker(int index) {
        return this.markers[index];
    }

    public void updateMarkers(Collection addedMarkers, Collection removedMarkers) {
        ArrayList list = new ArrayList(this.asList());
        list.addAll(addedMarkers);
        list.removeAll(removedMarkers);
        this.markers = new ConcreteMarker[list.size()];
        list.toArray(this.markers);
    }

    public void refreshAll() {
        ConcreteMarker[] concreteMarkerArray = this.markers;
        int n = this.markers.length;
        int n2 = 0;
        while (n2 < n) {
            ConcreteMarker element = concreteMarkerArray[n2];
            element.refresh();
            ++n2;
        }
    }

    public void clearGroups() {
        ConcreteMarker[] concreteMarkerArray = this.markers;
        int n = this.markers.length;
        int n2 = 0;
        while (n2 < n) {
            ConcreteMarker element = concreteMarkerArray[n2];
            element.setGroup(null);
            ++n2;
        }
    }
}

