/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.rectpacking.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.elk.alg.rectpacking.util.Block;
import org.eclipse.elk.alg.rectpacking.util.BlockStack;

public class RectRow {
    private double height = 0.0;
    private double width = 0.0;
    private double y;
    private double nodeNodeSpacing;
    private final List<Block> children = new ArrayList<Block>();
    private List<BlockStack> stacks = new ArrayList<BlockStack>();
    private double potentialAdditionalWidthToGetLastBlock = 0.0;

    public RectRow(double y, double nodeNodeSpacing) {
        this.y = y;
        this.nodeNodeSpacing = nodeNodeSpacing;
    }

    protected void notifyAboutNodeChange() {
        double totalStackWidth = 0.0;
        double newMaxHeight = Double.NEGATIVE_INFINITY;
        int index = 0;
        for (Block child : this.children) {
            totalStackWidth += child.getWidth() + (index > 0 ? this.nodeNodeSpacing : 0.0);
            newMaxHeight = Math.max(newMaxHeight, child.getHeight());
            ++index;
        }
        this.width = totalStackWidth;
        this.height = newMaxHeight;
    }

    public void expand(double width, double additionalHeight) {
        double additionalWidth = width - this.width;
        double additionalWidthPerStack = additionalWidth / (double)this.stacks.size();
        int index = 0;
        for (BlockStack stack : this.stacks) {
            double additionalHeightForStack = this.getHeight() - stack.getHeight() + additionalHeight;
            stack.setLocation(stack.getX() + (double)index * additionalWidthPerStack, stack.getY());
            stack.expand(additionalWidthPerStack, additionalHeightForStack);
            ++index;
        }
    }

    public void calculateBlockStacks() {
        double currentX = -1.0;
        for (Block block : this.children) {
            if (block.getX() != currentX) {
                this.stacks.add(new BlockStack(block.getX(), this.y, this.nodeNodeSpacing));
                this.stacks.get(this.stacks.size() - 1).addBlock(block);
                currentX = block.getX();
                continue;
            }
            this.stacks.get(this.stacks.size() - 1).addBlock(block);
        }
    }

    public Block getFirstBlock() {
        return this.children.get(0);
    }

    public Block getLastBlock() {
        return this.children.get(this.children.size() - 1);
    }

    public int getNumberOfAssignedBlocks() {
        return this.children.size();
    }

    public void addBlock(Block block) {
        this.height = Math.max(this.height, block.getHeight());
        this.width += block.getWidth() + (this.children.isEmpty() ? 0.0 : this.nodeNodeSpacing);
        this.children.add(block);
    }

    public void removeBlock(Block block) {
        this.children.remove(block);
        this.width -= block.getWidth() + (this.children.isEmpty() ? 0.0 : this.nodeNodeSpacing);
        double newMaxHeight = Double.MIN_VALUE;
        for (Block child : this.children) {
            newMaxHeight = Math.max(newMaxHeight, child.getHeight());
        }
        this.height = newMaxHeight;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        double yChange = y - this.y;
        for (BlockStack stack : this.stacks) {
            stack.setLocation(stack.getX(), stack.getY() + yChange);
        }
        this.y = y;
    }

    public List<Block> getChildren() {
        return this.children;
    }

    public List<BlockStack> getStacks() {
        return this.stacks;
    }

    public double getPotentialAdditionalWidthToGetLastBlock() {
        return this.potentialAdditionalWidthToGetLastBlock;
    }

    public void setPotentialAdditionalWidthToGetLastBlock(double potentialAdditionalWidthToGetLastBlock) {
        this.potentialAdditionalWidthToGetLastBlock = potentialAdditionalWidthToGetLastBlock;
    }

    public void resetStacks() {
        this.stacks = new ArrayList<BlockStack>();
    }
}

