/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tools.internal.validation.description.constraints;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.emf.validation.service.ConstraintRegistry;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.sirius.business.api.dialect.description.MultiLanguagesValidator;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterContext;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterStatus;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.tools.internal.interpreter.SiriusInterpreterContextFactory;
import org.eclipse.sirius.tools.internal.validation.AbstractConstraint;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;

public class ValidInterpretedExpressionConstraint
extends AbstractConstraint {
    public IStatus validate(IValidationContext ctx) {
        EObject target = ctx.getTarget();
        LinkedHashSet<IStatus> statuses = new LinkedHashSet<IStatus>();
        for (EAttribute feature : target.eClass().getEAllAttributes()) {
            IStatus status;
            if (!DescriptionPackage.eINSTANCE.getInterpretedExpression().equals(feature.getEAttributeType()) || (status = this.checkExpression(ctx, target, (EStructuralFeature)feature)) == null) continue;
            statuses.add(status);
        }
        if (statuses.isEmpty()) {
            return ctx.createSuccessStatus();
        }
        IStatus returnStatus = statuses.size() == 1 ? (IStatus)statuses.iterator().next() : ConstraintStatus.createMultiStatus((IValidationContext)ctx, statuses);
        return returnStatus;
    }

    private IStatus checkExpression(IValidationContext ctx, EObject target, EStructuralFeature feature) {
        String expression = (String)target.eGet(feature);
        LinkedHashSet<ConstraintStatus> statuses = new LinkedHashSet<ConstraintStatus>();
        Collection errors = new LinkedHashSet();
        Set<EObject> locus = Collections.singleton(target);
        if (!StringUtil.isEmpty((String)expression)) {
            try {
                IInterpreterContext context = SiriusInterpreterContextFactory.createInterpreterContext(target, feature);
                errors = MultiLanguagesValidator.getInstance().validateExpression(context, expression).getStatuses();
            }
            catch (Exception e) {
                statuses.add(ConstraintStatus.createStatus((IValidationContext)ctx, locus, (String)e.getMessage(), (Object[])new Object[0]));
            }
        }
        if (errors.isEmpty()) {
            return null;
        }
        for (IInterpreterStatus interpreterStatus : errors) {
            statuses.add(this.createStatus(ctx, locus, interpreterStatus, new Object[0]));
        }
        IStatus returnStatus = statuses.size() == 1 ? (IStatus)statuses.iterator().next() : ConstraintStatus.createMultiStatus((IValidationContext)ctx, statuses);
        return returnStatus;
    }

    private ConstraintStatus createStatus(IValidationContext ctx, Collection<EObject> resultLocus, IInterpreterStatus status, Object ... messageArguments) {
        IConstraintDescriptor desc = ConstraintRegistry.getInstance().getDescriptor(ctx.getCurrentConstraintId());
        int severity = desc.getSeverity().toIStatusSeverity();
        if ("warning".equals(status.getSeverity())) {
            severity = 2;
        } else if ("error".equals(status.getSeverity())) {
            severity = 4;
        } else if ("info".equals(status.getSeverity())) {
            severity = 1;
        }
        return ConstraintStatus.createStatus((IValidationContext)ctx, null, resultLocus, (int)severity, (int)desc.getStatusCode(), (String)status.getMessage(), (Object[])messageArguments);
    }
}

