/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tools.internal.interpreter;

import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.sirius.tools.api.SiriusPlugin;

public abstract class EvaluationErrorHandler {
    public static final EvaluationErrorHandler IGNORE = new EvaluationErrorHandler(){

        @Override
        public void handleException(Exception ex) {
        }
    };
    public static final EvaluationErrorHandler ROLLBACK = new EvaluationErrorHandler(){

        @Override
        public void handleException(Exception ex) {
            this.requestTransactionRollback(ex);
        }
    };

    public abstract void handleException(Exception var1);

    protected void logError(String message, Exception ex) {
        SiriusPlugin.getDefault().error(message, ex);
    }

    protected void logWarning(String message, Exception ex) {
        SiriusPlugin.getDefault().warning(message, ex);
    }

    protected void requestTransactionRollback(Exception cause) {
        OperationCanceledException cancel = new OperationCanceledException();
        cancel.initCause(cause);
        throw cancel;
    }
}

