/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.image;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.tools.api.Messages;
import org.eclipse.sirius.tools.api.SiriusPlugin;

public interface ImageManager {
    public static final String IMAGE_FOLDER_NAME = "images";
    public static final String HTML_IMAGE_PATH_PATTERN = "<img.*?src=\"(.*?)\".*?/>";
    public static final String IMAGE_NAME_FORMAT = "yyyyMMdd_HHmmss_SSSSSS";

    public static String generateName(String extension) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(IMAGE_NAME_FORMAT).withZone(ZoneId.systemDefault());
        String strDate = formatter.format(Instant.now());
        return strDate + "." + extension;
    }

    public CreateImageFileProvider getCreateFileFunc(EObject var1, String var2, String var3) throws IOException, CoreException;

    public CreateImageFileProvider getCreateFileFunc(EObject var1, String var2, InputStream var3) throws CoreException, IOException;

    public void undoCreatedFiles(Session var1, Map<String, String> var2);

    public void redoCreateFiles(Session var1, Map<String, String> var2);

    public String computeAndConvertPathsToHtmlFromOriginal(EObject var1, String var2);

    public String convertToOriginalPathFromPathUsedForHtml(EObject var1, String var2);

    public static final class CreateImageFileProvider {
        private Supplier<Optional<CoreException>> createFileFunc;
        private String filename;

        public CreateImageFileProvider(Supplier<Optional<CoreException>> createFileFunc, String filename) {
            this.createFileFunc = createFileFunc;
            this.filename = filename;
        }

        public String getFileName() {
            return this.filename;
        }

        public void exec() throws CoreException {
            Optional<CoreException> error = this.createFileFunc.get();
            if (error.isPresent()) {
                throw error.get();
            }
        }

        public RecordingCommand asRecordingCommand(TransactionalEditingDomain domain) {
            return new RecordingCommand(domain){

                protected void doExecute() {
                    try {
                        this.exec();
                    }
                    catch (CoreException error) {
                        SiriusPlugin.getDefault().error(MessageFormat.format(Messages.ImageManager_imageCreationFailure, filename), error);
                    }
                }
            };
        }
    }
}

