/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.views;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.sirius.common.ui.tools.api.navigator.GroupingContentProvider;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.business.api.featureExtensions.FeatureExtensionsUIManager;
import org.eclipse.sirius.ui.tools.api.views.ViewHelper;
import org.eclipse.sirius.ui.tools.internal.views.common.SessionWrapperContentProvider;
import org.eclipse.sirius.ui.tools.internal.views.modelexplorer.extension.IContextMenuActionProvider;
import org.eclipse.sirius.ui.tools.internal.views.modelexplorer.extension.ISessionViewExtension;

public final class ViewHelperImpl
implements ViewHelper {
    private static Collection<ISessionViewExtension> extensions = new ArrayList<ISessionViewExtension>();

    private ViewHelperImpl() {
    }

    public static ViewHelper init() {
        return new ViewHelperImpl();
    }

    @Override
    public AdapterFactory createAdapterFactory() {
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(DialectUIManager.INSTANCE.createAdapterFactory());
        factories.add(FeatureExtensionsUIManager.INSTANCE.createAdapterFactory());
        factories.add(new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE));
        factories.add(new ReflectiveItemProviderAdapterFactory());
        return new ComposedAdapterFactory(factories);
    }

    @Override
    public ITreeContentProvider createContentProvider() {
        SessionWrapperContentProvider sessionWrapperContentProvider = new SessionWrapperContentProvider((ITreeContentProvider)new AdapterFactoryContentProvider(this.createAdapterFactory()));
        GroupingContentProvider contentProvider = new GroupingContentProvider((ITreeContentProvider)sessionWrapperContentProvider);
        Collection liveProviders = Collections2.transform(extensions, (Function)new Function<ISessionViewExtension, ITreeContentProvider>(){

            public ITreeContentProvider apply(ISessionViewExtension from) {
                return from.getContentProvider();
            }
        });
        sessionWrapperContentProvider.setExtensions(liveProviders);
        return contentProvider;
    }

    public Collection<IContextMenuActionProvider> getContextMenuActionsProviders() {
        Collection liveProviders = Collections2.transform(extensions, (Function)new Function<ISessionViewExtension, IContextMenuActionProvider>(){

            public IContextMenuActionProvider apply(ISessionViewExtension from) {
                return from.getContextMenuActionProvider();
            }
        });
        return liveProviders;
    }

    public void addExtension(ISessionViewExtension extension) {
        extensions.add(extension);
    }

    public void removeExtension(ISessionViewExtension extension) {
        extensions.remove(extension);
    }
}

