/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.model.business.internal.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.ext.emf.EClassQuery;
import org.eclipse.sirius.model.business.internal.query.DRepresentationInternalQuery;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.description.Group;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class EObjectQuery {
    private static final String BRACKET_OPEN = "{";
    private static final String BRACKET_CLOSE = "}";
    private static final String COMMA = ", ";
    private static final String COLON = ": ";
    private static final String DOUBLE_COLON = "::";
    private static final String ECLASS = "eClass";
    private static final String NAME_ATTR = "name";
    private static final String ID_ATTR = "id";
    private static final String UID_ATTR = "uid";
    protected EObject eObject;

    public EObjectQuery(EObject eObject) {
        this.eObject = eObject;
    }

    public EObject getEObject() {
        return this.eObject;
    }

    public Option<DRepresentation> getRepresentation() {
        EObject current = this.eObject;
        while (current != null) {
            if (current instanceof DRepresentation) {
                return Options.newSome((Object)((DRepresentation)current));
            }
            current = current.eContainer();
        }
        return Options.newNone();
    }

    public EObject getResourceContainer() {
        EObject result = this.eObject;
        if (this.eObject instanceof InternalEObject) {
            result = ((InternalEObject)this.eObject).eDirectResource() != null ? this.eObject : new EObjectQuery(this.eObject.eContainer()).getResourceContainer();
        }
        return result;
    }

    public Option<EObject> getFirstAncestorOfType(EClass klass) {
        EObject current = this.eObject.eContainer();
        while (current != null && !klass.isInstance((Object)current)) {
            current = current.eContainer();
        }
        if (current != null) {
            return Options.newSome((Object)current);
        }
        return Options.newNone();
    }

    public Collection<URI> getResolvedDependencies() {
        HashSet<URI> dependencies = new HashSet<URI>();
        TreeIterator iter = EcoreUtil.getAllProperContents((EObject)this.eObject, (boolean)false);
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof EObject)) continue;
            this.addResolvedDependencies((EObject)obj, dependencies);
        }
        this.addResolvedDependencies(this.eObject, dependencies);
        Resource eObjectResource = this.eObject.eResource();
        if (eObjectResource != null) {
            dependencies.remove(eObjectResource.getURI());
        }
        return dependencies;
    }

    private void addResolvedDependencies(EObject eObj, Collection<URI> dependencies) {
        for (EStructuralFeature feature : new EClassQuery(eObj.eClass()).getAllNonContainmentFeatures()) {
            if (!(feature instanceof EReference)) continue;
            EReference ref = (EReference)feature;
            Object value = eObj.eGet((EStructuralFeature)ref, false);
            this.forEachEObject(value, instance -> this.addNonProxyResourceURI((EObject)instance, dependencies));
        }
    }

    private void addNonProxyResourceURI(EObject value, Collection<URI> dependencies) {
        Resource valueResource;
        if (value != null && !value.eIsProxy() && (valueResource = value.eResource()) != this.eObject.eResource() && valueResource != null) {
            dependencies.add(valueResource.getURI());
        }
    }

    public Collection<URI> getUnresolvedDependencies() {
        HashSet<URI> dependencies = new HashSet<URI>();
        TreeIterator iter = EcoreUtil.getAllProperContents((EObject)this.eObject, (boolean)false);
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof EObject)) continue;
            this.addUnresolvedDependencies((EObject)obj, dependencies);
        }
        this.addUnresolvedDependencies(this.eObject, dependencies);
        return dependencies;
    }

    public List<EObject> getValues(EReference ref) {
        List<EObject> result = Collections.emptyList();
        if (ref.isMany()) {
            Object rawValue = this.eObject.eGet((EStructuralFeature)ref);
            if (rawValue != null && rawValue instanceof EList && !((EList)rawValue).isEmpty() && ((EList)rawValue).get(0) instanceof EObject) {
                result = new ArrayList<EObject>((Collection<EObject>)((EList)rawValue));
            }
        } else {
            EObject rawValue = (EObject)this.eObject.eGet((EStructuralFeature)ref);
            if (rawValue != null) {
                result = Collections.singletonList(rawValue);
            }
        }
        return result;
    }

    private void addUnresolvedDependencies(EObject eObj, Collection<URI> dependencies) {
        for (EStructuralFeature feature : new EClassQuery(eObj.eClass()).getAllNonContainmentFeatures()) {
            if (!(feature instanceof EReference)) continue;
            EReference ref = (EReference)feature;
            Object value = eObj.eGet((EStructuralFeature)ref, false);
            this.forEachEObject(value, instance -> this.addProxyResourceURI((EObject)instance, dependencies));
        }
    }

    private void forEachEObject(Object value, Consumer<EObject> consumer) {
        if (value instanceof Collection) {
            Collection coll = (Collection)value;
            coll.stream().filter(EObject.class::isInstance).map(EObject.class::cast).forEach(consumer);
        } else if (value instanceof EObject) {
            EObject atomicEObject = (EObject)value;
            consumer.accept(atomicEObject);
        }
    }

    private void addProxyResourceURI(EObject value, Collection<URI> dependencies) {
        if (value != null && value.eIsProxy()) {
            dependencies.add(((InternalEObject)value).eProxyURI().trimFragment());
        }
    }

    public boolean isContainedIn(EObject parentToCheck) {
        EObject current = this.eObject;
        while (current.eContainer() != null) {
            if (current.eContainer().equals(parentToCheck)) {
                return true;
            }
            current = current.eContainer();
        }
        return false;
    }

    public Collection<Viewpoint> getAvailableViewpointsInResourceSet() {
        Resource eResource = this.eObject.eResource();
        if (eResource != null) {
            ResourceSet resourceSet = eResource.getResourceSet();
            HashSet<Viewpoint> viewpoints = new HashSet<Viewpoint>();
            for (Resource resource : resourceSet.getResources()) {
                if (resource.getContents().isEmpty() || !(resource.getContents().get(0) instanceof Group)) continue;
                Group group = (Group)resource.getContents().get(0);
                viewpoints.addAll((Collection<Viewpoint>)group.getOwnedViewpoints());
            }
            return viewpoints;
        }
        return Collections.emptySet();
    }

    public DAnalysis getDAnalysis() {
        DRepresentationDescriptor representationDescriptor;
        EObject rootContainer;
        DAnalysis dAnalysis = null;
        Option<DRepresentation> representation = this.getRepresentation();
        if (representation.some() && (rootContainer = EcoreUtil.getRootContainer((EObject)(representationDescriptor = new DRepresentationInternalQuery((DRepresentation)representation.get()).getRepresentationDescriptor()), (boolean)false)) instanceof DAnalysis) {
            dAnalysis = (DAnalysis)rootContainer;
        }
        return dAnalysis;
    }

    public String getGenericDecription() {
        String uid;
        String id;
        StringBuilder sb = new StringBuilder();
        sb.append(BRACKET_OPEN).append(ECLASS).append(COLON).append(this.eObject.eClass().getEPackage().getName()).append(DOUBLE_COLON).append(this.eObject.eClass().getName());
        String name = this.getAttributeValue(NAME_ATTR);
        if (name != null) {
            sb.append(COMMA).append(NAME_ATTR).append(COLON).append(name);
        }
        if ((id = this.getAttributeValue(ID_ATTR)) != null) {
            sb.append(COMMA).append(ID_ATTR).append(COLON).append(id);
        }
        if ((uid = this.getAttributeValue(UID_ATTR)) != null) {
            sb.append(COMMA).append(UID_ATTR).append(COLON).append(uid);
        }
        sb.append(BRACKET_CLOSE);
        return sb.toString();
    }

    private String getAttributeValue(String attributeName) {
        String valueStr = null;
        EList eAllAttributes = this.eObject.eClass().getEAllAttributes();
        Optional<EAttribute> optAttribute = eAllAttributes.stream().filter(att -> att.getName() != null && att.getName().contains(attributeName)).findFirst();
        if (optAttribute.isPresent()) {
            try {
                Object value = this.eObject.eGet((EStructuralFeature)optAttribute.get());
                if (value != null) {
                    valueStr = value.toString();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return valueStr;
    }
}

