/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.editor.properties.sections.style.edgestyledescription;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.CenteringStyle;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.style.EdgeStyleDescription;
import org.eclipse.sirius.diagram.description.style.StylePackage;
import org.eclipse.sirius.editor.properties.sections.common.AbstractEditorDialogPropertySection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class EdgeStyleDescriptionCenteredSourceMappingsPropertySection
extends AbstractEditorDialogPropertySection {
    protected String getDefaultLabelText() {
        return "CenteredSourceMappings";
    }

    protected String getLabelText() {
        String labelText = super.getLabelText() + ":";
        return labelText;
    }

    protected EReference getFeature() {
        return StylePackage.eINSTANCE.getEdgeStyleDescription_CenteredSourceMappings();
    }

    protected String getFeatureAsText() {
        Object string = new String();
        if (this.eObject.eGet((EStructuralFeature)this.getFeature()) != null) {
            List values = (List)this.eObject.eGet((EStructuralFeature)this.getFeature());
            Iterator iterator = values.iterator();
            while (iterator.hasNext()) {
                EObject eObj = (EObject)iterator.next();
                string = (String)string + this.getAdapterFactoryLabelProvider(eObj).getText((Object)eObj);
                if (!iterator.hasNext()) continue;
                string = (String)string + ", ";
            }
        }
        return string;
    }

    protected boolean isEqual(List<?> newList) {
        return newList.equals(this.eObject.eGet((EStructuralFeature)this.getFeature()));
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.text.setToolTipText("The mappings for which the edge source will be centered. Deactivated if ends Centering value is \"Both\" or \"Source\" (that means the source is always centered)");
        CLabel help = this.getWidgetFactory().createCLabel(this.composite, "");
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.text, 0, 128);
        data.left = new FormAttachment((Control)this.nameLabel);
        help.setLayoutData((Object)data);
        help.setImage(this.getHelpIcon());
        help.setToolTipText("The mappings for which the edge source will be centered. Deactivated if ends Centering value is \"Both\" or \"Source\" (that means the source is always centered)");
    }

    protected boolean shouldBeReadOnly() {
        boolean value = super.shouldBeReadOnly();
        if (!value) {
            value = !this.isActivated();
        }
        return value;
    }

    public void refresh() {
        super.refresh();
        this.updateReadOnlyStatus();
    }

    private boolean isActivated() {
        if (this.eObject instanceof EdgeStyleDescription) {
            CenteringStyle current = ((EdgeStyleDescription)this.eObject).getEndsCentering();
            return current != CenteringStyle.BOTH && current != CenteringStyle.SOURCE;
        }
        return true;
    }

    protected List<?> getChoiceOfValues(List<?> currentValues) {
        List choiceOfValues = super.getChoiceOfValues(currentValues);
        this.removeUnrelatedMappings(choiceOfValues);
        Collection collection = Collections2.filter((Collection)choiceOfValues, (Predicate)Predicates.instanceOf(AbstractNodeMapping.class));
        return new ArrayList(collection);
    }

    private void removeUnrelatedMappings(List<?> choiceOfValues) {
        EObject container = this.eObject.eContainer();
        if (container instanceof EdgeMapping) {
            EList sourceMappingsList = ((EdgeMapping)container).getSourceMapping();
            choiceOfValues.retainAll((Collection<?>)sourceMappingsList);
        }
    }
}

