/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.elk.debug.gmf.layout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmf.runtime.common.core.internal.CommonCoreDebugOptions;
import org.eclipse.gmf.runtime.common.core.internal.CommonCorePlugin;
import org.eclipse.gmf.runtime.common.core.internal.l10n.CommonCoreMessages;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.core.service.IProvider;
import org.eclipse.gmf.runtime.common.core.service.IProviderChangeListener;
import org.eclipse.gmf.runtime.common.core.service.IProviderPolicy;
import org.eclipse.gmf.runtime.common.core.service.ProviderChangeEvent;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.diagram.elk.debug.gmf.layout.ProviderPriority;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public final class LayoutService {
    private static final String A_NAME = "name";
    private static final String E_PRIORITY = "Priority";
    private static final int priorityCount;
    private static final LayoutService instance;
    private static final List<String> ignoredProviders;
    private final ArrayList<ProviderDescriptor>[] providerDescriptors = new ArrayList[priorityCount];
    public static final ProviderPriority[] PRIORITIES;

    static {
        List priorities = ProviderPriority.HIGHEST.getValues();
        int maxOrdinal = 0;
        Iterator i = priorities.iterator();
        while (i.hasNext()) {
            int ordinal = ((ProviderPriority)((Object)i.next())).getOrdinal();
            if (maxOrdinal >= ordinal) continue;
            maxOrdinal = ordinal;
        }
        priorityCount = maxOrdinal + 1;
        instance = new LayoutService();
        ignoredProviders = new ArrayList<String>();
        PRIORITIES = new ProviderPriority[]{ProviderPriority.HIGHEST, ProviderPriority.HIGH, ProviderPriority.MEDIUM, ProviderPriority.LOW, ProviderPriority.LOWEST};
    }

    public static LayoutService getInstance() {
        return instance;
    }

    protected final void configureProviders(String namespace, String extensionPointName) {
        this.configureProviders(Platform.getExtensionRegistry().getExtensionPoint(namespace, extensionPointName).getConfigurationElements());
    }

    protected final void configureProviders(IConfigurationElement[] elements) {
        assert (elements != null) : "null elements";
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                this.addProviderDescriptor(ProviderPriority.parse(this.getPriority(element)), this.newProviderDescriptor(element));
            }
            finally {
                if (Trace.shouldTrace((Plugin)CommonCorePlugin.getDefault(), (String)CommonCoreDebugOptions.SERVICES_CONFIG)) {
                    IExtension extension = element.getDeclaringExtension();
                    String identifier = extension.getUniqueIdentifier();
                    if (identifier == null) {
                        identifier = String.valueOf(extension.getNamespaceIdentifier());
                    }
                    extension.getExtensionPointUniqueIdentifier();
                    Trace.trace((Plugin)CommonCorePlugin.getDefault(), (String)CommonCoreDebugOptions.SERVICES_CONFIG, (String)("Provider of '" + extension.getExtensionPointUniqueIdentifier() + "' configured from extension '" + identifier + "'."));
                }
            }
            ++n2;
        }
        int i = priorityCount;
        while (--i >= 0) {
            this.providerDescriptors[i].trimToSize();
        }
    }

    protected String getPriority(IConfigurationElement element) {
        return element.getChildren(E_PRIORITY)[0].getAttribute(A_NAME);
    }

    protected ProviderDescriptor newProviderDescriptor(IConfigurationElement element) {
        return new ProviderDescriptor(element);
    }

    protected final void addProviderDescriptor(ProviderPriority priority, ProviderDescriptor provider) {
        assert (priority != null) : "null ProviderPriority";
        assert (provider != null) : "null ProviderDescriptor";
        int ordinal = priority.getOrdinal();
        this.providerDescriptors[ordinal].add(provider);
    }

    private LayoutService() {
        int ordinal = priorityCount;
        while (--ordinal >= 0) {
            this.providerDescriptors[ordinal] = new ArrayList(0);
        }
        this.configureProviders(DiagramUIPlugin.getPluginId(), "layoutProviders");
    }

    public Option<IProvider> getMainProvider(IOperation operation) {
        ProviderPriority[] providerPriorityArray = PRIORITIES;
        int n = PRIORITIES.length;
        int n2 = 0;
        while (n2 < n) {
            ProviderPriority element = providerPriorityArray[n2];
            List<IProvider> priorityProviders = this.getProviders(element, operation);
            if (priorityProviders.size() != 0) {
                return Options.newSome((Object)priorityProviders.get(0));
            }
            ++n2;
        }
        return Options.newNone();
    }

    static boolean safeProvides(IProvider provider, IOperation operation) {
        assert (provider != null);
        try {
            return provider.provides(operation);
        }
        catch (Throwable e) {
            String providerClassName = provider.getClass().getName();
            if (!ignoredProviders.contains(providerClassName)) {
                ignoredProviders.add(providerClassName);
                Log.log((Plugin)CommonCorePlugin.getDefault(), (int)4, (int)5, (String)("Ignoring provider " + String.valueOf(provider) + " since it threw an exception or error in the provides() method"), (Throwable)e);
            }
            if (e instanceof ThreadDeath) {
                throw (ThreadDeath)e;
            }
            if (e instanceof VirtualMachineError) {
                throw (VirtualMachineError)e;
            }
            return false;
        }
    }

    protected List<IProvider> getProviders(ProviderPriority priority, IOperation operation) {
        List<ProviderDescriptor> descriptors = this.getProviderDescriptors(priority);
        for (ProviderDescriptor descriptor : descriptors) {
            if (!LayoutService.safeProvides(descriptor, operation)) continue;
            return Collections.singletonList(descriptor.getProvider());
        }
        return Collections.EMPTY_LIST;
    }

    final List<ProviderDescriptor> getProviderDescriptors(ProviderPriority priority) {
        return this.providerDescriptors[priority.getOrdinal()];
    }

    public static class ProviderDescriptor
    extends AbstractProvider
    implements IProvider,
    IProviderChangeListener {
        protected boolean policyInitialized = false;
        private String providerClassName;
        protected static final String A_CLASS = "class";
        protected static final String A_PLUGIN = "plugin";
        protected static final String E_POLICY = "Policy";
        private final IConfigurationElement element;
        protected IProvider provider;
        protected IProviderPolicy policy;
        private boolean providerClassInstantiationFailed = false;

        protected ProviderDescriptor(IConfigurationElement element) {
            this.element = element;
        }

        protected final IConfigurationElement getElement() {
            return this.element;
        }

        public IProvider getProvider() {
            if (this.provider == null && !this.providerClassInstantiationFailed) {
                CommonCorePlugin corePlugin = CommonCorePlugin.getDefault();
                try {
                    Log.info((Plugin)corePlugin, (int)0, (String)("Activating provider '" + this.element.getAttribute(A_CLASS) + "'..."));
                    this.provider = (IProvider)this.element.createExecutableExtension(A_CLASS);
                    this.provider.addProviderChangeListener((IProviderChangeListener)this);
                    Trace.trace((Plugin)corePlugin, (String)CommonCoreDebugOptions.SERVICES_ACTIVATE, (String)("Provider '" + String.valueOf(this.provider) + "' activated."));
                }
                catch (CoreException ce) {
                    if (this.provider == null) {
                        this.providerClassInstantiationFailed = true;
                    }
                    Trace.catching((Plugin)corePlugin, (String)CommonCoreDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"getProvider", (Throwable)ce);
                    IStatus status = ce.getStatus();
                    Log.log((Plugin)corePlugin, (int)status.getSeverity(), (int)5, (String)NLS.bind((String)CommonCoreMessages.serviceProviderNotActivated, (Object)this.element.getAttribute(A_CLASS)), (Throwable)status.getException());
                }
            }
            return this.provider;
        }

        protected IProviderPolicy getPolicy() {
            if (!this.policyInitialized) {
                this.policyInitialized = true;
                IConfigurationElement[] elements = this.element.getChildren(E_POLICY);
                if (elements.length != 0) {
                    CommonCorePlugin corePlugin = CommonCorePlugin.getDefault();
                    try {
                        Log.info((Plugin)corePlugin, (int)0, (String)("Activating provider policy '" + elements[0].getAttribute(A_CLASS) + "'..."));
                        this.policy = (IProviderPolicy)this.element.createExecutableExtension(E_POLICY);
                        Trace.trace((Plugin)corePlugin, (String)CommonCoreDebugOptions.SERVICES_ACTIVATE, (String)("Provider policy '" + String.valueOf(this.policy) + "' activated."));
                    }
                    catch (CoreException ce) {
                        Trace.catching((Plugin)corePlugin, (String)CommonCoreDebugOptions.EXCEPTIONS_CATCHING, ((Object)((Object)this)).getClass(), (String)"getPolicy", (Throwable)ce);
                        IStatus status = ce.getStatus();
                        Log.log((Plugin)corePlugin, (int)status.getSeverity(), (int)5, (String)status.getMessage(), (Throwable)status.getException());
                    }
                }
            }
            return this.policy;
        }

        public boolean provides(IOperation operation) {
            if (!this.policyInitialized) {
                this.policy = this.getPolicy();
                this.policyInitialized = true;
            }
            if (this.policy != null) {
                try {
                    return this.policy.provides(operation);
                }
                catch (Throwable e) {
                    Log.log((Plugin)CommonCorePlugin.getDefault(), (int)4, (int)5, (String)("Ignoring provider since policy " + String.valueOf(this.policy) + " threw an exception or error in the provides() method"), (Throwable)e);
                    if (e instanceof ThreadDeath) {
                        throw (ThreadDeath)e;
                    }
                    if (e instanceof VirtualMachineError) {
                        throw (VirtualMachineError)e;
                    }
                    return false;
                }
            }
            IProvider theProvider = this.getProvider();
            return theProvider != null ? LayoutService.safeProvides(theProvider, operation) : false;
        }

        public void providerChanged(ProviderChangeEvent event) {
            this.fireProviderChange(event);
        }

        public String toString() {
            if (this.providerClassName == null) {
                if (this.getElement() != null && this.getElement().isValid()) {
                    this.providerClassName = this.getElement().getAttribute(A_CLASS);
                }
                if (this.providerClassName == null) {
                    this.providerClassName = super.toString();
                }
            }
            return this.providerClassName;
        }
    }
}

