/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.spore.p2processingorder;

import com.google.common.collect.Maps;
import java.util.Map;
import org.eclipse.elk.alg.common.ICostFunction;
import org.eclipse.elk.alg.common.NaiveMinST;
import org.eclipse.elk.alg.common.Tree;
import org.eclipse.elk.alg.common.spore.InternalProperties;
import org.eclipse.elk.alg.common.spore.Node;
import org.eclipse.elk.alg.spore.SPOrEPhases;
import org.eclipse.elk.alg.spore.graph.Graph;
import org.eclipse.elk.core.alg.ILayoutPhase;
import org.eclipse.elk.core.alg.LayoutProcessorConfiguration;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class MinSTPhase
implements ILayoutPhase<SPOrEPhases, Graph> {
    private Map<KVector, Node> nodeMap = Maps.newHashMap();

    public LayoutProcessorConfiguration<SPOrEPhases, Graph> getLayoutProcessorConfiguration(Graph graph) {
        return LayoutProcessorConfiguration.create();
    }

    public void process(Graph graph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Minimum spanning tree construction", 1.0f);
        KVector root = graph.preferredRoot != null ? graph.preferredRoot.originalVertex : graph.vertices.get((int)0).originalVertex;
        Tree tTree = (Boolean)graph.getProperty(InternalProperties.DEBUG_SVG) != false ? NaiveMinST.createSpanningTree(graph.tEdges, (KVector)root, (ICostFunction)graph.costFunction, (String)(String.valueOf(ElkUtil.debugFolderPath((String[])new String[]{"spore"})) + "20minst")) : NaiveMinST.createSpanningTree(graph.tEdges, (KVector)root, (ICostFunction)graph.costFunction);
        this.convert((Tree<KVector>)tTree, graph);
        progressMonitor.done();
    }

    protected void convert(Tree<KVector> tTree, Graph graph) {
        this.nodeMap.clear();
        graph.vertices.forEach(n -> {
            Node node = this.nodeMap.put(n.originalVertex, (Node)n);
        });
        Tree root = new Tree((Object)this.nodeMap.get(tTree.node));
        this.addNode((Tree<Node>)root, tTree);
        graph.tree = root;
    }

    private void addNode(Tree<Node> s, Tree<KVector> t) {
        for (Tree tTree : t.children) {
            Tree child = new Tree((Object)this.nodeMap.get(tTree.node));
            s.children.add(child);
            this.addNode((Tree<Node>)child, (Tree<KVector>)tTree);
        }
    }
}

