/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.topdownpacking.options;

import org.eclipse.elk.alg.topdownpacking.NodeArrangementStrategy;
import org.eclipse.elk.alg.topdownpacking.TopdownpackingLayoutProvider;
import org.eclipse.elk.alg.topdownpacking.WhitespaceEliminationStrategy;
import org.eclipse.elk.alg.topdownpacking.options.TopdownpackingMetaDataProvider;
import org.eclipse.elk.core.AbstractLayoutProvider;
import org.eclipse.elk.core.data.ILayoutMetaDataProvider;
import org.eclipse.elk.core.data.LayoutAlgorithmData;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.TopdownNodeTypes;
import org.eclipse.elk.core.util.IFactory;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.Property;

public class TopdownpackingOptions
implements ILayoutMetaDataProvider {
    public static final String ALGORITHM_ID = "org.eclipse.elk.topdownpacking";
    public static final IProperty<ElkPadding> PADDING = CoreOptions.PADDING;
    public static final IProperty<Double> SPACING_NODE_NODE = CoreOptions.SPACING_NODE_NODE;
    public static final IProperty<Double> TOPDOWN_HIERARCHICAL_NODE_WIDTH = CoreOptions.TOPDOWN_HIERARCHICAL_NODE_WIDTH;
    public static final IProperty<Double> TOPDOWN_HIERARCHICAL_NODE_ASPECT_RATIO = CoreOptions.TOPDOWN_HIERARCHICAL_NODE_ASPECT_RATIO;
    public static final IProperty<Boolean> TOPDOWN_LAYOUT = CoreOptions.TOPDOWN_LAYOUT;
    private static final TopdownNodeTypes TOPDOWN_NODE_TYPE_DEFAULT = TopdownNodeTypes.PARALLEL_NODE;
    public static final IProperty<TopdownNodeTypes> TOPDOWN_NODE_TYPE = new Property(CoreOptions.TOPDOWN_NODE_TYPE, (Object)TOPDOWN_NODE_TYPE_DEFAULT);
    public static final IProperty<NodeArrangementStrategy> NODE_ARRANGEMENT_STRATEGY = TopdownpackingMetaDataProvider.NODE_ARRANGEMENT_STRATEGY;
    public static final IProperty<WhitespaceEliminationStrategy> WHITESPACE_ELIMINATION_STRATEGY = TopdownpackingMetaDataProvider.WHITESPACE_ELIMINATION_STRATEGY;

    public void apply(ILayoutMetaDataProvider.Registry registry) {
        registry.register(new LayoutAlgorithmData.Builder().id(ALGORITHM_ID).name("ELK Top-down Packing").description("An algorithm for placing boxes of fixed sizes. Expands boxes horizontally to fill empty whitespace. This algorithm can be used standalone or specifically for {@link CoreOptions.TOPDOWN_LAYOUT}. In this use case it should be set for nodes whose {@link CoreOptions.TOPDOWN_NODE_TYPE} is set to {@link TopdownNodeTypes.PARALLEL_NODE}. This allows topdown layout to give children larger sizes based on their number of children.").providerFactory((IFactory)new TopdownpackingFactory()).melkBundleName(null).definingBundleId("org.eclipse.elk.alg.topdownpacking").create());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.padding", PADDING.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.spacing.nodeNode", SPACING_NODE_NODE.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.topdown.hierarchicalNodeWidth", TOPDOWN_HIERARCHICAL_NODE_WIDTH.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.topdown.hierarchicalNodeAspectRatio", TOPDOWN_HIERARCHICAL_NODE_ASPECT_RATIO.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.topdownLayout", TOPDOWN_LAYOUT.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.topdown.nodeType", (Object)TOPDOWN_NODE_TYPE_DEFAULT);
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.topdownpacking.nodeArrangement.strategy", NODE_ARRANGEMENT_STRATEGY.getDefault());
        registry.addOptionSupport(ALGORITHM_ID, "org.eclipse.elk.topdownpacking.whitespaceElimination.strategy", WHITESPACE_ELIMINATION_STRATEGY.getDefault());
    }

    public static class TopdownpackingFactory
    implements IFactory<AbstractLayoutProvider> {
        public AbstractLayoutProvider create() {
            TopdownpackingLayoutProvider provider = new TopdownpackingLayoutProvider();
            provider.initialize("");
            return provider;
        }

        public void destroy(AbstractLayoutProvider obj) {
            obj.dispose();
        }
    }
}

