/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.acceleo.mtl.business.api.extension;

import com.google.common.base.Joiner;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.util.Bag;

public final class DynamicJavaModuleCreator {
    protected static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String COMMA = ",";
    private static final String ARGUMENT_PREFIX = "dynamicParameter";
    private static final String INVOKE = "invoke(''{0}'', ''{1}'', Sequence'{'{2}'}')";
    private static final String MODULE_SIGNATURE = "[module {0}({1})]" + LINE_SEPARATOR;
    private static final String QUERY_SIGNATURE = "[query public {0}({1}) : {2} = {3}/]" + LINE_SEPARATOR;

    private DynamicJavaModuleCreator() {
    }

    public static String createModule(String className, List<String> publicSignatures) {
        StringBuilder moduleBuffer = new StringBuilder();
        String actualClassName = DynamicJavaModuleCreator.trimGenericInformation(className);
        String moduleName = actualClassName.replace(".", "::");
        moduleBuffer.append(MessageFormat.format(MODULE_SIGNATURE, moduleName, "{0}"));
        for (String signature : publicSignatures) {
            String queryName = signature.substring(signature.indexOf(32) + 1, signature.indexOf(40));
            String argSignature = DynamicJavaModuleCreator.extractArgumentSignatureString(signature);
            String returnType = DynamicJavaModuleCreator.inferOCLType(signature.substring(0, signature.indexOf(32)));
            String invocation = MessageFormat.format(INVOKE, actualClassName, DynamicJavaModuleCreator.trimGenericInformation(signature.substring(signature.indexOf(32) + 1)), DynamicJavaModuleCreator.extractArgumentString(signature));
            moduleBuffer.append(MessageFormat.format(QUERY_SIGNATURE, queryName, argSignature, returnType, invocation));
        }
        return moduleBuffer.toString();
    }

    private static String trimGenericInformation(String className) {
        Object trimmed = className;
        int parameterIndex = ((String)trimmed).indexOf(60);
        while (parameterIndex != -1) {
            int endIndex = Math.min(((String)trimmed).length(), ((String)trimmed).indexOf(62));
            trimmed = ((String)trimmed).substring(0, parameterIndex) + ((String)trimmed).substring(endIndex + 1);
            parameterIndex = ((String)trimmed).indexOf(60);
        }
        return trimmed;
    }

    private static String extractArgumentSignatureString(String signature) {
        int argStart = signature.indexOf(40) + 1;
        int argEnd = signature.indexOf(41);
        String argString = signature.substring(argStart, argEnd);
        String[] arguments = argString.split(COMMA);
        arguments = DynamicJavaModuleCreator.handleGenericArguments(arguments);
        StringBuilder argumentsBuffer = new StringBuilder();
        int i = 0;
        while (i < arguments.length) {
            String argument = arguments[i];
            argumentsBuffer.append(ARGUMENT_PREFIX).append(i).append(':');
            argumentsBuffer.append(DynamicJavaModuleCreator.inferOCLType(argument));
            if (i != arguments.length - 1) {
                argumentsBuffer.append(COMMA);
            }
            ++i;
        }
        return argumentsBuffer.toString();
    }

    private static String[] handleGenericArguments(String[] arguments) {
        ArrayList<String> newArguments = new ArrayList<String>();
        int i = 0;
        while (i <= arguments.length - 1) {
            if (arguments[i].contains("<") && !arguments[i].contains(">")) {
                StringBuilder generic = new StringBuilder();
                while (!arguments[i].contains(">") && i < arguments.length) {
                    generic.append(arguments[i]);
                    generic.append(COMMA);
                    ++i;
                }
                if (arguments[i].contains(">")) {
                    generic.append(arguments[i]);
                }
                newArguments.add(generic.toString());
            } else {
                newArguments.add(arguments[i]);
            }
            ++i;
        }
        return newArguments.toArray(arguments);
    }

    private static String extractArgumentString(String signature) {
        int argStart = signature.indexOf(40) + 1;
        int argEnd = signature.indexOf(41);
        String argString = signature.substring(argStart, argEnd);
        String[] argumentTypes = argString.split(COMMA);
        Object[] arguments = new String[argumentTypes.length];
        int i = 0;
        while (i < argumentTypes.length) {
            arguments[i] = ARGUMENT_PREFIX + i;
            ++i;
        }
        return Joiner.on((char)',').join(arguments);
    }

    private static String getOCLTypeName(EcoreEnvironment env, Class<?> clazz) {
        Object typeName;
        OCLStandardLibrary library = env.getOCLStandardLibrary();
        EClassifier oclType = null;
        if (Number.class.isAssignableFrom(clazz)) {
            oclType = BigDecimal.class.isAssignableFrom(clazz) || Double.class.isAssignableFrom(clazz) || Float.class.isAssignableFrom(clazz) ? (EClassifier)library.getReal() : (EClassifier)library.getInteger();
        } else if (String.class.isAssignableFrom(clazz)) {
            oclType = (EClassifier)library.getString();
        } else if (Boolean.class.isAssignableFrom(clazz)) {
            oclType = (EClassifier)library.getBoolean();
        } else if (EObject.class.isAssignableFrom(clazz)) {
            EObject instance = null;
            try {
                instance = (EObject)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
            if (instance != null) {
                oclType = (EClassifier)env.getUMLReflection().asOCLType((Object)instance.eClass());
            }
        } else if (Collection.class.isAssignableFrom(clazz)) {
            oclType = LinkedHashSet.class.isAssignableFrom(clazz) ? (EClassifier)library.getOrderedSet() : (Set.class.isAssignableFrom(clazz) ? (EClassifier)library.getSet() : (Bag.class.isAssignableFrom(clazz) ? (EClassifier)library.getBag() : (EClassifier)library.getSequence()));
        }
        if (oclType != null) {
            typeName = oclType.getName();
        } else if (EObject.class.isAssignableFrom(clazz)) {
            String[] parts = clazz.getName().split("\\.");
            String packageName = parts[parts.length - 2];
            String className = parts[parts.length - 1];
            typeName = packageName + "::" + className;
        } else {
            typeName = ((EClassifier)library.getOclAny()).getName();
        }
        return typeName;
    }

    private static String inferOCLType(Class<?> clazz) {
        String oclType = "OCLAny";
        EcoreEnvironment env = (EcoreEnvironment)new EcoreEnvironmentFactory().createEnvironment();
        if (Collection.class.isAssignableFrom(clazz)) {
            EClassifier elementType = (EClassifier)env.getOCLStandardLibrary().getOclAny();
            CollectionKind kind = CollectionKind.SEQUENCE_LITERAL;
            if (LinkedHashSet.class.isAssignableFrom(clazz)) {
                kind = CollectionKind.ORDERED_SET_LITERAL;
            } else if (Set.class.isAssignableFrom(clazz)) {
                kind = CollectionKind.SET_LITERAL;
            } else if (Bag.class.isAssignableFrom(clazz)) {
                kind = CollectionKind.BAG_LITERAL;
            }
            oclType = env.getTypeResolver().resolveCollectionType(kind, (Object)elementType).getName();
        } else {
            oclType = DynamicJavaModuleCreator.getOCLTypeName(env, clazz);
        }
        return oclType;
    }

    private static String inferOCLType(String className) {
        String actualClass = className;
        int parameterIndex = actualClass.indexOf(60);
        String[] typeParameters = null;
        if (parameterIndex != -1) {
            typeParameters = actualClass.substring(parameterIndex + 1, actualClass.indexOf(62)).split(COMMA);
            actualClass = actualClass.substring(0, parameterIndex);
        }
        String erasure = DynamicJavaModuleCreator.inferOCLTypeNoGeneric(actualClass);
        if (typeParameters != null) {
            void typeParameter = typeParameters[0];
            return erasure.replace("OclAny", DynamicJavaModuleCreator.inferOCLTypeNoGeneric((String)typeParameter));
        }
        return erasure;
    }

    private static String inferOCLTypeNoGeneric(String className) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {}
        if (clazz != null) {
            return DynamicJavaModuleCreator.inferOCLType(clazz);
        }
        return className.substring(className.lastIndexOf(46) + 1);
    }
}

