/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.elk.alg.common.ICostFunction;
import org.eclipse.elk.alg.common.TEdge;
import org.eclipse.elk.alg.common.Tree;
import org.eclipse.elk.alg.common.utils.SVGImage;
import org.eclipse.elk.core.math.KVector;

public final class NaiveMinST {
    private NaiveMinST() {
    }

    public static Tree<KVector> createSpanningTree(Set<TEdge> tEdges, KVector root, ICostFunction costFunction, String debugOutputFile) {
        HashMap weight = Maps.newHashMap();
        for (TEdge edge : tEdges) {
            weight.put(edge, costFunction.cost(edge));
        }
        ArrayList edgeList = Lists.newArrayList(tEdges);
        edgeList.sort((e1, e2) -> ((Double)weight.get(e1)).compareTo((Double)weight.get(e2)));
        LinkedHashSet edges = Sets.newLinkedHashSet((Iterable)edgeList);
        Tree<KVector> minST = new Tree<KVector>(root);
        HashMap treeNodes = Maps.newHashMap();
        treeNodes.put(root, minST);
        SVGImage svg = new SVGImage(debugOutputFile);
        svg.addGroups("e", "t");
        for (TEdge e : edges) {
            svg.g("e").addLine(e.u.x, e.u.y, e.v.x, e.v.y, "stroke=\"black\" stroke-width=\"1\"");
            svg.g("t").addElementStr("<text x=\"" + (e.u.x + e.v.x) / 2.0 + "\" y=\"" + (e.u.y + e.v.y) / 2.0 + "\" fill=\"blue\"" + " font-size=\"20px\">" + String.format("%.2f", weight.get(e)) + "</text>");
        }
        svg.isave();
        while (!edges.isEmpty()) {
            TEdge nextEdge = null;
            KVector nextNode = null;
            KVector nodeInTree = null;
            double minWeight = Double.POSITIVE_INFINITY;
            for (TEdge edge : edges) {
                if (!((Double)weight.get(edge) <= minWeight)) continue;
                if (treeNodes.containsKey(edge.u) && !treeNodes.containsKey(edge.v)) {
                    nextNode = edge.v;
                    nodeInTree = edge.u;
                    nextEdge = edge;
                    break;
                }
                if (!treeNodes.containsKey(edge.v) || treeNodes.containsKey(edge.u)) continue;
                nextNode = edge.u;
                nodeInTree = edge.v;
                nextEdge = edge;
                break;
            }
            if (nextEdge == null) break;
            Tree<Object> subTree = new Tree<Object>(nextNode);
            ((Tree)treeNodes.get(nodeInTree)).children.add(subTree);
            treeNodes.put(nextNode, subTree);
            edges.remove(nextEdge);
            svg.g("e").addLine(nextEdge.u.x, nextEdge.u.y, nextEdge.v.x, nextEdge.v.y, "stroke=\"red\" stroke-width=\"3\"");
            svg.isave();
        }
        return minST;
    }

    public static Tree<KVector> createSpanningTree(Set<TEdge> tEdges, KVector root, ICostFunction costFunction) {
        return NaiveMinST.createSpanningTree(tEdges, root, costFunction, null);
    }
}

