/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.layout.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.gef.EditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramElementEditPart;

public class ExclusionLayoutHint
implements IAdaptable {
    ArrayList<EditPart> excluded;
    Optional<IAdaptable> parentLayoutHint;

    public ExclusionLayoutHint(Collection<? extends EditPart> excluded) {
        this.excluded = this.createExclusionList(excluded);
        this.parentLayoutHint = Optional.empty();
    }

    public ExclusionLayoutHint(Collection<? extends EditPart> excluded, IAdaptable parentLayoutHint) {
        this.excluded = this.createExclusionList(excluded);
        this.parentLayoutHint = Optional.of(parentLayoutHint);
    }

    private ArrayList<EditPart> createExclusionList(Collection<? extends EditPart> excludedCollection) {
        return excludedCollection.stream().filter(IDiagramElementEditPart.class::isInstance).collect(Collectors.toCollection(ArrayList::new));
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (Collection.class.equals(adapter)) {
            return (T)this.excluded;
        }
        return this.parentLayoutHint.map(hint -> hint.getAdapter(adapter)).orElse(null);
    }
}

