/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.acceleo.mtl.ide;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.acceleo.parser.interpreter.CompilationContext;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.common.acceleo.mtl.business.internal.interpreter.AcceleoMTLInterpreter;
import org.eclipse.sirius.common.acceleo.mtl.business.internal.interpreter.DynamicAcceleoModule;
import org.eclipse.sirius.common.acceleo.mtl.ide.AcceleoCompletionService;
import org.eclipse.sirius.common.acceleo.mtl.ide.Messages;
import org.eclipse.sirius.common.tools.api.contentassist.ContentContext;
import org.eclipse.sirius.common.tools.api.contentassist.ContentInstanceContext;
import org.eclipse.sirius.common.tools.api.contentassist.ContentProposal;
import org.eclipse.sirius.common.tools.api.contentassist.IProposalProvider;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterContext;
import org.eclipse.sirius.common.tools.api.interpreter.VariableType;
import org.eclipse.sirius.common.tools.api.util.StringUtil;

public class AcceleoProposalProvider
implements IProposalProvider {
    private static final String ACCELEO_EXPRESSION_PREFIX = "[";
    private static final String ACCELEO_EXPRESSION_SUFFIX = "/]";

    public ContentProposal getNewEmtpyExpression() {
        return new ContentProposal("[/]", "[/]", Messages.AcceleoProposalProvider_MTL_newExpression, 1);
    }

    public List<ContentProposal> getProposals(IInterpreter interpreter, ContentContext context) {
        List<ContentProposal> proposals;
        if (context == null || !(interpreter instanceof AcceleoMTLInterpreter)) {
            proposals = Collections.emptyList();
        } else if (context.getContents() == null || context.getContents().length() == 0) {
            proposals = Collections.singletonList(this.getNewEmtpyExpression());
        } else {
            AcceleoMTLInterpreter acceleoInterpreter = (AcceleoMTLInterpreter)interpreter;
            IInterpreterContext interpreterContext = context.getInterpreterContext();
            LinkedHashMap<String, String> validationVariables = new LinkedHashMap<String, String>();
            for (Map.Entry contextVariable : interpreterContext.getVariables().entrySet()) {
                String varName = (String)contextVariable.getKey();
                VariableType varType = (VariableType)contextVariable.getValue();
                if (varName == null || varName.length() <= 0 || !varType.hasDefinition() || varName.matches("[0-9]+")) continue;
                validationVariables.put(varName, varType.getCommonType(context.getInterpreterContext().getAvailableEPackages()).getCompleteName("::"));
            }
            VariableType selfType = interpreterContext.getTargetType();
            String targetType = !interpreterContext.requiresTargetType() ? "ecore::EObject" : (selfType.hasDefinition() ? interpreterContext.getTargetType().getCommonType(context.getInterpreterContext().getAvailableEPackages()).getCompleteName("::") : null);
            CompilationContext acceleoContext = acceleoInterpreter.createCompilationContext(interpreterContext, context.getContents(), targetType, validationVariables);
            DynamicAcceleoModule module = acceleoInterpreter.getModule();
            DynamicAcceleoModule.QueryIdentifier identifier = module.ensureQueryExists(acceleoContext);
            String moduleString = module.buildMTL(acceleoContext, identifier);
            ArrayList<URI> dependencyURIs = new ArrayList<URI>(acceleoContext.getDependencies().values());
            dependencyURIs.addAll(module.compileExtendedDependencies(acceleoContext, module.getResourceSet()));
            AcceleoCompletionService completionService = new AcceleoCompletionService(moduleString, module, dependencyURIs);
            proposals = completionService.getProposals(acceleoContext.getExpression(), context.getPosition(), identifier.getQueryName());
        }
        return proposals;
    }

    public List<ContentProposal> getProposals(IInterpreter interpreter, ContentInstanceContext context) {
        List<ContentProposal> proposals;
        if (context == null || !(interpreter instanceof AcceleoMTLInterpreter) || context.getCurrentSelected() == null) {
            proposals = Collections.emptyList();
        } else if (StringUtil.isEmpty((String)context.getTextSoFar())) {
            proposals = Collections.singletonList(this.getNewEmtpyExpression());
        } else {
            AcceleoMTLInterpreter acceleoInterpreter = (AcceleoMTLInterpreter)interpreter;
            EObject target = context.getCurrentSelected();
            CompilationContext acceleoContext = acceleoInterpreter.createCompilationContext(target, context.getTextSoFar());
            DynamicAcceleoModule module = acceleoInterpreter.getModule();
            DynamicAcceleoModule.QueryIdentifier identifier = module.ensureQueryExists(acceleoContext);
            String moduleString = module.buildMTL(acceleoContext, identifier);
            ArrayList<URI> dependencyURIs = new ArrayList<URI>(acceleoContext.getDependencies().values());
            dependencyURIs.addAll(module.compileExtendedDependencies(acceleoContext, module.getResourceSet()));
            AcceleoCompletionService completionService = new AcceleoCompletionService(moduleString, module, dependencyURIs);
            proposals = completionService.getProposals(acceleoContext.getExpression(), context.getCursorPosition(), identifier.getQueryName());
        }
        return proposals;
    }
}

