/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.graphical.edit.policies;

import java.util.function.Function;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.common.tools.api.util.TreeItemWrapper;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.business.api.query.ContainerCreationDescriptionQuery;
import org.eclipse.sirius.diagram.business.api.query.NodeCreationDescriptionQuery;
import org.eclipse.sirius.diagram.description.tool.ContainerCreationDescription;
import org.eclipse.sirius.diagram.description.tool.NodeCreationDescription;
import org.eclipse.sirius.diagram.description.tool.RequestDescription;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactory;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusLayoutDataManager;
import org.eclipse.sirius.diagram.ui.business.internal.view.RootLayoutData;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DDiagramEditPart;
import org.eclipse.sirius.diagram.ui.tools.api.command.GMFCommandWrapper;
import org.eclipse.sirius.diagram.ui.tools.internal.commands.emf.AbstractSelectionWizardCommand;
import org.eclipse.sirius.diagram.ui.tools.internal.commands.emf.PaneBasedSelectionWizardCommand;
import org.eclipse.sirius.diagram.ui.tools.internal.commands.emf.SelectionWizardCommand;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.PaneBasedSelectionWizardDescription;
import org.eclipse.sirius.viewpoint.description.tool.SelectionWizardDescription;
import org.eclipse.sirius.viewpoint.description.tool.ToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;

public class CreationUtil {
    private final RootLayoutData rootLayoutData;
    private final IDiagramCommandFactory emfCommandFactory;
    private final EditPart editPart;

    public CreationUtil(CreateRequest request, IDiagramCommandFactory commandFactory, Point realLocation, EditPart editPart) {
        this(commandFactory, new RootLayoutData(editPart, realLocation.getCopy(), CreationUtil.adaptRequestSizeToZoomFactor(request, editPart)), editPart);
    }

    public CreationUtil(IDiagramCommandFactory commandFactory, Point realLocation, Dimension realSize, EditPart editPart) {
        this(commandFactory, new RootLayoutData(editPart, realLocation.getCopy(), realSize == null ? null : realSize.getCopy()), editPart);
    }

    public CreationUtil(IDiagramCommandFactory commandFactory, RootLayoutData rootLayoutData, EditPart editPart) {
        this.emfCommandFactory = commandFactory;
        this.rootLayoutData = rootLayoutData;
        this.editPart = editPart;
    }

    private CompoundCommand wrapCommandWithLayout(AbstractToolDescription tool, Command emfCommand) {
        CompoundCommand compoundCommand = new CompoundCommand(tool.getName());
        compoundCommand.add(this.createLayoutDataCommand());
        compoundCommand.add((org.eclipse.gef.commands.Command)new ICommandProxy((ICommand)new GMFCommandWrapper(this.getEditingDomain(), emfCommand)));
        return compoundCommand;
    }

    public org.eclipse.gef.commands.Command getNodeCreationCommand(DDiagramElementContainer container, NodeCreationDescription tool) {
        if (new NodeCreationDescriptionQuery(tool).canCreateIn(container)) {
            return this.wrapCommandWithLayout((AbstractToolDescription)tool, this.emfCommandFactory.buildCreateNodeCommandFromTool(container, tool));
        }
        return null;
    }

    public org.eclipse.gef.commands.Command getNodeCreationCommand(DNode node, NodeCreationDescription tool) {
        if (new NodeCreationDescriptionQuery(tool).canCreateIn(node)) {
            return this.wrapCommandWithLayout((AbstractToolDescription)tool, this.emfCommandFactory.buildCreateNodeCommandFromTool(node, tool));
        }
        return null;
    }

    public org.eclipse.gef.commands.Command getNodeCreationCommand(DDiagram diagram, NodeCreationDescription tool) {
        if (new NodeCreationDescriptionQuery(tool).canCreateIn(diagram)) {
            return this.wrapCommandWithLayout((AbstractToolDescription)tool, this.emfCommandFactory.buildCreateNodeCommandFromTool(diagram, tool));
        }
        return null;
    }

    public org.eclipse.gef.commands.Command getContainerCreationDescription(DDiagramElementContainer viewNodeContainer, ContainerCreationDescription ccdTool) {
        if (new ContainerCreationDescriptionQuery(ccdTool).canCreateIn(viewNodeContainer)) {
            return this.wrapCommandWithLayout((AbstractToolDescription)ccdTool, this.emfCommandFactory.buildCreateContainerCommandFromTool(viewNodeContainer, ccdTool));
        }
        return null;
    }

    public org.eclipse.gef.commands.Command getContainerCreationDescription(DDiagram diagram, ContainerCreationDescription ccdTool) {
        if (new ContainerCreationDescriptionQuery(ccdTool).canCreateIn(diagram)) {
            return this.wrapCommandWithLayout((AbstractToolDescription)ccdTool, this.emfCommandFactory.buildCreateContainerCommandFromTool(diagram, ccdTool));
        }
        return null;
    }

    public org.eclipse.gef.commands.Command getSelectionWizardCommand(SelectionWizardDescription selectionTool, EObject containerView) {
        return this.getSelectionWizardCommand((AbstractToolDescription)selectionTool, containerView, input -> new SelectionWizardCommand(this.emfCommandFactory, selectionTool, (TreeItemWrapper)input, (DSemanticDecorator)containerView));
    }

    public org.eclipse.gef.commands.Command getPaneBasedSelectionWizardCommand(PaneBasedSelectionWizardDescription selectionTool, EObject containerView) {
        return this.getSelectionWizardCommand((AbstractToolDescription)selectionTool, containerView, input -> new PaneBasedSelectionWizardCommand(this.emfCommandFactory, selectionTool, (TreeItemWrapper)input, (DSemanticDecorator)containerView));
    }

    private org.eclipse.gef.commands.Command getSelectionWizardCommand(AbstractToolDescription selectionTool, EObject containerView, Function<TreeItemWrapper, AbstractSelectionWizardCommand> commandFactory) {
        TreeItemWrapper input;
        if (containerView != null && AbstractSelectionWizardCommand.canCreateCommand(selectionTool, containerView, input = new TreeItemWrapper(null, null))) {
            return this.wrapCommandWithLayout(selectionTool, (Command)commandFactory.apply(input));
        }
        return UnexecutableCommand.INSTANCE;
    }

    private TransactionalEditingDomain getEditingDomain() {
        if (this.editPart instanceof IGraphicalEditPart) {
            return ((IGraphicalEditPart)this.editPart).getEditingDomain();
        }
        return null;
    }

    public org.eclipse.gef.commands.Command getRequestToolCommand(RequestDescription requestDescription, EditPart host) {
        Request req = new Request();
        req.setType((Object)requestDescription.getType());
        if (requestDescription.getPrecondition() != null && !StringUtil.isEmpty((String)requestDescription.getPrecondition()) && host instanceof IGraphicalEditPart) {
            EObject semantic = ((IGraphicalEditPart)host).resolveSemanticElement();
            if (semantic instanceof DSemanticDecorator) {
                semantic = ((DSemanticDecorator)semantic).getTarget();
            }
            boolean valid = false;
            IInterpreter acceleoInterpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(semantic);
            acceleoInterpreter.setVariable("container", (Object)semantic);
            try {
                valid = acceleoInterpreter.evaluateBoolean(semantic, requestDescription.getPrecondition());
            }
            catch (EvaluationException e) {
                RuntimeLoggerManager.INSTANCE.error((EObject)requestDescription, (EStructuralFeature)ToolPackage.eINSTANCE.getAbstractToolDescription_Precondition(), (Throwable)e);
            }
            acceleoInterpreter.unSetVariable("container");
            if (!valid) {
                return null;
            }
        }
        RequestToolCommand cmd = new RequestToolCommand(req, requestDescription, host);
        return cmd;
    }

    public org.eclipse.gef.commands.Command getGenericToolCommand(EObject containerView, ToolDescription toolDesc) {
        return this.wrapCommandWithLayout((AbstractToolDescription)toolDesc, this.emfCommandFactory.buildGenericToolCommandFromTool(containerView, toolDesc));
    }

    private org.eclipse.gef.commands.Command createLayoutDataCommand() {
        return new org.eclipse.gef.commands.Command(){

            public void execute() {
                SiriusLayoutDataManager.INSTANCE.addData(CreationUtil.this.rootLayoutData);
            }
        };
    }

    public static Dimension adaptRequestSizeToZoomFactor(CreateRequest request, EditPart editPart) {
        if (request.getSize() == null) {
            return null;
        }
        Dimension dimension = request.getSize().getCopy();
        double scale = 1.0;
        if (editPart.getRoot() instanceof DiagramRootEditPart) {
            ZoomManager zoomManager = ((DiagramRootEditPart)editPart.getRoot()).getZoomManager();
            scale = zoomManager.getZoom();
        }
        dimension.performScale(1.0 / scale);
        return dimension;
    }

    private static class RequestToolCommand
    extends org.eclipse.gef.commands.Command {
        private org.eclipse.gef.commands.Command wrappedCmd;
        private final EditPart host;
        private final RequestDescription requestDescription;
        private final Request req;

        RequestToolCommand(Request req, RequestDescription desc, EditPart host) {
            super(desc.getName());
            this.req = req;
            this.requestDescription = desc;
            this.host = host;
        }

        public void execute() {
            org.eclipse.gef.commands.Command refresh;
            this.wrappedCmd = this.host.getCommand(this.req);
            CompoundCommand cc = new CompoundCommand();
            cc.add(this.wrappedCmd);
            if (this.requestDescription.isForceRefresh() && (refresh = this.getRefreshSiriusCommand()) != null) {
                cc.add(refresh);
            }
            this.wrappedCmd = cc;
            if (this.wrappedCmd != null && this.wrappedCmd.canExecute()) {
                this.wrappedCmd.execute();
            }
        }

        public boolean canUndo() {
            if (this.wrappedCmd != null) {
                return this.wrappedCmd.canUndo();
            }
            return false;
        }

        public void undo() {
            if (this.wrappedCmd != null) {
                this.wrappedCmd.undo();
            }
        }

        public void redo() {
            if (this.wrappedCmd != null) {
                this.wrappedCmd.redo();
            }
        }

        private org.eclipse.gef.commands.Command getRefreshSiriusCommand() {
            EditPart current = this.host;
            while (!(current instanceof DDiagramEditPart) && current != null) {
                current = current.getParent();
            }
            if (current != null) {
                Request requ = new Request((Object)"refreshSirius");
                return current.getCommand(requ);
            }
            return null;
        }
    }
}

