/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.graphical.edit.part.specific;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.sirius.diagram.BracketEdgeStyle;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.ui.business.internal.bracket.BracketConnectionAnchor;
import org.eclipse.sirius.diagram.ui.business.internal.bracket.BracketConnectionQuery;
import org.eclipse.sirius.diagram.ui.business.internal.bracket.BracketRelativeBendpoint;
import org.eclipse.sirius.diagram.ui.business.internal.bracket.DiagramTargetingTool;
import org.eclipse.sirius.diagram.ui.business.internal.bracket.locators.BracketConnectionDecoratorLocator;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramEdgeEditPart;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.BracketBendpointEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.DeleteFromDiagramEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.HideSiriusElementEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.SiriusGraphicalNodeEditPolicy;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DEdgeBeginNameEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DEdgeEndNameEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DEdgeNameEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.policies.DEdgeItemSemanticEditPolicy;
import org.eclipse.sirius.diagram.ui.tools.api.policy.CompoundEditPolicy;
import org.eclipse.sirius.diagram.ui.tools.internal.routers.BracketConnectionRouter;

public class BracketEdgeEditPart
extends AbstractDiagramEdgeEditPart {
    public static final int VISUAL_ID = 4002;
    private BracketConnectionQuery bracketConnectionQuery;
    private ConnectionRouter connectionRouter;

    public BracketEdgeEditPart(View view) {
        super(view);
    }

    @Override
    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.removeEditPolicy("GraphicalNodeEditPolicy");
        this.removeEditPolicy("ComponentEditPolicy");
        CompoundEditPolicy compoundEditPolicy = new CompoundEditPolicy();
        compoundEditPolicy.addEditPolicy((EditPolicy)new SiriusGraphicalNodeEditPolicy());
        compoundEditPolicy.addEditPolicy((EditPolicy)new HideSiriusElementEditPolicy());
        compoundEditPolicy.addEditPolicy((EditPolicy)new DeleteFromDiagramEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", compoundEditPolicy);
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new DEdgeItemSemanticEditPolicy());
        this.installBendpointEditPolicy();
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (this.addFixedChild(childEditPart)) {
            return;
        }
        super.addChildVisual(childEditPart, -1);
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        boolean added = false;
        if (childEditPart instanceof DEdgeNameEditPart) {
            ((DEdgeNameEditPart)childEditPart).setLabel(this.getPrimaryShape().getFigureViewEdgeNameFigure());
            added = true;
        } else if (childEditPart instanceof DEdgeEndNameEditPart) {
            ((DEdgeEndNameEditPart)childEditPart).setLabel(this.getPrimaryShape().getFigureViewEndEdgeNameFigure());
            added = true;
        } else if (childEditPart instanceof DEdgeBeginNameEditPart) {
            ((DEdgeBeginNameEditPart)childEditPart).setLabel(this.getPrimaryShape().getFigureViewBeginEdgeNameFigure());
            added = true;
        }
        return added;
    }

    private AbstractDiagramEdgeEditPart.ViewEdgeFigure getPrimaryShape() {
        return (AbstractDiagramEdgeEditPart.ViewEdgeFigure)this.getFigure();
    }

    public DragTracker getDragTracker(Request request) {
        return new DiagramTargetingTool((EditPart)this);
    }

    @Override
    protected void refreshBendpoints() {
        if (this.bracketConnectionQuery != null) {
            List<BracketRelativeBendpoint> figureConstraint = null;
            RelativeBendpoints bendpoints = (RelativeBendpoints)this.getEdge().getBendpoints();
            List gmfRelativeBendpoints = bendpoints.getPoints();
            figureConstraint = this.hasDefaultBendpoints(gmfRelativeBendpoints) ? this.getDefaultFigureConstraint() : this.bracketConnectionQuery.getBracketRelativeBendointFromGMFRelativeBendpoints(gmfRelativeBendpoints);
            this.getConnectionFigure().setRoutingConstraint(figureConstraint);
        } else {
            super.refreshBendpoints();
        }
    }

    protected List<BracketRelativeBendpoint> getDefaultFigureConstraint() {
        ArrayList<BracketRelativeBendpoint> defaultFigureConstraint = new ArrayList<BracketRelativeBendpoint>();
        defaultFigureConstraint.add(new BracketRelativeBendpoint(this.getConnectionFigure(), BracketConnectionQuery.DEFAULT_SOURCE_SIDE.ordinal(), BracketConnectionQuery.DEFAULT_DIRECTION.ordinal(), 100));
        return defaultFigureConstraint;
    }

    private boolean hasDefaultBendpoints(List<RelativeBendpoint> gmfRelativeBendpoints) {
        boolean hasDimensionBendpoints = false;
        if (gmfRelativeBendpoints.size() == 1) {
            RelativeBendpoint firstRelativeBendpoint = gmfRelativeBendpoints.get(0);
            hasDimensionBendpoints = firstRelativeBendpoint.getTargetY() == -1;
        }
        return !hasDimensionBendpoints;
    }

    @Override
    protected void refreshRouterChange() {
        super.refreshRouterChange();
        this.installBendpointEditPolicy();
    }

    @Override
    protected void refreshRoutingStyles() {
        super.refreshRoutingStyles();
        this.installBendpointEditPolicy();
    }

    private void installBendpointEditPolicy() {
        this.installEditPolicy("Connection Bendpoint Policy", (EditPolicy)new BracketBendpointEditPolicy(this));
        this.getConnectionFigure().setCursor(null);
    }

    @Override
    protected void installRouter() {
        if (this.getConnectionRouter() != null) {
            this.getPrimaryShape().setConnectionRouter(this.getConnectionRouter());
        } else {
            super.installRouter();
        }
    }

    private ConnectionRouter getConnectionRouter() {
        if (this.connectionRouter == null && this.bracketConnectionQuery != null) {
            this.connectionRouter = new BracketConnectionRouter(this.bracketConnectionQuery);
        }
        return this.connectionRouter;
    }

    @Override
    protected Connection createConnectionFigure() {
        Connection connection = super.createConnectionFigure();
        this.bracketConnectionQuery = new BracketConnectionQuery(connection);
        return connection;
    }

    public ConnectionAnchor getSourceConnectionAnchor() {
        Object sourceConnectionAnchor;
        if (this.getSource() instanceof GraphicalEditPart) {
            GraphicalEditPart sourceGraphicalEditPart = (GraphicalEditPart)this.getSource();
            IFigure owner = sourceGraphicalEditPart.getFigure();
            sourceConnectionAnchor = new BracketConnectionAnchor(owner);
        } else {
            sourceConnectionAnchor = super.getSourceConnectionAnchor();
        }
        return sourceConnectionAnchor;
    }

    public ConnectionAnchor getTargetConnectionAnchor() {
        Object targetConnectionAnchor;
        if (this.getSource() instanceof GraphicalEditPart) {
            GraphicalEditPart targetGraphicalEditPart = (GraphicalEditPart)this.getTarget();
            IFigure owner = targetGraphicalEditPart.getFigure();
            targetConnectionAnchor = new BracketConnectionAnchor(owner);
        } else {
            targetConnectionAnchor = super.getTargetConnectionAnchor();
        }
        return targetConnectionAnchor;
    }

    @Override
    public void refreshSourceDecoration() {
        BracketEdgeStyle style = this.getStyle();
        if (style == null || style.getSourceArrow() == null) {
            return;
        }
        super.refreshSourceDecoration();
        RotatableDecoration decoration = ((AbstractDiagramEdgeEditPart.ViewEdgeFigure)this.getConnectionFigure()).getSourceDecoration();
        if (decoration != null) {
            this.getPolylineConnectionFigure().setSourceDecoration(decoration, (ConnectionLocator)new BracketConnectionDecoratorLocator(this.getConnectionFigure(), 5, this.bracketConnectionQuery));
        }
    }

    @Override
    public void refreshTargetDecoration() {
        BracketEdgeStyle style = this.getStyle();
        if (style == null || style.getTargetArrow() == null) {
            return;
        }
        super.refreshTargetDecoration();
        RotatableDecoration decoration = ((AbstractDiagramEdgeEditPart.ViewEdgeFigure)this.getConnectionFigure()).getTargetDecoration();
        if (decoration != null) {
            this.getPolylineConnectionFigure().setTargetDecoration(decoration, (ConnectionLocator)new BracketConnectionDecoratorLocator(this.getConnectionFigure(), 6, this.bracketConnectionQuery));
        }
    }

    private BracketEdgeStyle getStyle() {
        DEdge edge;
        EObject airdElement = this.resolveSemanticElement();
        if (airdElement instanceof DEdge && (edge = (DEdge)airdElement).getStyle() instanceof BracketEdgeStyle) {
            return (BracketEdgeStyle)edge.getStyle();
        }
        return null;
    }
}

