/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.business.api.helper;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.table.business.api.helper.TableHelper;
import org.eclipse.sirius.table.metamodel.table.DCell;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.metamodel.table.DTargetColumn;
import org.eclipse.sirius.table.metamodel.table.LineContainer;
import org.eclipse.sirius.table.metamodel.table.description.TableTool;
import org.eclipse.sirius.table.metamodel.table.description.TableVariable;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.AbstractVariable;

public final class TableVariablesHelper {
    private TableVariablesHelper() {
    }

    public static Map<String, EObject> getVariables(DSemanticDecorator decorator) {
        Map<String, EObject> result = Collections.emptyMap();
        if (decorator instanceof DLine) {
            result = TableVariablesHelper.getVariables((DLine)decorator);
        } else if (decorator instanceof DTargetColumn) {
            result = TableVariablesHelper.getVariables((DTargetColumn)decorator);
        } else if (decorator instanceof DTable) {
            result = TableVariablesHelper.getVariables((DTable)decorator);
        } else if (decorator instanceof DCell) {
            result = TableVariablesHelper.getVariables((DCell)decorator);
        }
        return result;
    }

    public static Map<AbstractVariable, Object> getTableVariables(TableTool tool, Map<String, ?> values) {
        HashMap<AbstractVariable, Object> result = new HashMap<AbstractVariable, Object>();
        values.forEach((key, value) -> {
            TableVariable variable = TableHelper.getVariable(tool, key);
            if (variable != null) {
                result.put((AbstractVariable)variable, value);
            }
        });
        return result;
    }

    public static Map<String, EObject> getVariablesForCandidates(LineContainer container) {
        DTable table = TableHelper.getTable((EObject)container);
        HashMap<String, EObject> result = new HashMap<String, EObject>();
        result.put("containerView", (EObject)container);
        result.put("container", container.getTarget());
        result.put("table", (EObject)table);
        result.put("root", table.getTarget());
        return result;
    }

    private static Map<String, EObject> getVariables(DLine line) {
        HashMap<String, EObject> result = new HashMap<String, EObject>();
        DTable table = TableHelper.getTable((EObject)line);
        result.put("view", (EObject)line);
        result.put("element", line.getTarget());
        result.put("containerView", (EObject)line.getContainer());
        result.put("container", line.getContainer().getTarget());
        result.put("table", (EObject)table);
        result.put("root", table.getTarget());
        return result;
    }

    private static Map<String, EObject> getVariables(DTable table) {
        HashMap<String, EObject> result = new HashMap<String, EObject>();
        result.put("view", (EObject)table);
        result.put("element", table.getTarget());
        result.put("table", (EObject)table);
        result.put("root", table.getTarget());
        result.put("containerView", (EObject)table);
        result.put("container", table.getTarget());
        return result;
    }

    private static Map<String, EObject> getVariables(DTargetColumn column) {
        HashMap<String, EObject> result = new HashMap<String, EObject>();
        DTable table = TableHelper.getTable((EObject)column);
        result.put("table", (EObject)table);
        result.put("root", table.getTarget());
        result.put("view", (EObject)column);
        result.put("element", column.getTarget());
        result.put("containerView", (EObject)table);
        result.put("container", table.getTarget());
        return result;
    }

    public static Map<String, EObject> getVariables(DLine line, DColumn column) {
        HashMap<String, EObject> result = new HashMap<String, EObject>();
        DTable table = TableHelper.getTable((EObject)line);
        result.put("table", (EObject)table);
        result.put("root", table.getTarget());
        result.put("containerView", (EObject)line);
        result.put("container", line.getTarget());
        result.put("line", (EObject)line);
        result.put("lineSemantic", line.getTarget());
        result.put("column", (EObject)column);
        if (column instanceof DTargetColumn) {
            result.put("columnSemantic", column.getTarget());
        }
        return result;
    }

    public static Map<String, EObject> getVariables(DCell cell) {
        Map<String, EObject> result = TableVariablesHelper.getVariables(cell.getLine(), cell.getColumn());
        result.put("view", (EObject)cell);
        result.put("element", cell.getTarget());
        return result;
    }
}

