/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.render;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.batik.anim.dom.SVGDOMImplementation;
import org.apache.batik.anim.dom.SVGOMSVGElement;
import org.apache.batik.dom.util.DOMUtilities;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class SVGImageRegistry {
    private static final String FILE_PROTOCOL = "file:";
    private static final String PX_UNIT = "px";
    private static final String LINK_SYMBOL = "#";
    private static final String NEW_ID_PREFIX = "_";
    private static final Map<String, String> UUID_REGISTRY = new HashMap<String, String>();
    private static final Comparator<Map.Entry<String, String>> UUID_SORTER = Comparator.comparing(Map.Entry::getValue);
    private static final Map<String, Element> SVG_DOCUMENT_REGISTRY = new HashMap<String, Element>();
    private static final Map<String, Integer> GENERATED_IDS = new HashMap<String, Integer>();
    private static final Function<String, String> UUID_CREATE = url -> {
        int segmentPos;
        Object path = url;
        if (url.startsWith(FILE_PROTOCOL) && (segmentPos = url.lastIndexOf(47)) != -1) {
            path = FILE_PROTOCOL + url.substring(segmentPos) + NEW_ID_PREFIX + UUID_REGISTRY.size();
        }
        return UUID.nameUUIDFromBytes(((String)path).getBytes()).toString();
    };

    private SVGImageRegistry() {
    }

    public static String registerUUID(String imageURL) {
        return UUID_REGISTRY.computeIfAbsent(imageURL, UUID_CREATE);
    }

    public static Element registerSVGDocument(String imageURL, Document document) {
        Element element = SVG_DOCUMENT_REGISTRY.get(imageURL);
        if (element == null) {
            SVG_DOCUMENT_REGISTRY.put(imageURL, document.getDocumentElement());
        }
        return element;
    }

    public static void reset() {
        GENERATED_IDS.clear();
        UUID_REGISTRY.clear();
        SVG_DOCUMENT_REGISTRY.clear();
    }

    public static Optional<Element> getReferencedImage(String imageURI) {
        return Optional.ofNullable(SVG_DOCUMENT_REGISTRY.get(imageURI));
    }

    public static boolean hasReferencedImages() {
        return !SVG_DOCUMENT_REGISTRY.isEmpty();
    }

    public static Collection<String> getURLs() {
        return UUID_REGISTRY.entrySet().stream().sorted(UUID_SORTER).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public static Optional<String> getUUID(String url) {
        return Optional.ofNullable(UUID_REGISTRY.get(url));
    }

    public static Document getSVGDocument(Document doc, Rectangle svgArea) {
        Document copiedDocument = SVGImageRegistry.getSVGDocument(doc);
        SVGImageRegistry.updateViewBox(copiedDocument, svgArea);
        return copiedDocument;
    }

    public static Document getSVGDocument(Document doc) {
        DOMImplementation impl = SVGDOMImplementation.getDOMImplementation();
        Document copiedDocument = DOMUtilities.deepCloneDocument((Document)doc, (DOMImplementation)impl);
        TreeMap<String, String> ids = new TreeMap<String, String>(Comparator.reverseOrder());
        SVGImageRegistry.updateIDs(copiedDocument.getDocumentElement(), ids);
        SVGImageRegistry.updateLinks(copiedDocument.getDocumentElement(), ids);
        return copiedDocument;
    }

    private static void updateViewBox(Document document, Rectangle svgArea) {
        int i = 0;
        while (i < document.getChildNodes().getLength()) {
            String viewBoxValue;
            Node node = document.getChildNodes().item(i);
            if (node instanceof SVGOMSVGElement && !StringUtil.isEmpty((String)(viewBoxValue = ((Element)node).getAttributeNS(null, "viewBox")))) {
                SVGImageRegistry.updateSize((Element)node, svgArea);
            }
            ++i;
        }
    }

    private static void updateSize(Element element, Rectangle svgArea) {
        element.setAttributeNS(null, "width", String.valueOf(svgArea.width) + PX_UNIT);
        element.setAttributeNS(null, "height", String.valueOf(svgArea.height) + PX_UNIT);
    }

    private static void updateLinks(Node node, Map<String, String> ids) {
        SVGImageRegistry.updateLink(node, ids);
        Node c = node.getFirstChild();
        while (c != null) {
            SVGImageRegistry.updateLinks(c, ids);
            c = c.getNextSibling();
        }
    }

    private static void updateLink(Node node, Map<String, String> ids) {
        if (node.hasAttributes()) {
            int i = 0;
            while (i < node.getAttributes().getLength()) {
                Node item = node.getAttributes().item(i);
                String nodeValue = item.getNodeValue();
                if (!"id".equals(item.getNodeName()) && nodeValue != null && !nodeValue.isEmpty()) {
                    ids.forEach((k, v) -> {
                        String currentNodeValue = item.getNodeValue();
                        if (currentNodeValue.contains(LINK_SYMBOL + k)) {
                            String newId = (String)ids.get(k);
                            String newValue = currentNodeValue.replaceAll(LINK_SYMBOL + k, LINK_SYMBOL + newId);
                            item.setNodeValue(newValue);
                        }
                    });
                }
                ++i;
            }
        }
    }

    private static void updateIDs(Node node, Map<String, String> ids) {
        SVGImageRegistry.updateId(node, ids);
        Node c = node.getFirstChild();
        while (c != null) {
            SVGImageRegistry.updateIDs(c, ids);
            c = c.getNextSibling();
        }
    }

    private static int getGeneratedSuffixId(String base) {
        Integer result = GENERATED_IDS.getOrDefault(base, 0);
        GENERATED_IDS.put(base, result + 1);
        return result;
    }

    private static void updateId(Node node, Map<String, String> ids) {
        NamedNodeMap attr;
        Node idItem;
        if (node.hasAttributes() && (idItem = (attr = node.getAttributes()).getNamedItem("id")) != null) {
            String idValue = idItem.getNodeValue();
            int suffix = SVGImageRegistry.getGeneratedSuffixId(idValue);
            String newValue = NEW_ID_PREFIX + idValue + NEW_ID_PREFIX + suffix;
            ids.put(idValue, newValue);
            idItem.setNodeValue(newValue);
        }
    }
}

