/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.providers;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.validation.service.IBatchValidator;
import org.eclipse.emf.validation.service.ITraversalStrategy;
import org.eclipse.gmf.runtime.common.ui.services.action.contributionitem.AbstractContributionItemProvider;
import org.eclipse.gmf.runtime.common.ui.util.IWorkbenchPartDescriptor;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.IAction;
import org.eclipse.sirius.diagram.tools.api.DiagramPlugin;
import org.eclipse.sirius.diagram.ui.part.SiriusVisualIDRegistry;
import org.eclipse.sirius.diagram.ui.part.ValidateAction;
import org.eclipse.sirius.diagram.ui.provider.Messages;

public class SiriusValidationProvider
extends AbstractContributionItemProvider {
    private static boolean constraintsActive = false;
    static final Map semanticCtxIdMap = new HashMap();

    public static boolean shouldConstraintsBePrivate() {
        return false;
    }

    protected IAction createAction(String actionId, IWorkbenchPartDescriptor partDescriptor) {
        if ("validateAction".equals(actionId)) {
            return new ValidateAction(partDescriptor);
        }
        return super.createAction(actionId, partDescriptor);
    }

    public static void runWithConstraints(View view, Runnable op) {
        final Runnable fop = op;
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    constraintsActive = true;
                    fop.run();
                }
                finally {
                    constraintsActive = false;
                }
            }
        };
        TransactionalEditingDomain txDomain = TransactionUtil.getEditingDomain((EObject)view);
        if (txDomain != null) {
            try {
                txDomain.runExclusive(task);
            }
            catch (Exception e) {
                DiagramPlugin.getDefault().logError(Messages.SiriusValidationProvider_validationFailed, (Throwable)e);
            }
        } else {
            task.run();
        }
    }

    static boolean isInDefaultEditorContext(Object object) {
        if (SiriusValidationProvider.shouldConstraintsBePrivate() && !constraintsActive) {
            return false;
        }
        if (object instanceof View) {
            return constraintsActive && "Sirius".equals(SiriusVisualIDRegistry.getModelID((View)object));
        }
        return true;
    }

    public static ITraversalStrategy getNotationTraversalStrategy(IBatchValidator validator) {
        return new CtxSwitchStrategy(validator);
    }

    private static class CtxSwitchStrategy
    implements ITraversalStrategy {
        private ITraversalStrategy defaultStrategy;
        private String currentSemanticCtxId;
        private boolean ctxChanged = true;
        private EObject currentTarget;
        private EObject preFetchedNextTarget;

        CtxSwitchStrategy(IBatchValidator validator) {
            this.defaultStrategy = validator.getDefaultTraversalStrategy();
        }

        public void elementValidated(EObject element, IStatus status) {
            this.defaultStrategy.elementValidated(element, status);
        }

        public boolean hasNext() {
            return this.defaultStrategy.hasNext();
        }

        public boolean isClientContextChanged() {
            if (this.preFetchedNextTarget == null) {
                this.preFetchedNextTarget = this.next();
                this.prepareNextClientContext(this.preFetchedNextTarget);
            }
            return this.ctxChanged;
        }

        public EObject next() {
            EObject nextTarget = this.preFetchedNextTarget;
            if (nextTarget == null) {
                nextTarget = this.defaultStrategy.next();
            }
            this.preFetchedNextTarget = null;
            this.currentTarget = nextTarget;
            return this.currentTarget;
        }

        public void startTraversal(Collection traversalRoots, IProgressMonitor monitor) {
            this.defaultStrategy.startTraversal(traversalRoots, monitor);
        }

        private void prepareNextClientContext(EObject nextTarget) {
            if (nextTarget != null && this.currentTarget != null) {
                if (nextTarget instanceof View) {
                    String nextSemanticId;
                    String id = ((View)nextTarget).getType();
                    String string = nextSemanticId = id != null && semanticCtxIdMap.containsKey(id) ? id : null;
                    if (this.currentSemanticCtxId != null && !this.currentSemanticCtxId.equals(nextSemanticId) || nextSemanticId != null && !nextSemanticId.equals(this.currentSemanticCtxId)) {
                        this.ctxChanged = true;
                    }
                    this.currentSemanticCtxId = nextSemanticId;
                } else {
                    this.ctxChanged = this.currentSemanticCtxId != null;
                    this.currentSemanticCtxId = null;
                }
            } else {
                this.ctxChanged = false;
            }
        }
    }
}

