/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ext.emf;

import java.util.Objects;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class EStructuralFeatureQuery {
    private final EStructuralFeature feature;

    public EStructuralFeatureQuery(EStructuralFeature feature) {
        this.feature = Objects.requireNonNull(feature);
    }

    public boolean existsIn(EObject obj) {
        return obj != null && obj.eClass().getEAllStructuralFeatures().contains((Object)this.feature);
    }

    public boolean isContainment() {
        return this.feature.getEContainingClass().getEAllContainments().contains((Object)this.feature);
    }

    public boolean isAssignableFrom(EStructuralFeature source) {
        boolean result = false;
        if (this.feature instanceof EAttribute && source instanceof EAttribute) {
            EDataType thisType = ((EAttribute)this.feature).getEAttributeType();
            EDataType sourceType = ((EAttribute)source).getEAttributeType();
            result = thisType.getInstanceClass().isAssignableFrom(sourceType.getInstanceClass());
        } else if (this.feature instanceof EReference && source instanceof EReference) {
            EClass hisType = ((EReference)this.feature).getEReferenceType();
            EClass sourceType = ((EReference)source).getEReferenceType();
            result = hisType.isSuperTypeOf(sourceType);
        }
        return result;
    }
}

