/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.internal.interpreter;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.eclipse.sirius.common.tools.Messages;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.internal.interpreter.IMonomorphicService;
import org.eclipse.sirius.common.tools.internal.interpreter.IPolymorphicService;
import org.eclipse.sirius.common.tools.internal.interpreter.MonomorphicService;

class PolymorphicService
implements IPolymorphicService {
    private final String name;
    private final Set<IMonomorphicService> implementers = new LinkedHashSet<IMonomorphicService>();

    PolymorphicService(String name) {
        this.name = Objects.requireNonNull(name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void addImplementer(MonomorphicService svc) {
        Objects.requireNonNull(svc);
        Preconditions.checkArgument((boolean)this.name.equals(svc.getName()));
        this.implementers.add(svc);
    }

    @Override
    public boolean appliesTo(Object[] target) {
        return Iterables.any(this.implementers, this.getCompatibilityChecker(target));
    }

    @Override
    public Object call(Object[] target) throws EvaluationException {
        ArrayList candidates = Lists.newArrayList((Iterable)Iterables.filter(this.implementers, this.getCompatibilityChecker(target)));
        if (!candidates.isEmpty()) {
            return ((IMonomorphicService)candidates.get(0)).call(target);
        }
        throw new EvaluationException(MessageFormat.format(Messages.PolymorphicService_noCompatibleImplem, this.getName(), String.valueOf(target)));
    }

    private Predicate<IMonomorphicService> getCompatibilityChecker(final Object[] target) {
        Predicate<IMonomorphicService> isCompatible = new Predicate<IMonomorphicService>(){

            public boolean apply(IMonomorphicService svc) {
                return svc.appliesTo(target);
            }
        };
        return isCompatible;
    }

    public String toString() {
        return MessageFormat.format(Messages.PolymorphicService_toString, this.getName(), this.implementers.size());
    }

    @Override
    public Set<IMonomorphicService> getImplementers() {
        return this.implementers;
    }

    @Override
    public Collection<Method> getImplementations() {
        ArrayList<Method> result = new ArrayList<Method>();
        for (IMonomorphicService svc : this.implementers) {
            result.addAll(svc.getImplementations());
        }
        return result;
    }
}

