/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.radial.options;

import org.eclipse.elk.alg.radial.intermediate.optimization.CrossingMinimizationPosition;
import org.eclipse.elk.alg.radial.intermediate.optimization.EdgeLengthOptimization;
import org.eclipse.elk.alg.radial.intermediate.optimization.EdgeLengthPositionOptimization;
import org.eclipse.elk.alg.radial.intermediate.optimization.IEvaluation;

public enum RadialTranslationStrategy {
    NONE,
    EDGE_LENGTH,
    EDGE_LENGTH_BY_POSITION,
    CROSSING_MINIMIZATION_BY_POSITION;


    public IEvaluation create() {
        switch (this) {
            case EDGE_LENGTH: {
                return new EdgeLengthOptimization();
            }
            case EDGE_LENGTH_BY_POSITION: {
                return new EdgeLengthPositionOptimization();
            }
            case CROSSING_MINIMIZATION_BY_POSITION: {
                return new CrossingMinimizationPosition();
            }
            case NONE: {
                return null;
            }
        }
        throw new IllegalArgumentException("No implementation is available for the layout option " + this.toString());
    }
}

