/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.elk.alg.layered.options.CycleBreakingStrategy;
import org.eclipse.elk.alg.layered.options.LayerConstraint;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.options.LayeringStrategy;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.util.IGraphElementVisitor;
import org.eclipse.elk.graph.ElkConnectableShape;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.ElkPort;

public class InteractiveLayeredGraphVisitor
implements IGraphElementVisitor {
    public static final int PSEUDO_POSITION_SPACING = Integer.MAX_VALUE;
    public static final int LAST_LAYER_INDEX = Integer.MAX_VALUE;

    public void visit(ElkGraphElement element) {
        if (element instanceof ElkNode) {
            ElkNode root = (ElkNode)element;
            this.setInteractiveOptionsAndPseudoPositions(root);
        }
    }

    private void setInteractiveOptionsAndPseudoPositions(ElkNode root) {
        String algorithm;
        if (!root.getChildren().isEmpty() && ((algorithm = (String)root.getProperty(CoreOptions.ALGORITHM)) == null || "org.eclipse.elk.layered".endsWith(algorithm))) {
            for (ElkNode node : root.getChildren()) {
                if (node.hasProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT)) {
                    LayerConstraint constraint = (LayerConstraint)((Object)node.getProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT));
                    node.setProperty(LayeredOptions.LAYERING_LAYER_CONSTRAINT, (Object)LayerConstraint.NONE);
                    switch (constraint) {
                        case FIRST: {
                            if ((Integer)node.getProperty(LayeredOptions.LAYERING_LAYER_CHOICE_CONSTRAINT) != -1) break;
                            node.setProperty(LayeredOptions.LAYERING_LAYER_CHOICE_CONSTRAINT, (Object)0);
                            break;
                        }
                        case LAST: {
                            if ((Integer)node.getProperty(LayeredOptions.LAYERING_LAYER_CHOICE_CONSTRAINT) != -1) break;
                            node.setProperty(LayeredOptions.LAYERING_LAYER_CHOICE_CONSTRAINT, (Object)Integer.MAX_VALUE);
                        }
                    }
                }
                this.setCoordinates(root);
                this.setInteractiveStrategies(root);
            }
        }
    }

    private void setCoordinates(ElkNode root) {
        List<List<ElkNode>> layers = this.calcLayerNodes((List<ElkNode>)root.getChildren());
        Direction direction = (Direction)root.getProperty(LayeredOptions.DIRECTION);
        this.setCoordinateInLayoutDirection(layers, direction);
        int layerId = 0;
        for (List<ElkNode> layer : layers) {
            if (layer.size() <= 0) continue;
            this.setCoordinatesOrthogonalToLayoutDirection(layer, layerId, direction);
            ++layerId;
        }
    }

    private List<List<ElkNode>> calcLayerNodes(List<ElkNode> nodes) {
        ArrayList<ElkNode> allNodes = new ArrayList<ElkNode>();
        ArrayList<ElkNode> nodesWithLayerConstraint = new ArrayList<ElkNode>();
        for (ElkNode node : nodes) {
            allNodes.add(node);
            if ((Integer)node.getProperty(LayeredOptions.LAYERING_LAYER_CHOICE_CONSTRAINT) == -1) continue;
            nodesWithLayerConstraint.add(node);
        }
        List<List<ElkNode>> layerNodes = this.initialLayers(allNodes);
        this.assignLayersToNodesWithProperty(nodesWithLayerConstraint, layerNodes);
        return layerNodes;
    }

    private void assignLayersToNodesWithProperty(List<ElkNode> nodesWithLayerConstraint, List<List<ElkNode>> layering) {
        nodesWithLayerConstraint.sort((a, b) -> (Integer)a.getProperty(LayeredOptions.LAYERING_LAYER_CHOICE_CONSTRAINT) - (Integer)b.getProperty(LayeredOptions.LAYERING_LAYER_CHOICE_CONSTRAINT));
        int diff = 0;
        for (ElkNode node : nodesWithLayerConstraint) {
            int currentLayer = (Integer)node.getProperty(LayeredOptions.LAYERING_LAYER_CHOICE_CONSTRAINT) - diff;
            if (currentLayer < layering.size()) {
                List<ElkNode> nodesOfLayer = layering.get(currentLayer);
                this.shiftOtherNodes(node, currentLayer, layering, true);
                this.shiftOtherNodes(node, currentLayer, layering, false);
                nodesOfLayer.add(node);
                continue;
            }
            diff = diff + currentLayer - layering.size();
            layering.add(new ArrayList<ElkNode>(Arrays.asList(node)));
        }
    }

    private void shiftOtherNodes(ElkNode movedNode, int layer, List<List<ElkNode>> layerNodes, boolean incoming) {
        ElkNode root;
        List<ElkNode> nodesOfLayer = layerNodes.get(layer);
        ArrayList<ElkEdge> edges = new ArrayList<ElkEdge>();
        if (incoming) {
            root = movedNode.getParent();
            for (ElkEdge edge : root.getContainedEdges()) {
                for (ElkConnectableShape target : edge.getTargets()) {
                    if (!target.equals(movedNode) && (!(target instanceof ElkPort) || !target.eContainer().equals(movedNode))) continue;
                    edges.add(edge);
                }
            }
        } else {
            root = movedNode.getParent();
            for (ElkEdge edge : root.getContainedEdges()) {
                for (ElkConnectableShape target : edge.getSources()) {
                    if (!target.equals(movedNode) && (!(target instanceof ElkPort) || !target.eContainer().equals(movedNode))) continue;
                    edges.add(edge);
                }
            }
        }
        for (ElkEdge edge : edges) {
            ElkNode node = null;
            if (incoming) {
                if (edge.getSources().get(0) instanceof ElkPort) {
                    node = (ElkNode)((ElkConnectableShape)edge.getSources().get(0)).eContainer();
                } else if (edge.getSources().get(0) instanceof ElkNode) {
                    node = (ElkNode)edge.getSources().get(0);
                }
            } else if (edge.getTargets().get(0) instanceof ElkPort) {
                node = (ElkNode)((ElkConnectableShape)edge.getTargets().get(0)).eContainer();
            } else if (edge.getTargets().get(0) instanceof ElkNode) {
                node = (ElkNode)edge.getTargets().get(0);
            }
            if (!nodesOfLayer.contains(node)) continue;
            nodesOfLayer.remove(node);
            if (layer + 1 < layerNodes.size()) {
                List<ElkNode> newLayer = layerNodes.get(layer + 1);
                newLayer.add(node);
                this.shiftOtherNodes(node, layer + 1, layerNodes, false);
                this.shiftOtherNodes(node, layer + 1, layerNodes, true);
                continue;
            }
            layerNodes.add(new ArrayList<ElkNode>(Arrays.asList(node)));
        }
    }

    private List<List<ElkNode>> initialLayers(ArrayList<ElkNode> nodes) {
        nodes.sort((a, b) -> (Integer)a.getProperty(LayeredOptions.LAYERING_LAYER_ID) - (Integer)b.getProperty(LayeredOptions.LAYERING_LAYER_ID));
        ArrayList<List<ElkNode>> layerNodes = new ArrayList<List<ElkNode>>();
        ArrayList<ElkNode> nodesOfLayer = new ArrayList<ElkNode>();
        int currentLayer = -1;
        for (ElkNode node : nodes) {
            int layer = (Integer)node.getProperty(LayeredOptions.LAYERING_LAYER_ID);
            if (layer > currentLayer) {
                if (!nodesOfLayer.isEmpty()) {
                    layerNodes.add(nodesOfLayer);
                }
                nodesOfLayer = new ArrayList();
                currentLayer = layer;
            }
            if ((Integer)node.getProperty(LayeredOptions.LAYERING_LAYER_CHOICE_CONSTRAINT) != -1) continue;
            nodesOfLayer.add(node);
        }
        if (!nodesOfLayer.isEmpty()) {
            layerNodes.add(nodesOfLayer);
        }
        return layerNodes;
    }

    private void setCoordinateInLayoutDirection(List<List<ElkNode>> layers, Direction direction) {
        double position = 0.0;
        double nextPosition = 0.0;
        for (List<ElkNode> nodesOfLayer : layers) {
            for (ElkNode node : nodesOfLayer) {
                switch (direction) {
                    case UNDEFINED: 
                    case RIGHT: {
                        node.setX(position);
                        if (!(position + node.getWidth() / 2.0 >= nextPosition)) break;
                        nextPosition = node.getX() + node.getWidth() + 2.147483647E9;
                        break;
                    }
                    case LEFT: {
                        node.setX(position);
                        if (!(node.getX() <= nextPosition)) break;
                        nextPosition = node.getX() - 2.147483647E9;
                        break;
                    }
                    case DOWN: {
                        node.setY(position);
                        if (!(position + node.getHeight() >= nextPosition)) break;
                        nextPosition = node.getY() + node.getHeight() + 2.147483647E9;
                        break;
                    }
                    case UP: {
                        node.setY(position);
                        if (!(node.getY() <= nextPosition)) break;
                        nextPosition = node.getY() - 2.147483647E9;
                    }
                }
            }
            position = nextPosition;
        }
    }

    private void setCoordinatesOrthogonalToLayoutDirection(List<ElkNode> nodesOfLayer, int layerId, Direction direction) {
        ArrayList<ElkNode> nodesWithPositionConstraint = new ArrayList<ElkNode>();
        ArrayList<ElkNode> nodes = new ArrayList<ElkNode>();
        for (ElkNode node : nodesOfLayer) {
            if ((Integer)node.getProperty(LayeredOptions.CROSSING_MINIMIZATION_POSITION_CHOICE_CONSTRAINT) != -1) {
                nodesWithPositionConstraint.add(node);
                continue;
            }
            nodes.add(node);
        }
        this.sortNodesInLayer(nodesWithPositionConstraint, nodes, direction);
        for (ElkNode node : nodesWithPositionConstraint) {
            int pos = (Integer)node.getProperty(LayeredOptions.CROSSING_MINIMIZATION_POSITION_CHOICE_CONSTRAINT);
            if (pos < nodes.size()) {
                nodes.add(pos, node);
                continue;
            }
            nodes.add(node);
        }
        switch (direction) {
            case UNDEFINED: 
            case RIGHT: 
            case LEFT: {
                double yPos = ((ElkNode)nodes.get(0)).getY();
                for (ElkNode node : nodes) {
                    node.setProperty(LayeredOptions.POSITION, (Object)new KVector(node.getX(), yPos));
                    yPos += node.getHeight() + 2.147483647E9;
                }
                break;
            }
            case DOWN: 
            case UP: {
                double xPos = ((ElkNode)nodes.get(0)).getX() + (double)(2 * layerId * Integer.MAX_VALUE);
                for (ElkNode node : nodes) {
                    node.setProperty(LayeredOptions.POSITION, (Object)new KVector(xPos, node.getY()));
                    xPos += node.getWidth() + 2.147483647E9;
                }
                break;
            }
        }
    }

    private void sortNodesInLayer(List<ElkNode> nodesWithPositionConstraint, List<ElkNode> nodes, Direction direction) {
        nodesWithPositionConstraint.sort((a, b) -> (Integer)a.getProperty(LayeredOptions.CROSSING_MINIMIZATION_POSITION_CHOICE_CONSTRAINT) - (Integer)b.getProperty(LayeredOptions.CROSSING_MINIMIZATION_POSITION_CHOICE_CONSTRAINT));
        nodes.sort((a, b) -> {
            switch (direction) {
                case UNDEFINED: 
                case RIGHT: 
                case LEFT: {
                    return (int)(a.getY() - b.getY());
                }
                case DOWN: 
                case UP: {
                    return (int)(a.getX() - b.getX());
                }
            }
            return 0;
        });
    }

    private void setInteractiveStrategies(ElkNode parent) {
        parent.setProperty(LayeredOptions.CROSSING_MINIMIZATION_SEMI_INTERACTIVE, (Object)true);
        parent.setProperty(LayeredOptions.LAYERING_STRATEGY, (Object)LayeringStrategy.INTERACTIVE);
        parent.setProperty(LayeredOptions.CYCLE_BREAKING_STRATEGY, (Object)CycleBreakingStrategy.INTERACTIVE);
    }
}

