/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.preferences;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.gmf.runtime.diagram.ui.preferences.DiagramsPreferencePage;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.sirius.diagram.tools.api.preferences.SiriusDiagramPreferencesKeys;
import org.eclipse.sirius.diagram.tools.internal.preferences.SiriusDiagramInternalPreferencesKeys;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.preferences.SiriusDiagramUiPreferencesKeys;
import org.eclipse.sirius.diagram.ui.tools.internal.preferences.SiriusDiagramUiInternalPreferencesKeys;
import org.eclipse.sirius.ui.business.api.preferences.SiriusUIPreferencesKeys;
import org.eclipse.sirius.ui.tools.internal.preference.BooleanFieldEditorWithHelp;
import org.eclipse.sirius.ui.tools.internal.preference.RadioGroupFieldEditorWithHelp;
import org.eclipse.sirius.ui.tools.internal.preference.ScaleWithLegendFieldEditorWithHelp;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class DiagramGeneralPreferencePage
extends DiagramsPreferencePage {
    private static final int MAX_QUALITY = 10;
    private static final int MIN_QUALITY = 0;
    private static final int INCREMENT_QUALITY = 1;
    private BooleanFieldEditor moveUnlinkedNotesDuringLayout;
    private BooleanFieldEditor synchronizeOnDiagramCreation;
    private ScaleWithLegendFieldEditorWithHelp scaleWithLegendFieldEditor;

    public DiagramGeneralPreferencePage() {
        this.setPreferenceStore(DiagramUIPlugin.getPlugin().getPreferenceStore());
    }

    protected void createFieldEditors() {
        super.createFieldEditors();
        this.addPasteModeFields(this.getFieldEditorParent());
        this.addQualityExportField(this.getFieldEditorParent());
        this.addBooleanPreference(SiriusDiagramUiInternalPreferencesKeys.PREF_AUTOSIZE_ON_ARRANGE.name(), Messages.DiagramGeneralPreferencePage_arrangeAndAutoSizeContainersLabel);
        this.moveUnlinkedNotesDuringLayout = this.addBooleanPreference(SiriusDiagramPreferencesKeys.PREF_MOVE_NOTES_DURING_LATOUT.name(), Messages.DiagramGeneralPreferencePage_moveUnlinkedNodeLabel);
        this.addBooleanPreference(SiriusDiagramUiInternalPreferencesKeys.PREF_AUTO_PIN_ON_MOVE.name(), Messages.DiagramGeneralPreferencePage_pinMovedElementsLabel);
        this.synchronizeOnDiagramCreation = this.addBooleanPreference(SiriusDiagramInternalPreferencesKeys.PREF_SYNCHRONIZE_DIAGRAM_ON_CREATION.name(), Messages.DiagramGeneralPreferencePage_synchronizedModeLabel);
        this.addBooleanPreference(SiriusDiagramUiPreferencesKeys.PREF_SHOW_SYNCHRONIZE_STATUS_DECORATOR.name(), Messages.DiagramGeneralPreferencePage_showSynchronizeStatusDecoratorLabel);
        this.addBooleanPreference(SiriusDiagramUiInternalPreferencesKeys.PREF_REMOVE_HIDE_NOTE_WHEN_ANNOTED_ELEMENT_HIDDEN_OR_REMOVE.name(), Messages.DiagramGeneralPreferencePage_removeHideNoteLabel);
    }

    private BooleanFieldEditor addBooleanPreference(String key, String label) {
        BooleanFieldEditor fieldEditor = new BooleanFieldEditor(key, label, this.getFieldEditorParent());
        this.addField((FieldEditor)fieldEditor);
        return fieldEditor;
    }

    protected void initialize() {
        super.initialize();
        ScopedPreferenceStore diagramCorePreferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.sirius.diagram");
        this.moveUnlinkedNotesDuringLayout.setPreferenceStore((IPreferenceStore)diagramCorePreferenceStore);
        this.moveUnlinkedNotesDuringLayout.load();
        this.synchronizeOnDiagramCreation.setPreferenceStore((IPreferenceStore)diagramCorePreferenceStore);
        this.synchronizeOnDiagramCreation.load();
        ScopedPreferenceStore siriusUiCorePreferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.sirius.ui");
        this.scaleWithLegendFieldEditor.setPreferenceStore((IPreferenceStore)siriusUiCorePreferenceStore);
        this.scaleWithLegendFieldEditor.load();
    }

    public static void initDefaults(IPreferenceStore preferenceStore) {
        DiagramsPreferencePage.initDefaults((IPreferenceStore)preferenceStore);
        preferenceStore.setDefault(SiriusDiagramUiInternalPreferencesKeys.PREF_AUTOSIZE_ON_ARRANGE.name(), true);
        preferenceStore.setDefault(SiriusDiagramUiInternalPreferencesKeys.PREF_AUTO_PIN_ON_MOVE.name(), true);
        preferenceStore.setDefault(SiriusDiagramUiInternalPreferencesKeys.PREF_REMOVE_HIDE_NOTE_WHEN_ANNOTED_ELEMENT_HIDDEN_OR_REMOVE.name(), true);
        preferenceStore.setDefault(SiriusDiagramUiPreferencesKeys.PREF_SHOW_SYNCHRONIZE_STATUS_DECORATOR.name(), false);
        preferenceStore.setDefault(SiriusDiagramUiPreferencesKeys.PREF_SCALE_DIAGRAMS_ON_EXPORT.name(), true);
        preferenceStore.setDefault(SiriusDiagramUiPreferencesKeys.PREF_MAXIMUM_EXPORT_BUFFER_SIZE.name(), 4125000);
        preferenceStore.setDefault(SiriusDiagramUiPreferencesKeys.PREF_MAXIMUM_EXPORT_BUFFER_SIZE_WINDOWS.name(), 50000000);
        preferenceStore.setDefault(SiriusDiagramUiPreferencesKeys.PREF_PROMPT_PASTE_MODE.name(), true);
        preferenceStore.setDefault(SiriusDiagramUiPreferencesKeys.PREF_PASTE_MODE_ABSOLUTE.name(), true);
    }

    private void addPasteModeFields(Composite parent) {
        Group pasteModeGroup = new Group(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 5;
        gridLayout.verticalSpacing = 8;
        pasteModeGroup.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        pasteModeGroup.setLayoutData((Object)gridData);
        pasteModeGroup.setText(Messages.DiagramGeneralPreferencePage_pasteLayoutModeGroupLabel);
        Composite booleanFieldParent = new Composite((Composite)pasteModeGroup, 0);
        gridLayout = new GridLayout(2, false);
        booleanFieldParent.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        booleanFieldParent.setLayoutData((Object)gridData);
        BooleanFieldEditorWithHelp promptFieldEditor = new BooleanFieldEditorWithHelp(SiriusDiagramUiPreferencesKeys.PREF_PROMPT_PASTE_MODE.name(), Messages.DiagramGeneralPreferencePage_pasteLayoutModePromptMessage, Messages.DiagramGeneralPreferencePage_pasteLayoutModePromptTooltip, booleanFieldParent);
        this.addField((FieldEditor)promptFieldEditor);
        Composite radioFieldParent = new Composite((Composite)pasteModeGroup, 0);
        gridLayout = new GridLayout(2, false);
        radioFieldParent.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalIndent = 10;
        gridData.horizontalSpan = 2;
        radioFieldParent.setLayoutData((Object)gridData);
        this.addField((FieldEditor)new RadioGroupFieldEditorWithHelp(SiriusDiagramUiPreferencesKeys.PREF_PASTE_MODE_ABSOLUTE.name(), "", 1, new String[][]{{Messages.SelectPasteModeDialog_absoluteModeLabel, Boolean.TRUE.toString()}, {Messages.SelectPasteModeDialog_boundingBoxModeLabel, Boolean.FALSE.toString()}}, new String[]{Messages.SelectPasteModeDialog_absoluteModeTooltip, Messages.SelectPasteModeDialog_boundingBoxModeTooltip}, radioFieldParent){

            protected void doFillIntoGrid(Composite parent, int numColumns) {
                Composite control = this.getRadioBoxControl(parent);
                GridData gd = new GridData(768);
                control.setLayoutData((Object)gd);
            }
        });
    }

    private void addQualityExportField(Composite parent) {
        Group imageSizeGroup = new Group(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        imageSizeGroup.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        imageSizeGroup.setLayoutData((Object)gridData);
        imageSizeGroup.setText(Messages.DiagramGeneralPreferencePage_sizeGroupLabel);
        this.scaleWithLegendFieldEditor = new ScaleWithLegendFieldEditorWithHelp(SiriusUIPreferencesKeys.PREF_SCALE_LEVEL_DIAGRAMS_ON_EXPORT.name(), Messages.DiagramGeneralPreferencePage_sizeGroupLabel, org.eclipse.sirius.viewpoint.provider.Messages.ExportAsImage_sizeTooltip, (Composite)imageSizeGroup);
        this.scaleWithLegendFieldEditor.setMinimum(0);
        this.scaleWithLegendFieldEditor.setMaximum(10);
        this.scaleWithLegendFieldEditor.setPageIncrement(1);
        this.addField((FieldEditor)this.scaleWithLegendFieldEditor);
    }
}

