/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.swtbot.support.api;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gmf.runtime.diagram.ui.editparts.AbstractBorderedShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DescriptionCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.TextEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.preferences.SiriusPreferencesKeys;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.tools.api.preferences.SiriusDiagramPreferencesKeys;
import org.eclipse.sirius.diagram.tools.internal.preferences.SiriusDiagramInternalPreferencesKeys;
import org.eclipse.sirius.diagram.ui.business.internal.dialect.DiagramDialectUIServices;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.tools.api.preferences.SiriusDiagramUiPreferencesKeys;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.style.ResetStylePropertiesToDefaultValuesAction;
import org.eclipse.sirius.diagram.ui.tools.internal.preferences.SiriusDiagramUiInternalPreferencesKeys;
import org.eclipse.sirius.tests.support.api.EclipseTestsSupportHelper;
import org.eclipse.sirius.tests.support.api.TestCaseCleaner;
import org.eclipse.sirius.tests.support.api.TestsUtil;
import org.eclipse.sirius.tests.support.internal.helper.CrossReferenceAdapterDetector;
import org.eclipse.sirius.tests.swtbot.support.api.business.UILocalSession;
import org.eclipse.sirius.tests.swtbot.support.api.business.UIPerspective;
import org.eclipse.sirius.tests.swtbot.support.api.business.UIProject;
import org.eclipse.sirius.tests.swtbot.support.api.business.UIResource;
import org.eclipse.sirius.tests.swtbot.support.api.condition.OperationRedoneCondition;
import org.eclipse.sirius.tests.swtbot.support.api.condition.OperationUndoneCondition;
import org.eclipse.sirius.tests.swtbot.support.api.editor.SWTBotSiriusDiagramEditor;
import org.eclipse.sirius.tests.swtbot.support.api.editor.SWTBotSiriusHelper;
import org.eclipse.sirius.tests.swtbot.support.api.editor.SWTBotVSMEditor;
import org.eclipse.sirius.tests.swtbot.support.api.editor.SWTBotVSMHelper;
import org.eclipse.sirius.tests.swtbot.support.api.perspective.DesignerPerspectives;
import org.eclipse.sirius.tests.swtbot.support.api.view.DesignerViews;
import org.eclipse.sirius.tests.swtbot.support.utils.SWTBotCommonHelper;
import org.eclipse.sirius.tests.swtbot.support.utils.SWTBotUtils;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.ui.tools.internal.views.common.modelingproject.OpenRepresentationsFileJob;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.matchers.WidgetMatcherFactory;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotEditor;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.eclipse.gef.finder.SWTBotGefTestCase;
import org.eclipse.swtbot.eclipse.gef.finder.widgets.SWTBotGefEditPart;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.SWTBotTestCase;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.utils.ClassUtils;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.utils.SWTUtils;
import org.eclipse.swtbot.swt.finder.waits.ICondition;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotButton;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotMenu;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotToolbarButton;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ErrorEditorPart;
import org.hamcrest.Matcher;
import org.junit.Assert;

public abstract class AbstractSiriusSwtBotGefTestCase
extends SWTBotGefTestCase {
    protected static final String MODELS_DIR = "Models";
    protected static final String TEMP_PROJECT_NAME = "DesignerTestProject";
    private static final String EN_US = "EN_US";
    private static final String SET_STYLE_TO_WORKSPACE_IMAGE = "Set style to workspace image";
    private static final String POINT = ".";
    private static final String EDIT_MENU_NAME = "Edit";
    private static final List<String> SHELL_TO_CLOSE_AT_TEAR_DOWN_TEXTS;
    private static boolean fFullScreen;
    private static int screenshotCounter;
    private static Logger log;
    protected UIPerspective designerPerspective;
    protected DesignerPerspectives designerPerspectives;
    protected DesignerViews designerViews;
    protected UIProject designerProject;
    protected UIResource sessionAirdResource;
    protected UILocalSession localSession;
    protected SWTBotSiriusDiagramEditor editor;
    protected Multimap<String, IStatus> errors;
    protected Multimap<String, IStatus> warnings;
    private boolean defaultEnableAnimatedZoom;
    private boolean defaultEnableAnimatedLayout;
    private boolean defaultPromptPasteMode;
    private final HashMap<String, Object> oldValueDiagramPreferences;
    private final HashMap<String, Object> oldValueDiagramUIPreferences;
    private final HashMap<String, Object> oldValueSiriusPreferences;
    private final HashMap<String, Object> oldValueCommonPreferences;
    private final HashMap<String, Object> oldValueSiriusUIPreferences;
    private final HashMap<String, Object> oldPlatformUIPreferences;
    private Thread.UncaughtExceptionHandler exceptionHandler;
    private ILogListener logListener;
    private boolean errorCatchActive;
    private boolean warningCatchActive;

    static {
        SWTBotPreferences.TIMEOUT = 10000L;
        SHELL_TO_CLOSE_AT_TEAR_DOWN_TEXTS = new ArrayList<String>(Arrays.asList(OpenRepresentationsFileJob.JOB_LABEL));
        fFullScreen = true;
        log = Logger.getLogger(SWTBotTestCase.class);
    }

    public AbstractSiriusSwtBotGefTestCase() {
        this.designerPerspective = new UIPerspective((SWTWorkbenchBot)this.bot);
        this.designerPerspectives = new DesignerPerspectives((SWTWorkbenchBot)this.bot);
        this.designerViews = new DesignerViews((SWTWorkbenchBot)this.bot);
        this.oldValueDiagramPreferences = new HashMap();
        this.oldValueDiagramUIPreferences = new HashMap();
        this.oldValueSiriusPreferences = new HashMap();
        this.oldValueCommonPreferences = new HashMap();
        this.oldValueSiriusUIPreferences = new HashMap();
        this.oldPlatformUIPreferences = new HashMap();
    }

    protected void setUp() throws Exception {
        PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            Shell shell = PlatformUI.getWorkbench().getWorkbenchWindows()[0].getShell();
            String osName = System.getProperty("os.name");
            if (osName.contains("Mac") || osName.contains("Linux")) {
                shell.setMaximized(fFullScreen);
            } else {
                shell.setFullScreen(fFullScreen);
            }
            if (PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell() != null) {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().forceActive();
            }
        });
        this.errors = LinkedHashMultimap.create();
        this.warnings = LinkedHashMultimap.create();
        this.initLoggers();
        this.closeAllSessions(true);
        System.out.println("Setup of " + ((Object)((Object)this)).getClass().getName() + POINT + this.getName() + "()");
        try {
            super.setUp();
            UIThreadRunnable.syncExec(() -> {
                IPreferenceStore preferenceStore = DiagramUIPlugin.getPlugin().getPreferenceStore();
                this.defaultEnableAnimatedZoom = preferenceStore.getBoolean("Global.enableAnimatedZoom");
                preferenceStore.setValue("Global.enableAnimatedZoom", false);
                this.defaultEnableAnimatedLayout = preferenceStore.getBoolean("Global.enableAnimatedLayout");
                preferenceStore.setValue("Global.enableAnimatedLayout", false);
                this.defaultPromptPasteMode = preferenceStore.getBoolean(SiriusDiagramUiPreferencesKeys.PREF_PROMPT_PASTE_MODE.name());
                preferenceStore.setValue(SiriusDiagramUiPreferencesKeys.PREF_PROMPT_PASTE_MODE.name(), false);
                DefaultScope.INSTANCE.getNode("org.eclipse.sirius").putBoolean(SiriusPreferencesKeys.PREF_AUTO_REFRESH.name(), true);
                InstanceScope.INSTANCE.getNode("org.eclipse.sirius").putBoolean(SiriusPreferencesKeys.PREF_AUTO_REFRESH.name(), this.getAutoRefreshMode());
            });
            this.designerProject = this.designerPerspective.createProject(this.getProjectName());
            this.onSetUpBeforeClosingWelcomePage();
            this.closeWelcomePage();
            this.designerPerspectives.openModelingPerspective();
            this.onSetUpAfterOpeningDesignerPerspective();
        }
        catch (Throwable e) {
            this.takeScreenshot("-after-setup");
            try {
                this.failureTearDown();
            }
            catch (Exception exception) {}
            if (e instanceof Exception) {
                throw (Exception)e;
            }
            throw new RuntimeException(e);
        }
    }

    protected boolean getAutoRefreshMode() {
        return false;
    }

    protected String getProjectName() {
        return TEMP_PROJECT_NAME;
    }

    protected void onSetUpBeforeClosingWelcomePage() throws Exception {
    }

    protected void onSetUpAfterOpeningDesignerPerspective() throws Exception {
    }

    protected void closeAllEditors() {
        this.bot.getDisplay().asyncExec(() -> {
            IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
            int n = iWorkbenchWindowArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                IWorkbenchPage[] iWorkbenchPageArray = window.getPages();
                int n3 = iWorkbenchPageArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IWorkbenchPage page = iWorkbenchPageArray[n4];
                    page.closeAllEditors(false);
                    ++n4;
                }
                ++n2;
            }
        });
        SWTBotUtils.waitAllUiEvents();
    }

    private Set<String> closeAllSessions(boolean warn) {
        HashSet<String> sessionIDs = new HashSet<String>();
        PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
            LinkedHashSet<Session> sessionsToClose = new LinkedHashSet<Session>();
            for (Session sess1 : Sets.newLinkedHashSet((Iterable)SessionManager.INSTANCE.getSessions())) {
                if (!sess1.isOpen()) continue;
                sessionsToClose.add(sess1);
            }
            if (warn && !sessionsToClose.isEmpty()) {
                System.out.println("WARNING : the followings sessions were not closed on tearDown of previous tests: ");
                for (Session s1 : sessionsToClose) {
                    System.out.println("\t" + s1.getID());
                }
            }
            for (Session sess2 : sessionsToClose) {
                if (!sess2.isOpen()) continue;
                sessionIDs.add(sess2.getID());
                sess2.close((IProgressMonitor)new NullProgressMonitor());
            }
            if (warn && !sessionsToClose.isEmpty()) {
                if (sessionsToClose.size() == sessionIDs.size()) {
                    System.out.println("They have been closed now.");
                } else {
                    System.out.println("WARNING: some session are still open after close attempt: ");
                    for (Session s2 : sessionsToClose) {
                        if (sessionIDs.contains(s2.getID())) continue;
                        System.out.println("\t" + s2.getID());
                    }
                }
            }
        });
        return sessionIDs;
    }

    protected void closeWelcomePage() {
        Matcher matcher = WidgetMatcherFactory.withPartName((String)"Welcome");
        List views = this.bot.views(matcher);
        for (SWTBotView swtBotView : views) {
            swtBotView.close();
        }
    }

    protected void manualRefresh() {
        SWTBotUtils.toolbarButtonWithTooltip(DiagramDialectUIServices.REFRESH_DIAGRAM).click();
        SWTBotUtils.waitProgressMonitorClose("Progress Information");
        SWTBotUtils.waitAllUiEvents();
    }

    protected void runTest() throws Throwable {
        try {
            super.runTest();
        }
        catch (Throwable running) {
            this.takeScreenshot("-before-tearDown");
            throw running;
        }
    }

    public void takeScreenshot(CharSequence suffix) {
        String fileName = String.valueOf(SWTBotPreferences.SCREENSHOTS_DIR) + "/" + "screenshot-" + ClassUtils.simpleClassName(((Object)((Object)this)).getClass()) + POINT + this.getName() + suffix + POINT + SWTBotPreferences.SCREENSHOT_FORMAT.toLowerCase();
        new File(SWTBotPreferences.SCREENSHOTS_DIR).mkdirs();
        SWTUtils.captureScreenshot((String)fileName);
    }

    protected void openErrorLogViewByAPI() {
        PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
            try {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.pde.runtime.LogView");
            }
            catch (PartInitException e) {
                TestCase.fail((String)("Unable to open errorLog view : " + e.getMessage()));
            }
        });
    }

    protected void assertEditorIsNotError(String message, SWTBotEditor activeEditor) {
        IEditorPart editorPart = ((IEditorReference)activeEditor.getReference()).getEditor(false);
        boolean isError = editorPart instanceof ErrorEditorPart;
        if (isError) {
            activeEditor.close();
        }
        TestCase.assertFalse((String)message, (boolean)isError);
    }

    protected void undo() {
        Assert.assertTrue((this.editor != null ? 1 : 0) != 0);
        OperationUndoneCondition condition = new OperationUndoneCondition();
        this.bot.activeEditor();
        String savedKeyboardLayout = SWTBotPreferences.KEYBOARD_LAYOUT;
        SWTBotPreferences.KEYBOARD_LAYOUT = EN_US;
        this.editor.getCanvas().pressShortcut(262144, 'z');
        SWTBotPreferences.KEYBOARD_LAYOUT = savedKeyboardLayout;
        this.bot.waitUntil((ICondition)condition);
    }

    protected void undo(Session session) {
        session.getTransactionalEditingDomain().getCommandStack().undo();
    }

    protected void undo(String cmdName) {
        SWTBotSiriusHelper.menu((SWTBot)this.bot, EDIT_MENU_NAME).menu("Undo " + cmdName).click();
    }

    protected void redo() {
        Assert.assertTrue((this.editor != null ? 1 : 0) != 0);
        OperationRedoneCondition condition = new OperationRedoneCondition();
        this.bot.activeEditor();
        String savedKeyboardLayout = SWTBotPreferences.KEYBOARD_LAYOUT;
        SWTBotPreferences.KEYBOARD_LAYOUT = EN_US;
        if (System.getProperty("os.name").equals("Linux") && (TestsUtil.isJuno3Platform() || TestsUtil.isEclipse4xPlatform())) {
            this.editor.getCanvas().pressShortcut(393216, 'z');
        } else {
            this.editor.getCanvas().pressShortcut(262144, 'y');
        }
        SWTBotPreferences.KEYBOARD_LAYOUT = savedKeyboardLayout;
        this.bot.waitUntil((ICondition)condition);
    }

    protected void redo(String cmdName) {
        SWTBotSiriusHelper.menu((SWTBot)this.bot, EDIT_MENU_NAME).menu("Redo " + cmdName).click();
    }

    protected void redo(Session session) {
        session.getTransactionalEditingDomain().getCommandStack().redo();
    }

    protected void launchCancelCustomStyle() {
        this.bot.buttonWithTooltip("Cancel custom style").click();
    }

    protected void changeDiagramPreference(String preferenceKey, Integer newValue) {
        this.assertNoDiagramUIPreferenceChangedinDiagramCoreStore(preferenceKey);
        int oldValue = Platform.getPreferencesService().getInt("org.eclipse.sirius.diagram", preferenceKey, 0, null);
        this.oldValueDiagramPreferences.put(preferenceKey, oldValue);
        IEclipsePreferences diagramCorePreferences = InstanceScope.INSTANCE.getNode("org.eclipse.sirius.diagram");
        diagramCorePreferences.putInt(preferenceKey, newValue.intValue());
        int valueToCheck = Platform.getPreferencesService().getInt("org.eclipse.sirius.diagram", preferenceKey, 0, null);
        TestCase.assertEquals((String)this.getErrorMessage(preferenceKey, "org.eclipse.sirius.diagram"), (int)newValue, (int)valueToCheck);
    }

    protected void changeDiagramPreference(String preferenceKey, Boolean newValue) {
        this.assertNoDiagramUIPreferenceChangedinDiagramCoreStore(preferenceKey);
        boolean oldValue = Platform.getPreferencesService().getBoolean("org.eclipse.sirius.diagram", preferenceKey, false, null);
        this.oldValueDiagramPreferences.put(preferenceKey, oldValue);
        IEclipsePreferences diagramCorePreferences = InstanceScope.INSTANCE.getNode("org.eclipse.sirius.diagram");
        diagramCorePreferences.putBoolean(preferenceKey, newValue.booleanValue());
        boolean valueToCheck = Platform.getPreferencesService().getBoolean("org.eclipse.sirius.diagram", preferenceKey, false, null);
        TestCase.assertEquals((String)this.getErrorMessage(preferenceKey, "org.eclipse.sirius.diagram"), (boolean)newValue, (boolean)valueToCheck);
    }

    protected void resetDiagramPreference(String preferenceKey) {
        IEclipsePreferences diagramCorePreferences = InstanceScope.INSTANCE.getNode("org.eclipse.sirius.diagram");
        this.resetDiagramPreference(preferenceKey, diagramCorePreferences);
    }

    private void resetDiagramPreference(String preferenceKey, IEclipsePreferences diagramCorePreferences) {
        Object initialValue = this.oldValueDiagramPreferences.get(preferenceKey);
        if (initialValue instanceof Boolean) {
            diagramCorePreferences.putBoolean(preferenceKey, ((Boolean)initialValue).booleanValue());
        } else if (initialValue instanceof Integer) {
            diagramCorePreferences.putInt(preferenceKey, ((Integer)initialValue).intValue());
        }
    }

    protected void changeDiagramUIPreference(String preferenceKey, Boolean newValue) {
        this.assertNoDiagramCorePreferenceChangedinDiagramUIStore(preferenceKey);
        IPreferenceStore prefs = DiagramUIPlugin.getPlugin().getPreferenceStore();
        this.oldValueDiagramUIPreferences.put(preferenceKey, prefs.getBoolean(preferenceKey));
        UIThreadRunnable.syncExec(() -> prefs.setValue(preferenceKey, newValue.booleanValue()));
    }

    protected void changeDiagramUIPreference(String preferenceKey, int newValue) {
        this.assertNoDiagramCorePreferenceChangedinDiagramUIStore(preferenceKey);
        IPreferenceStore prefs = DiagramUIPlugin.getPlugin().getPreferenceStore();
        this.oldValueDiagramUIPreferences.put(preferenceKey, prefs.getInt(preferenceKey));
        UIThreadRunnable.syncExec(() -> prefs.setValue(preferenceKey, newValue));
    }

    protected void changeDiagramUIPreference(String preferenceKey, double newValue) {
        this.assertNoDiagramCorePreferenceChangedinDiagramUIStore(preferenceKey);
        IPreferenceStore prefs = DiagramUIPlugin.getPlugin().getPreferenceStore();
        this.oldValueDiagramUIPreferences.put(preferenceKey, prefs.getDouble(preferenceKey));
        UIThreadRunnable.syncExec(() -> prefs.setValue(preferenceKey, newValue));
    }

    protected void resetDiagramUIPreference(String preferenceKey) {
        IPreferenceStore diagramUIPreferences = DiagramUIPlugin.getPlugin().getPreferenceStore();
        this.resetDiagramUIPreference(preferenceKey, diagramUIPreferences);
    }

    private void resetDiagramUIPreference(String preferenceKey, IPreferenceStore diagramUIPreferences) {
        Object initialValue = this.oldValueDiagramUIPreferences.get(preferenceKey);
        if (initialValue instanceof Boolean) {
            diagramUIPreferences.setValue(preferenceKey, ((Boolean)initialValue).booleanValue());
        } else if (initialValue instanceof Integer) {
            diagramUIPreferences.setValue(preferenceKey, ((Integer)initialValue).intValue());
        }
    }

    protected void changeSiriusPreference(String preferenceKey, Boolean newValue) {
        boolean oldValue = Platform.getPreferencesService().getBoolean("org.eclipse.sirius", preferenceKey, false, null);
        this.oldValueSiriusPreferences.put(preferenceKey, oldValue);
        IEclipsePreferences corePreferences = InstanceScope.INSTANCE.getNode("org.eclipse.sirius");
        corePreferences.putBoolean(preferenceKey, newValue.booleanValue());
        boolean valueToCheck = Platform.getPreferencesService().getBoolean("org.eclipse.sirius", preferenceKey, false, null);
        TestCase.assertEquals((String)this.getErrorMessage(preferenceKey, "org.eclipse.sirius"), (boolean)newValue, (boolean)valueToCheck);
    }

    protected void changeSiriusCommonPreference(String preferenceKey, Boolean newValue) {
        boolean oldValue = Platform.getPreferencesService().getBoolean("org.eclipse.sirius", preferenceKey, false, null);
        this.oldValueCommonPreferences.put(preferenceKey, oldValue);
        IEclipsePreferences corePreferences = InstanceScope.INSTANCE.getNode("org.eclipse.sirius.common.ui");
        corePreferences.putBoolean(preferenceKey, newValue.booleanValue());
        boolean valueToCheck = Platform.getPreferencesService().getBoolean("org.eclipse.sirius.common.ui", preferenceKey, false, null);
        TestCase.assertEquals((String)this.getErrorMessage(preferenceKey, "org.eclipse.sirius.common.ui"), (boolean)newValue, (boolean)valueToCheck);
    }

    protected void changeSiriusUIPreference(String preferenceKey, Boolean newValue) {
        this.assertNoSiriusCorePreferenceChangedinSiriusUIStore(preferenceKey);
        IPreferenceStore viewpointUIPrefs = SiriusEditPlugin.getPlugin().getPreferenceStore();
        this.oldValueSiriusUIPreferences.put(preferenceKey, viewpointUIPrefs.getBoolean(preferenceKey));
        viewpointUIPrefs.setValue(preferenceKey, newValue.booleanValue());
    }

    protected void changePlatformUIPreference(String preferenceKey, Boolean newValue) {
        IPreferenceStore viewpointUIPrefs = PlatformUI.getPreferenceStore();
        this.oldPlatformUIPreferences.put(preferenceKey, viewpointUIPrefs.getBoolean(preferenceKey));
        viewpointUIPrefs.setValue(preferenceKey, newValue.booleanValue());
    }

    private void assertNoSiriusCorePreferenceChangedinSiriusUIStore(String preferenceKey) {
        ArrayList<SiriusPreferencesKeys> coreKeys = new ArrayList<SiriusPreferencesKeys>(Arrays.asList(SiriusPreferencesKeys.values()));
        Function prefToName = Enum::name;
        TestCase.assertFalse((String)("The DesignerPreferenceKey named " + preferenceKey + " should not be modified in the UI store."), (boolean)Lists.newArrayList((Iterable)Iterables.transform(coreKeys, (Function)prefToName)).contains(preferenceKey));
    }

    private void assertNoDiagramCorePreferenceChangedinDiagramUIStore(String preferenceKey) {
        SiriusDiagramInternalPreferencesKeys key;
        ArrayList<String> coreKeys = new ArrayList<String>();
        SiriusDiagramInternalPreferencesKeys[] siriusDiagramInternalPreferencesKeysArray = SiriusDiagramInternalPreferencesKeys.values();
        int n = siriusDiagramInternalPreferencesKeysArray.length;
        int n2 = 0;
        while (n2 < n) {
            key = siriusDiagramInternalPreferencesKeysArray[n2];
            coreKeys.add(key.name());
            ++n2;
        }
        siriusDiagramInternalPreferencesKeysArray = SiriusDiagramPreferencesKeys.values();
        n = siriusDiagramInternalPreferencesKeysArray.length;
        n2 = 0;
        while (n2 < n) {
            key = siriusDiagramInternalPreferencesKeysArray[n2];
            coreKeys.add(key.name());
            ++n2;
        }
        coreKeys.add("Viewpoint.Connectors.enableOverride");
        coreKeys.add("Viewpoint.Connectors.lineStyle");
        coreKeys.add("Sirius.Connectors.JumpLink.enableOverride");
        coreKeys.add("Sirius.Connectors.JumpLink.status");
        coreKeys.add("Sirius.Connectors.JumpLink.type");
        coreKeys.add("Sirius.Connectors.JumpLink.reverse");
        AbstractSiriusSwtBotGefTestCase.assertFalse((String)("The Diagram core preference named " + preferenceKey + " should not be modified in the Diagram UI store."), (boolean)coreKeys.contains(preferenceKey));
    }

    private void assertNoDiagramUIPreferenceChangedinDiagramCoreStore(String preferenceKey) {
        SiriusDiagramUiInternalPreferencesKeys key;
        ArrayList<String> uiKeys = new ArrayList<String>();
        SiriusDiagramUiInternalPreferencesKeys[] siriusDiagramUiInternalPreferencesKeysArray = SiriusDiagramUiInternalPreferencesKeys.values();
        int n = siriusDiagramUiInternalPreferencesKeysArray.length;
        int n2 = 0;
        while (n2 < n) {
            key = siriusDiagramUiInternalPreferencesKeysArray[n2];
            uiKeys.add(key.name());
            ++n2;
        }
        siriusDiagramUiInternalPreferencesKeysArray = SiriusDiagramUiPreferencesKeys.values();
        n = siriusDiagramUiInternalPreferencesKeysArray.length;
        n2 = 0;
        while (n2 < n) {
            key = siriusDiagramUiInternalPreferencesKeysArray[n2];
            uiKeys.add(key.name());
            ++n2;
        }
        AbstractSiriusSwtBotGefTestCase.assertFalse((String)("The Diagram UI preference named " + preferenceKey + " should not be modified in the Diagram core store."), (boolean)uiKeys.contains(preferenceKey));
    }

    private String getErrorMessage(String preferenceKey, String pluginId) {
        return "The " + preferenceKey + " preference value was not changed for plugin " + pluginId;
    }

    protected void deleteSelectedElement() {
        SWTBotMenu deleteMenu = this.checkDeleteMenuEnablement(true);
        deleteMenu.click();
    }

    protected void deleteFromDiagram() {
        String savedKeyboardLayout = SWTBotPreferences.KEYBOARD_LAYOUT;
        SWTBotPreferences.KEYBOARD_LAYOUT = EN_US;
        this.editor.getCanvas().pressShortcut(393216, 'd');
        SWTBotPreferences.KEYBOARD_LAYOUT = savedKeyboardLayout;
        SWTBotUtils.waitAllUiEvents();
    }

    protected SWTBotMenu checkDeleteMenuEnablement(boolean expected) {
        SWTBotMenu deleteMenu = SWTBotSiriusHelper.menu((SWTBot)this.bot, EDIT_MENU_NAME).menu("Delete");
        String errorMessage = expected ? "Delete menu should be enabled" : "Delete menu was not enabled";
        TestCase.assertEquals((String)errorMessage, (boolean)expected, (boolean)deleteMenu.isEnabled());
        return deleteMenu;
    }

    protected void maximizeEditor() {
        SWTBotSiriusHelper.menu((SWTBot)this.bot, "Window").menu("Navigation").menu("Maximize Active View or Editor").click();
    }

    protected void maximizeEditor(SWTBotSiriusDiagramEditor swtBotDesignerEditor) {
        swtBotDesignerEditor.maximize();
    }

    protected void pressZoomInButton(SWTBotSiriusDiagramEditor swtBotDesignerEditor) {
        this.pressZoomInButton(swtBotDesignerEditor, 1);
    }

    protected void pressZoomInButton(SWTBotSiriusDiagramEditor swtBotDesignerEditor, int pressCount) {
        int i = 1;
        while (i <= pressCount) {
            try {
                swtBotDesignerEditor.bot().toolbarButtonWithTooltip("Zoom In (Ctrl++)").click();
            }
            catch (WidgetNotFoundException widgetNotFoundException) {
                swtBotDesignerEditor.bot().toolbarButtonWithTooltip("Zoom In (Ctrl+=)").click();
            }
            ++i;
        }
    }

    protected void pressZoomOutButton(SWTBotSiriusDiagramEditor swtBotDesignerEditor) {
        this.pressZoomOutButton(swtBotDesignerEditor, 1);
    }

    protected void pressZoomOutButton(SWTBotSiriusDiagramEditor swtBotDesignerEditor, int pressCount) {
        int i = 1;
        while (i <= pressCount) {
            swtBotDesignerEditor.bot().toolbarButtonWithTooltip("Zoom Out (Ctrl+-)").click();
            ++i;
        }
    }

    protected void restoreEditor(SWTBotSiriusDiagramEditor swtBotDesignerEditor) {
        swtBotDesignerEditor.restore();
    }

    protected SWTBotMenu arrangeAll() {
        this.editor.setFocus();
        this.editor.select(new SWTBotGefEditPart[]{this.editor.mainEditPart()});
        SWTBotMenu arrangeAllMenutBot = SWTBotSiriusHelper.menu((SWTBot)this.bot, "Diagram").menu("Arrange").menu("All").click();
        SWTBotUtils.waitAllUiEvents();
        return arrangeAllMenutBot;
    }

    protected Collection<DRepresentation> getRepresentations(Session session, String representationDescriptionName) {
        Collection allRepresentations = DialectManager.INSTANCE.getAllRepresentations(session);
        HashSet<DRepresentation> representations = new HashSet<DRepresentation>();
        for (DRepresentation representation : allRepresentations) {
            RepresentationDescription desc = DialectManager.INSTANCE.getDescription(representation);
            if (desc == null || !representationDescriptionName.equals(desc.getName())) continue;
            representations.add(representation);
        }
        return representations;
    }

    protected DRepresentationDescriptor getRepresentationDescriptorWithName(Session session, String representationDescriptionName, String representationName) {
        for (DRepresentationDescriptor descriptor : DialectManager.INSTANCE.getAllRepresentationDescriptors(session)) {
            if (!representationName.equals(descriptor.getName()) || representationDescriptionName != null && !representationDescriptionName.equals(descriptor.getDescription().getName())) continue;
            return descriptor;
        }
        return null;
    }

    protected final DRepresentation getRepresentationWithName(Session session, String representationDescriptionName, String representationName) {
        DRepresentationDescriptor representationDescriptorWithName = this.getRepresentationDescriptorWithName(session, representationDescriptionName, representationName);
        if (representationDescriptorWithName != null) {
            return representationDescriptorWithName.getRepresentation();
        }
        throw new NoSuchElementException("No representation found in session with \"" + representationName + "\" as representation name and with \"" + representationDescriptionName + "\" as representation description name.");
    }

    @Deprecated
    protected SWTBotSiriusDiagramEditor openDiagram(Session session, String diagramDescriptionName, String diagramName, Class<? extends DRepresentation> expectedRepresentationClass) {
        return this.openDiagram(session, diagramDescriptionName, diagramName, expectedRepresentationClass, false);
    }

    @Deprecated
    protected SWTBotSiriusDiagramEditor openDiagram(Session session, String diagramDescriptionName, String diagramName, Class<? extends DRepresentation> expectedRepresentationClass, boolean disableSnapToGridOnThisEditor) {
        AbstractSiriusSwtBotGefTestCase.assertTrue((String)"This method is only able to deal with diagrams.", (boolean)DiagramPackage.Literals.DDIAGRAM.getInstanceClass().isAssignableFrom(expectedRepresentationClass));
        SWTBotEditor diagramEditor = this.openRepresentation(session, diagramDescriptionName, diagramName, expectedRepresentationClass, disableSnapToGridOnThisEditor);
        AbstractSiriusSwtBotGefTestCase.assertTrue((boolean)(diagramEditor instanceof SWTBotSiriusDiagramEditor));
        return (SWTBotSiriusDiagramEditor)diagramEditor;
    }

    protected SWTBotEditor openRepresentation(Session session, String representationDescriptionName, String representationName, Class<? extends DRepresentation> expectedRepresentationClass) {
        return this.openRepresentation(session, representationDescriptionName, representationName, expectedRepresentationClass, false, true);
    }

    protected SWTBotEditor openRepresentation(Session session, String representationDescriptionName, String representationName, Class<? extends DRepresentation> expectedRepresentationClass, boolean disableSnapToGridOnThisEditor) {
        return this.openRepresentation(session, representationDescriptionName, representationName, expectedRepresentationClass, disableSnapToGridOnThisEditor, true);
    }

    protected SWTBotEditor openRepresentation(Session session, String representationDescriptionName, String representationName, Class<? extends DRepresentation> expectedRepresentationClass, boolean disableSnapToGridOnThisEditor, boolean disableSnapToShapeOnThisEditor) {
        DRepresentation representation = this.getRepresentationWithName(session, representationDescriptionName, representationName);
        TestCase.assertTrue((String)("This representation should be a " + expectedRepresentationClass.getSimpleName()), (boolean)expectedRepresentationClass.isInstance(representation));
        IEditorPart editorPart = DialectUIManager.INSTANCE.openEditor(session, representation, (IProgressMonitor)new NullProgressMonitor());
        SWTBotUtils.waitAllUiEvents();
        SWTBotSiriusDiagramEditor swtBotEditor = null;
        String expectedTitle = editorPart.getTitle();
        if (TestsUtil.isLunaPlatform()) {
            expectedTitle = Optional.ofNullable(expectedTitle).orElse("").trim();
        }
        if (DDiagram.class.isAssignableFrom(expectedRepresentationClass)) {
            swtBotEditor = SWTBotSiriusHelper.getSiriusDiagramEditor(expectedTitle);
            if (disableSnapToGridOnThisEditor) {
                swtBotEditor.setSnapToGrid(false);
            }
            if (disableSnapToShapeOnThisEditor) {
                swtBotEditor.setSnapToShape(false);
            }
        } else {
            swtBotEditor = SWTBotSiriusHelper.getSiriusEditor(expectedTitle);
        }
        return swtBotEditor;
    }

    protected AbstractSWTBot<? extends Widget> getSetStyleToWorkspaceImageButton(boolean tabbar, boolean enabled) {
        Object wkpImageButton = null;
        wkpImageButton = tabbar ? this.getSetStyleToWorkspaceImageButtonFromTabbar() : this.getSetStyleToWorkspaceImageButtonFromAppearanceTab();
        TestCase.assertNotNull((String)("Can't find the SetStyleToWorkspaceImage button in the " + (tabbar ? "tabbar" : "Appearance tab")), (Object)wkpImageButton);
        TestCase.assertEquals((String)("The SetStyleToWorkspaceImage button should be " + (enabled ? "enabled" : "disabled")), (boolean)enabled, (boolean)wkpImageButton.isEnabled());
        return wkpImageButton;
    }

    protected AbstractSWTBot<? extends Widget> getResetStylePropertiesToDefaultValuesButton(boolean tabbar, boolean enabled) {
        Object resetStylePropertiesToDefaultValuesButton = null;
        resetStylePropertiesToDefaultValuesButton = !tabbar ? this.getResetStylePropertiesToDefaultValuesButtonFromAppearanceTab() : this.getResetStylePropertiesToDefaultValuesButtonFromTabbar();
        TestCase.assertNotNull((String)("Can't find the \"" + ResetStylePropertiesToDefaultValuesAction.ACTION_NAME + "\" button in the " + (tabbar ? "tabbar" : "Appearance tab")), (Object)resetStylePropertiesToDefaultValuesButton);
        TestCase.assertEquals((String)("The \"" + ResetStylePropertiesToDefaultValuesAction.ACTION_NAME + "\" button should be " + (enabled ? "enabled" : "disabled")), (boolean)enabled, (boolean)resetStylePropertiesToDefaultValuesButton.isEnabled());
        return resetStylePropertiesToDefaultValuesButton;
    }

    private SWTBotToolbarButton getSetStyleToWorkspaceImageButtonFromTabbar() {
        return this.getTabbarButton(SET_STYLE_TO_WORKSPACE_IMAGE);
    }

    protected SWTBotToolbarButton getResetStylePropertiesToDefaultValuesButtonFromTabbar() {
        return this.getTabbarButton(ResetStylePropertiesToDefaultValuesAction.ACTION_NAME);
    }

    private SWTBotButton getSetStyleToWorkspaceImageButtonFromAppearanceTab() {
        return this.getSectionButton(SET_STYLE_TO_WORKSPACE_IMAGE);
    }

    protected void click(AbstractSWTBot<? extends Widget> button) {
        if (button instanceof SWTBotToolbarButton) {
            ((SWTBotToolbarButton)button).click();
        } else if (button instanceof SWTBotButton) {
            ((SWTBotButton)button).click();
        }
    }

    protected SWTBotButton getResetStylePropertiesToDefaultValuesButtonFromAppearanceTab() {
        SWTBotButton resetStylePropertiesToDefaultValuesButtonFromAppearanceTab = null;
        this.editor.show();
        this.editor.setFocus();
        resetStylePropertiesToDefaultValuesButtonFromAppearanceTab = this.getSectionButton(ResetStylePropertiesToDefaultValuesAction.ACTION_NAME);
        return resetStylePropertiesToDefaultValuesButtonFromAppearanceTab;
    }

    protected SWTBotButton getSectionButton(String tooltip) {
        SWTBot propertiesBot = this.bot.viewByTitle("Properties").bot();
        this.bot.viewByTitle("Properties").setFocus();
        SWTBotSiriusHelper.selectPropertyTabItem("Appearance", propertiesBot);
        SWTBotButton button = propertiesBot.buttonWithTooltipInGroup(tooltip, "Fonts and Colors:");
        TestCase.assertNotNull((Object)button);
        TestCase.assertEquals((String)tooltip, (String)button.getToolTipText());
        return button;
    }

    private SWTBotToolbarButton getTabbarButton(String tooltip) {
        this.editor.show();
        SWTBot tabbarBot = this.editor.bot();
        SWTBotToolbarButton button = tabbarBot.toolbarButtonWithTooltip(tooltip);
        TestCase.assertNotNull((String)("No button found with tooltip \"" + tooltip + "\""), (Object)button);
        return button;
    }

    private void initLoggers() {
        this.logListener = (status, plugin) -> {
            switch (status.getSeverity()) {
                case 4: {
                    if ("org.eclipse.ui.views.properties.tabbed".equals(status.getPlugin()) || status.getMessage() == null || status.getMessage().startsWith("Contributor org.eclipse.ui.navigator.ProjectExplorer cannot be created., exception: org.eclipse.core.runtime.CoreException: Plug-in \"org.eclipse.ui.navigator.resources\" was unable to instantiate class \"org.eclipse.ui.internal.navigator.resources.workbench.TabbedPropertySheetTitleProvider\".")) break;
                    this.errorOccurs(status, plugin);
                    break;
                }
                case 2: {
                    this.warningOccurs(status, plugin);
                }
            }
        };
        Platform.addLogListener((ILogListener)this.logListener);
        this.exceptionHandler = new Thread.UncaughtExceptionHandler(){
            private final String sourcePlugin = "Uncaught exception";

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                Status status = new Status(4, "Uncaught exception", "Uncaught exception", e);
                AbstractSiriusSwtBotGefTestCase.this.errorOccurs((IStatus)status, "Uncaught exception");
            }
        };
        Thread.setDefaultUncaughtExceptionHandler(this.exceptionHandler);
        this.setErrorCatchActive(true);
        this.setWarningCatchActive(false);
    }

    private void disposeLoggers() {
        if (this.logListener != null) {
            Platform.removeLogListener((ILogListener)this.logListener);
        }
    }

    protected synchronized boolean doesAnErrorOccurs() {
        return this.errors != null && !this.errors.isEmpty();
    }

    protected synchronized boolean doesAWarningOccurs() {
        return this.warnings != null && !this.warnings.isEmpty();
    }

    protected synchronized boolean isErrorCatchActive() {
        return this.errorCatchActive;
    }

    protected synchronized boolean isWarningCatchActive() {
        return this.warningCatchActive;
    }

    private synchronized void errorOccurs(IStatus status, String sourcePlugin) {
        if (this.errorCatchActive) {
            boolean ignoreMessage = false;
            if ("org.eclipse.core.runtime".equals(sourcePlugin) && status != null) {
                if ("Could not acquire INavigatorContentService: Project Explorer not found.".equals(status.getMessage())) {
                    ignoreMessage = true;
                } else if (status.getMessage() != null && status.getMessage().startsWith("Resource '/.org.eclipse.jdt.core.external.folders/.link") && status.getMessage().endsWith("' already exists.")) {
                    ignoreMessage = true;
                }
            }
            if (!ignoreMessage) {
                this.errors.put((Object)sourcePlugin, (Object)status);
            }
        }
    }

    private synchronized void warningOccurs(IStatus status, String sourcePlugin) {
        if (this.warningCatchActive) {
            this.warnings.put((Object)sourcePlugin, (Object)status);
        }
    }

    protected synchronized void setErrorCatchActive(boolean errorCatchActive) {
        this.errorCatchActive = errorCatchActive;
    }

    protected synchronized void setWarningCatchActive(boolean warningCatchActive) {
        this.warningCatchActive = warningCatchActive;
    }

    protected void startToListenErrorLog(boolean activateWarningCatch, boolean activateErrorCatch) {
        this.setWarningCatchActive(activateWarningCatch);
        if (activateWarningCatch) {
            this.warnings.clear();
        }
        this.setErrorCatchActive(activateErrorCatch);
        if (activateErrorCatch) {
            this.errors.clear();
        }
    }

    private void checkLogs() {
        if (!TestsUtil.shouldSkipUnreliableTests()) {
            if (this.doesAnErrorOccurs()) {
                Assert.fail((String)this.getErrorLoggersMessage());
            }
            if (this.doesAWarningOccurs()) {
                Assert.fail((String)this.getWarningLoggersMessage());
            }
        }
    }

    protected synchronized String getErrorLoggersMessage() {
        StringBuilder log1 = new StringBuilder();
        String br = "\n";
        String testName = ((Object)((Object)this)).getClass().getName();
        log1.append("Error(s) raised during test : " + testName).append(br);
        for (Map.Entry entry : this.errors.asMap().entrySet()) {
            String reporter = (String)entry.getKey();
            log1.append(". Log Plugin : " + reporter).append(br);
            for (IStatus status : (Collection)entry.getValue()) {
                log1.append("  . " + this.getSeverity(status) + " from plugin:" + status.getPlugin() + ", message: " + status.getMessage() + ", exception: " + status.getException()).append(br);
                this.appendStackTrace(log1, br, status);
            }
            log1.append(br);
        }
        return log1.toString();
    }

    protected synchronized String getWarningLoggersMessage() {
        StringBuilder log1 = new StringBuilder();
        String br = "\n";
        String testName = ((Object)((Object)this)).getClass().getName();
        log1.append("Warning(s) raised during test : " + testName).append(br);
        for (Map.Entry entry : this.warnings.asMap().entrySet()) {
            String reporter = (String)entry.getKey();
            log1.append(". Log Plugin : " + reporter).append(br);
            for (IStatus status : (Collection)entry.getValue()) {
                log1.append("  . " + this.getSeverity(status) + " from plugin:" + status.getPlugin() + ", message: " + status.getMessage() + ", exception: " + status.getException()).append(br);
                this.appendStackTrace(log1, br, status);
            }
            log1.append(br);
        }
        return log1.toString();
    }

    private void appendStackTrace(StringBuilder log1, String br, IStatus status) {
        PrintWriter pw = null;
        String stacktrace = null;
        if (status.getException() != null) {
            try {
                StringWriter sw = new StringWriter();
                pw = new PrintWriter(sw);
                status.getException().printStackTrace(pw);
                stacktrace = sw.toString();
            }
            finally {
                if (pw != null) {
                    pw.close();
                }
                if (stacktrace == null) {
                    stacktrace = status.getException().toString();
                }
                log1.append("   . Stack trace: " + stacktrace).append(br);
            }
        }
    }

    private String getSeverity(IStatus status) {
        String severity;
        switch (status.getSeverity()) {
            case 0: {
                severity = "Ok";
                break;
            }
            case 1: {
                severity = "Info";
                break;
            }
            case 2: {
                severity = "Warning";
                break;
            }
            case 8: {
                severity = "Cancel";
                break;
            }
            case 4: {
                severity = "Error";
                break;
            }
            default: {
                severity = "Unspecified";
            }
        }
        return severity;
    }

    private void failureTearDown() throws Exception {
        CrossReferenceAdapterDetector crossRefDetector = new CrossReferenceAdapterDetector();
        try {
            SWTBotUtils.waitAllUiEvents();
            if (this.bot != null) {
                SWTBotShell[] foundShells;
                Shell[] shells = this.bot.getFinder().getShells();
                ArrayList<SWTBotShell> result = new ArrayList<SWTBotShell>();
                Shell[] shellArray = shells;
                int n = shells.length;
                int n2 = 0;
                while (n2 < n) {
                    Shell shell = shellArray[n2];
                    if (!shell.isDisposed()) {
                        result.add(new SWTBotShell(shell));
                    }
                    ++n2;
                }
                HashSet<Shell> workbenchWindowsWidgets = new HashSet<Shell>();
                IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
                int n3 = iWorkbenchWindowArray.length;
                n = 0;
                while (n < n3) {
                    IWorkbenchWindow w = iWorkbenchWindowArray[n];
                    workbenchWindowsWidgets.add(w.getShell());
                    ++n;
                }
                SWTBotShell[] sWTBotShellArray = foundShells = result.toArray(new SWTBotShell[0]);
                int n4 = foundShells.length;
                n3 = 0;
                while (n3 < n4) {
                    SWTBotShell swtBotShell = sWTBotShellArray[n3];
                    if (!workbenchWindowsWidgets.contains(swtBotShell.widget)) {
                        if (swtBotShell.isOpen()) {
                            swtBotShell.close();
                        } else {
                            String shellText = swtBotShell.getText();
                            if (!StringUtil.isEmpty((String)shellText) && SHELL_TO_CLOSE_AT_TEAR_DOWN_TEXTS.contains(shellText)) {
                                System.err.println("The shell \"" + shellText + "\" is closed but not disposed. Something is potentially not correctly clean in this test. A dispose of this shell is called on tearDown.");
                                UIThreadRunnable.syncExec(() -> ((Shell)sWTBotShell.widget).dispose());
                            }
                        }
                    }
                    ++n3;
                }
            }
            SWTBotUtils.waitAllUiEvents();
            this.closeAllEditors();
            SWTBotUtils.waitAllUiEvents();
            crossRefDetector.checkNoCrossReferenceAdapter();
            this.closeAllSessions(false);
            SWTBotUtils.waitAllUiEvents();
            Job.getJobManager().join((Object)"org.eclipse.sirius.common.ResourceSyncClientNotification", (IProgressMonitor)new NullProgressMonitor());
            this.bot.closeAllEditors();
            this.designerProject = null;
            SWTBotUtils.waitAllUiEvents();
            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = iProjectArray.length;
            int n5 = 0;
            while (n5 < n) {
                IProject project = iProjectArray[n5];
                EclipseTestsSupportHelper.INSTANCE.deleteProject(project.getName());
                ++n5;
            }
            this.disposeLoggers();
        }
        catch (Throwable throwable) {
            this.resetPreferences();
            SWTBotUtils.waitAllUiEvents();
            UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

                public void run() {
                    IPreferenceStore preferenceStore = DiagramUIPlugin.getPlugin().getPreferenceStore();
                    preferenceStore.setValue("Global.enableAnimatedZoom", AbstractSiriusSwtBotGefTestCase.this.defaultEnableAnimatedZoom);
                    preferenceStore.setValue("Global.enableAnimatedLayout", AbstractSiriusSwtBotGefTestCase.this.defaultEnableAnimatedLayout);
                    preferenceStore.setValue(SiriusDiagramUiPreferencesKeys.PREF_PROMPT_PASTE_MODE.name(), AbstractSiriusSwtBotGefTestCase.this.defaultPromptPasteMode);
                }
            });
            this.setErrorCatchActive(false);
            this.setWarningCatchActive(false);
            crossRefDetector.assertNoCrossReferenceAdapterFound();
            this.checkLogs();
            throw throwable;
        }
        this.resetPreferences();
        SWTBotUtils.waitAllUiEvents();
        UIThreadRunnable.syncExec((VoidResult)new /* invalid duplicate definition of identical inner class */);
        this.setErrorCatchActive(false);
        this.setWarningCatchActive(false);
        crossRefDetector.assertNoCrossReferenceAdapterFound();
        this.checkLogs();
    }

    private void resetPreferences() {
        IEclipsePreferences diagamCorePreferences = InstanceScope.INSTANCE.getNode("org.eclipse.sirius.diagram");
        for (String key : this.oldValueDiagramPreferences.keySet()) {
            this.resetDiagramPreference(key, diagamCorePreferences);
        }
        IPreferenceStore diagramUIPreferences = DiagramUIPlugin.getPlugin().getPreferenceStore();
        for (String key : this.oldValueDiagramUIPreferences.keySet()) {
            this.resetDiagramUIPreference(key, diagramUIPreferences);
        }
        boolean currentUiPreference = diagramUIPreferences.getBoolean(SiriusDiagramUiPreferencesKeys.PREF_OLD_UI.name());
        if (currentUiPreference) {
            System.out.println("This test has not reset the oldUiPreference : " + ((Object)((Object)this)).getClass().getName() + " (it is currently true).");
        }
        IPreferenceStore platformUIPrefs = PlatformUI.getPreferenceStore();
        for (Map.Entry<String, Object> pref : this.oldPlatformUIPreferences.entrySet()) {
            platformUIPrefs.setValue(pref.getKey(), ((Boolean)pref.getValue()).booleanValue());
        }
        IPreferenceStore viewpointUIPrefs = SiriusEditPlugin.getPlugin().getPreferenceStore();
        for (Map.Entry<String, Object> pref : this.oldValueSiriusUIPreferences.entrySet()) {
            viewpointUIPrefs.setValue(pref.getKey(), ((Boolean)pref.getValue()).booleanValue());
        }
        IEclipsePreferences corePreferences = InstanceScope.INSTANCE.getNode("org.eclipse.sirius");
        for (Map.Entry<String, Object> pref : this.oldValueSiriusPreferences.entrySet()) {
            corePreferences.putBoolean(pref.getKey(), ((Boolean)pref.getValue()).booleanValue());
        }
        IEclipsePreferences commonPrefs = InstanceScope.INSTANCE.getNode("org.eclipse.sirius.common.ui");
        for (Map.Entry<String, Object> pref : this.oldValueCommonPreferences.entrySet()) {
            commonPrefs.putBoolean(pref.getKey(), ((Boolean)pref.getValue()).booleanValue());
        }
    }

    public SWTBotVSMEditor openViewpointSpecificationModel(String viewpointSpecificationModel) {
        SWTBotCommonHelper.openEditor(this.getProjectName(), viewpointSpecificationModel);
        SWTBotVSMEditor odesignEditor = SWTBotVSMHelper.getVSMEditorContainingName(viewpointSpecificationModel);
        odesignEditor.setFocus();
        return odesignEditor;
    }

    protected void copyFileToTestProject(String pluginId, String dataUnitDir, String ... fileNames) {
        String[] stringArray = fileNames;
        int n = fileNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            EclipseTestsSupportHelper.INSTANCE.copyFile(pluginId, String.valueOf(dataUnitDir) + fileName, String.valueOf(this.getProjectName()) + "/" + fileName);
            ++n2;
        }
    }

    public SWTBotGefEditPart findTextEditPart(String label) {
        return this.findTextEditPart(this.editor.rootEditPart(), label);
    }

    public SWTBotGefEditPart findTextEditPart(SWTBotSiriusDiagramEditor designerEditor, String label) {
        return this.findTextEditPart(designerEditor.rootEditPart(), label);
    }

    public SWTBotGefEditPart findTextEditPart(SWTBotGefEditPart parent, String label) {
        SWTBotGefEditPart result = null;
        if (parent.part() instanceof TextEditPart) {
            TextEditPart textEditPart = (TextEditPart)parent.part();
            DescriptionCompartmentEditPart descriptionCompartmentEditPart = (DescriptionCompartmentEditPart)Iterables.getOnlyElement((Iterable)Iterables.filter((Iterable)textEditPart.getChildren(), DescriptionCompartmentEditPart.class));
            if (descriptionCompartmentEditPart.getFigure() instanceof WrappingLabel && label.equals(((WrappingLabel)descriptionCompartmentEditPart.getFigure()).getText())) {
                result = parent;
            }
        } else {
            for (SWTBotGefEditPart child : parent.children()) {
                SWTBotGefEditPart childrenResult = this.findTextEditPart(child, label);
                if (childrenResult == null) continue;
                return childrenResult;
            }
        }
        return result;
    }

    protected String changeDefaultFontName(String fontName) {
        IPreferenceStore preferenceStore = (IPreferenceStore)DiagramUIPlugin.DIAGRAM_PREFERENCES_HINT.getPreferenceStore();
        FontData fontData = PreferenceConverter.getFontData((IPreferenceStore)preferenceStore, (String)"Appearance.defaultFont");
        String oldName = fontData.getName();
        fontData.setName(fontName);
        PreferenceConverter.setDefault((IPreferenceStore)preferenceStore, (String)"Appearance.defaultFont", (FontData)fontData);
        return oldName;
    }

    protected Color getFigureBackgroundColor(AbstractBorderedShapeEditPart editPart, Class<? extends Figure> figureClass) {
        IFigure figure = editPart.getFigure();
        if (figureClass.isInstance(figure)) {
            return figure.getBackgroundColor();
        }
        return this.getFigureBackgroundColor(figure, figureClass);
    }

    protected Color getFigureBackgroundColor(IFigure parentFigure, Class<? extends Figure> figureClass) {
        Iterable filter = Iterables.filter((Iterable)parentFigure.getChildren(), figureClass);
        if (Iterables.size((Iterable)filter) == 1) {
            return ((Figure)Iterables.getOnlyElement((Iterable)filter)).getBackgroundColor();
        }
        Color backgroundColor = null;
        for (IFigure childFigure : Iterables.filter((Iterable)parentFigure.getChildren(), IFigure.class)) {
            backgroundColor = this.getFigureBackgroundColor(childFigure, figureClass);
            if (backgroundColor != null) break;
        }
        return backgroundColor;
    }

    protected void tearDown() throws Exception {
        this.failureTearDown();
        new TestCaseCleaner((TestCase)this).clearAllFields();
        super.tearDown();
        this.setErrorCatchActive(false);
        this.setWarningCatchActive(false);
        ResourcesPlugin.getWorkspace().save(true, null);
    }

    public void runBare() throws Throwable {
        Throwable exception = null;
        try {
            super.runBare();
        }
        catch (Throwable running) {
            exception = running;
            this.captureScreenshot();
        }
        if (exception != null) {
            throw exception;
        }
    }

    private void captureScreenshot() {
        try {
            int maximumScreenshots = SWTBotPreferences.MAX_ERROR_SCREENSHOT_COUNT;
            String fileName = String.valueOf(SWTBotPreferences.SCREENSHOTS_DIR) + "/screenshot-" + ClassUtils.simpleClassName(((Object)((Object)this)).getClass()) + POINT + this.getName() + POINT + SWTBotPreferences.SCREENSHOT_FORMAT.toLowerCase();
            if (++screenshotCounter <= maximumScreenshots) {
                new File(SWTBotPreferences.SCREENSHOTS_DIR).mkdirs();
                SWTUtils.captureScreenshot((String)fileName);
            } else if (log != null) {
                log.info((Object)("No screenshot captured for '" + ClassUtils.simpleClassName(((Object)((Object)this)).getClass()) + POINT + this.getName() + "' because maximum number of screenshots reached: " + maximumScreenshots));
            } else {
                System.err.println("ERR: No screenshot captured for '" + ClassUtils.simpleClassName(((Object)((Object)this)).getClass()) + POINT + this.getName() + "' because maximum number of screenshots reached: " + maximumScreenshots);
            }
        }
        catch (Exception e) {
            if (log != null) {
                log.warn((Object)"Could not capture screenshot", (Throwable)e);
            }
            System.err.println("ERR: Could not capture screenshot:");
            e.printStackTrace();
        }
    }

    protected void closeOutline() {
        PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
            IViewReference[] views;
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IViewReference[] iViewReferenceArray = views = page.getViewReferences();
            int n = views.length;
            int n2 = 0;
            while (n2 < n) {
                IViewReference view = iViewReferenceArray[n2];
                if (Objects.equal((Object)"org.eclipse.ui.views.ContentOutline", (Object)view.getId())) {
                    view.getPage().hideView(view);
                }
                ++n2;
            }
        });
    }
}

