/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.xtext.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.sirius.common.tools.api.resource.ResourceSetFactory;
import org.eclipse.sirius.common.xtext.internal.ResourceSetClasspathConfigurator;
import org.eclipse.xtext.resource.XtextResourceSet;

public class XtextResourceSetFactory
extends ResourceSetFactory {
    public ResourceSet createResourceSet(URI resourceURI) {
        XtextResourceSet set = new XtextResourceSet();
        IProject prj = this.findProjectFromURI(resourceURI);
        if (prj != null) {
            try {
                new ResourceSetClasspathConfigurator().configure(set, prj);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {}
        }
        set.getLoadOptions().put("org.eclipse.xtext.scoping.LIVE_SCOPE", Boolean.TRUE);
        return set;
    }

    private IProject findProjectFromURI(URI resourceURI) {
        if (resourceURI != null && resourceURI.isPlatformResource() && resourceURI.segmentCount() > 0) {
            String projectName = resourceURI.segment(1);
            return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        }
        return null;
    }
}

