/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.format.data.extension;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.ui.tools.api.format.IFormatDataManagerProvider;
import org.eclipse.sirius.diagram.ui.tools.api.format.SiriusFormatDataManager;
import org.eclipse.sirius.diagram.ui.tools.api.format.SiriusFormatDataManagerForSemanticElementsFactory;
import org.eclipse.sirius.diagram.ui.tools.internal.format.data.extension.FormatDataManagerDescriptor;

public final class FormatDataManagerRegistry {
    private static final Map<FormatDataManagerDescriptor, SiriusFormatDataManager> EXTENSIONS = new LinkedHashMap<FormatDataManagerDescriptor, SiriusFormatDataManager>();

    private FormatDataManagerRegistry() {
    }

    public static void addExtension(FormatDataManagerDescriptor extension) {
        EXTENSIONS.put(extension, null);
    }

    public static void clearRegistry() {
        EXTENSIONS.clear();
    }

    public static Collection<FormatDataManagerDescriptor> getRegisteredExtensions() {
        return new ArrayList<FormatDataManagerDescriptor>(EXTENSIONS.keySet());
    }

    public static void removeExtension(String extensionClassName) {
        for (FormatDataManagerDescriptor extension : FormatDataManagerRegistry.getRegisteredExtensions()) {
            if (!extension.getExtensionClassName().equals(extensionClassName)) continue;
            EXTENSIONS.remove(extension);
        }
    }

    public static FormatDataManagerDescriptor getRegisteredExtension(String id) {
        for (FormatDataManagerDescriptor desc : EXTENSIONS.keySet()) {
            if (StringUtil.isEmpty((String)desc.getId()) || !desc.getId().equals(id)) continue;
            return desc;
        }
        return null;
    }

    public static List<SiriusFormatDataManager> getSiriusFormatDataManagers(DDiagram diagram) {
        ArrayList<SiriusFormatDataManager> applicableManagers = new ArrayList<SiriusFormatDataManager>();
        for (FormatDataManagerDescriptor descriptor : FormatDataManagerRegistry.getRegisteredExtensions()) {
            IFormatDataManagerProvider provider = descriptor.getFormatDataManagerProvider();
            if (provider == null || !provider.provides(diagram)) continue;
            SiriusFormatDataManager formatDataManager = EXTENSIONS.get(descriptor);
            if (formatDataManager == null) {
                formatDataManager = provider.getFormatDataManager();
                EXTENSIONS.put(descriptor, formatDataManager);
            }
            applicableManagers.add(formatDataManager);
        }
        applicableManagers.add(SiriusFormatDataManagerForSemanticElementsFactory.getInstance().getSiriusFormatDataManager());
        return applicableManagers;
    }

    public static List<SiriusFormatDataManager> getAllSiriusFormatDataManagers() {
        ArrayList<SiriusFormatDataManager> applicableManagers = new ArrayList<SiriusFormatDataManager>();
        for (FormatDataManagerDescriptor descriptor : FormatDataManagerRegistry.getRegisteredExtensions()) {
            IFormatDataManagerProvider provider = descriptor.getFormatDataManagerProvider();
            if (provider == null) continue;
            SiriusFormatDataManager formatDataManager = EXTENSIONS.get(descriptor);
            if (formatDataManager == null) {
                formatDataManager = provider.getFormatDataManager();
                EXTENSIONS.put(descriptor, formatDataManager);
            }
            applicableManagers.add(formatDataManager);
        }
        applicableManagers.add(SiriusFormatDataManagerForSemanticElementsFactory.getInstance().getSiriusFormatDataManager());
        return applicableManagers;
    }
}

