/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.tools.internal.presentation;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.sirius.ui.business.api.template.RepresentationTemplateEditManager;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.RepresentationTemplate;

public class RepresentationTemplateUpdateTrigger
extends EContentAdapter {
    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        RepresentationTemplate template = this.lookForParentTemplateInChanges(notification);
        if (template != null) {
            RepresentationTemplateEditManager.INSTANCE.update(template);
        }
    }

    private RepresentationTemplate lookForParentTemplateInChanges(Notification msg) {
        RepresentationTemplate found = null;
        if (!msg.isTouch() && msg.getNotifier() instanceof EObject) {
            EObject current = (EObject)msg.getNotifier();
            if (this.elementIsATemplateAndChangeIsNotAboutComputedFeatures(msg, current)) {
                found = (RepresentationTemplate)current;
            }
            while (current != null && found == null) {
                if (current.eContainer() instanceof RepresentationTemplate && !this.objectIsContainedInComputedFeature(current)) {
                    found = (RepresentationTemplate)current.eContainer();
                }
                current = current.eContainer();
            }
        }
        return found;
    }

    private boolean objectIsContainedInComputedFeature(EObject current) {
        return current.eContainingFeature() == DescriptionPackage.eINSTANCE.getRepresentationTemplate_OwnedRepresentations();
    }

    private boolean elementIsATemplateAndChangeIsNotAboutComputedFeatures(Notification msg, EObject current) {
        return current instanceof RepresentationTemplate && msg.getFeature() != DescriptionPackage.eINSTANCE.getRepresentationTemplate_OwnedRepresentations();
    }
}

