/**
 * Copyright (c) 2007, 2013 THALES GLOBAL SERVICES.
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *    Obeo - initial API and implementation
 *
 */
package org.eclipse.sirius.diagram.description.tool.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.tool.DiagramCreationDescription;
import org.eclipse.sirius.diagram.description.tool.ToolPackage;
import org.eclipse.sirius.viewpoint.description.tool.impl.RepresentationCreationDescriptionImpl;

/**
 * <!-- begin-user-doc --> An implementation of the model object ' <em><b>Diagram Creation Description</b></em>'. <!--
 * end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 * <li>{@link org.eclipse.sirius.diagram.description.tool.impl.DiagramCreationDescriptionImpl#getDiagramDescription
 * <em>Diagram Description</em>}</li>
 * </ul>
 *
 * @generated
 */
public class DiagramCreationDescriptionImpl extends RepresentationCreationDescriptionImpl implements DiagramCreationDescription {
    /**
     * The cached value of the '{@link #getDiagramDescription() <em>Diagram Description</em>}' reference. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @see #getDiagramDescription()
     * @generated
     * @ordered
     */
    protected DiagramDescription diagramDescription;

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected DiagramCreationDescriptionImpl() {
        super();
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    protected EClass eStaticClass() {
        return ToolPackage.Literals.DIAGRAM_CREATION_DESCRIPTION;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public DiagramDescription getDiagramDescription() {
        if (diagramDescription != null && diagramDescription.eIsProxy()) {
            InternalEObject oldDiagramDescription = (InternalEObject) diagramDescription;
            diagramDescription = (DiagramDescription) eResolveProxy(oldDiagramDescription);
            if (diagramDescription != oldDiagramDescription) {
                if (eNotificationRequired()) {
                    eNotify(new ENotificationImpl(this, Notification.RESOLVE, ToolPackage.DIAGRAM_CREATION_DESCRIPTION__DIAGRAM_DESCRIPTION, oldDiagramDescription, diagramDescription));
                }
            }
        }
        return diagramDescription;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    public DiagramDescription basicGetDiagramDescription() {
        return diagramDescription;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void setDiagramDescription(DiagramDescription newDiagramDescription) {
        DiagramDescription oldDiagramDescription = diagramDescription;
        diagramDescription = newDiagramDescription;
        if (eNotificationRequired()) {
            eNotify(new ENotificationImpl(this, Notification.SET, ToolPackage.DIAGRAM_CREATION_DESCRIPTION__DIAGRAM_DESCRIPTION, oldDiagramDescription, diagramDescription));
        }
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
        case ToolPackage.DIAGRAM_CREATION_DESCRIPTION__DIAGRAM_DESCRIPTION:
            if (resolve) {
                return getDiagramDescription();
            }
            return basicGetDiagramDescription();
        }
        return super.eGet(featureID, resolve, coreType);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
        case ToolPackage.DIAGRAM_CREATION_DESCRIPTION__DIAGRAM_DESCRIPTION:
            setDiagramDescription((DiagramDescription) newValue);
            return;
        }
        super.eSet(featureID, newValue);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
        case ToolPackage.DIAGRAM_CREATION_DESCRIPTION__DIAGRAM_DESCRIPTION:
            setDiagramDescription((DiagramDescription) null);
            return;
        }
        super.eUnset(featureID);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
        case ToolPackage.DIAGRAM_CREATION_DESCRIPTION__DIAGRAM_DESCRIPTION:
            return diagramDescription != null;
        }
        return super.eIsSet(featureID);
    }

} // DiagramCreationDescriptionImpl
