/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate.loops.ordering;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ArrayTable;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.intermediate.loops.SelfHyperLoop;
import org.eclipse.elk.alg.layered.intermediate.loops.SelfLoopHolder;
import org.eclipse.elk.alg.layered.intermediate.loops.SelfLoopPort;
import org.eclipse.elk.alg.layered.intermediate.loops.SelfLoopType;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.options.SelfLoopOrderingStrategy;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class PortRestorer {
    private ListMultimap<SelfLoopType, SelfHyperLoop> slLoopsByType;
    private Table<PortSide, PortSideArea, List<SelfLoopPort>> targetAreas;
    private static final PortSide[] NES = new PortSide[]{PortSide.NORTH, PortSide.EAST, PortSide.SOUTH};
    private static final PortSide[] ESW = new PortSide[]{PortSide.EAST, PortSide.SOUTH, PortSide.WEST};
    private static final PortSide[] SWN = new PortSide[]{PortSide.SOUTH, PortSide.WEST, PortSide.NORTH};
    private static final PortSide[] WNE = new PortSide[]{PortSide.WEST, PortSide.NORTH, PortSide.EAST};

    public void restorePorts(SelfLoopHolder slHolder, IElkProgressMonitor monitor) {
        this.initTargetAreas();
        this.slLoopsByType = this.gatherSelfLoopsByType(slHolder);
        this.processOneSideLoops((SelfLoopOrderingStrategy)((Object)slHolder.getLNode().getProperty(LayeredOptions.EDGE_ROUTING_SELF_LOOP_ORDERING)));
        this.processTwoSideCornerLoops();
        this.processThreeSideLoops();
        this.processFourSideLoops();
        this.processTwoSideOpposingLoops();
        this.restorePorts(slHolder);
        this.targetAreas.values().stream().flatMap(slPortList -> slPortList.stream()).forEach(slPort -> slPort.setHidden(false));
        slHolder.setPortsHidden(false);
        this.slLoopsByType = null;
    }

    private void initTargetAreas() {
        this.targetAreas = ArrayTable.create(Arrays.asList(PortSide.values()), Arrays.asList(PortSideArea.values()));
        PortSide[] portSideArray = PortSide.values();
        int n = portSideArray.length;
        int n2 = 0;
        while (n2 < n) {
            PortSide side = portSideArray[n2];
            PortSideArea[] portSideAreaArray = PortSideArea.values();
            int n3 = portSideAreaArray.length;
            int n4 = 0;
            while (n4 < n3) {
                PortSideArea area = portSideAreaArray[n4];
                this.targetAreas.put((Object)side, (Object)area, new ArrayList());
                ++n4;
            }
            ++n2;
        }
    }

    private ListMultimap<SelfLoopType, SelfHyperLoop> gatherSelfLoopsByType(SelfLoopHolder slHolder) {
        ArrayListMultimap loops = ArrayListMultimap.create();
        slHolder.getSLHyperLoops().stream().forEach(arg_0 -> PortRestorer.lambda$2((ListMultimap)loops, arg_0));
        return loops;
    }

    private void processOneSideLoops(SelfLoopOrderingStrategy ordering) {
        block4: for (SelfHyperLoop slLoop : this.slLoopsByType.get((Object)SelfLoopType.ONE_SIDE)) {
            PortSide side = slLoop.getSLPorts().get(0).getLPort().getSide();
            ArrayList<SelfLoopPort> sortedPorts = new ArrayList<SelfLoopPort>(slLoop.getSLPorts());
            sortedPorts.sort((slPort1, slPort2) -> Integer.compare(slPort1.getSLNetFlow(), slPort2.getSLNetFlow()));
            switch (ordering) {
                case SEQUENCED: {
                    this.addToTargetArea(sortedPorts, side, PortSideArea.MIDDLE, AddMode.APPEND);
                    break;
                }
                case STACKED: {
                    int splitIndex = this.computePortListSplitIndex(sortedPorts);
                    this.addToTargetArea(sortedPorts.subList(0, splitIndex), side, PortSideArea.MIDDLE, AddMode.PREPEND);
                    this.addToTargetArea(sortedPorts.subList(splitIndex, sortedPorts.size()), side, PortSideArea.MIDDLE, AddMode.APPEND);
                    break;
                }
                default: {
                    assert (false);
                    continue block4;
                }
            }
        }
    }

    private int computePortListSplitIndex(List<SelfLoopPort> sortedPorts) {
        int positiveNetFlowIndex = 0;
        while (positiveNetFlowIndex < sortedPorts.size()) {
            if (sortedPorts.get(positiveNetFlowIndex).getSLNetFlow() > 0) break;
            ++positiveNetFlowIndex;
        }
        if (positiveNetFlowIndex > 0 && positiveNetFlowIndex < sortedPorts.size() - 1) {
            return positiveNetFlowIndex;
        }
        int nonNegativeNetFlowIndex = 0;
        while (nonNegativeNetFlowIndex < sortedPorts.size()) {
            if (sortedPorts.get(nonNegativeNetFlowIndex).getSLNetFlow() > 0) break;
            ++nonNegativeNetFlowIndex;
        }
        if (nonNegativeNetFlowIndex > 0 && positiveNetFlowIndex < sortedPorts.size() - 1) {
            return nonNegativeNetFlowIndex;
        }
        return sortedPorts.size() / 2;
    }

    private void processTwoSideCornerLoops() {
        for (SelfHyperLoop slLoop : this.slLoopsByType.get((Object)SelfLoopType.TWO_SIDES_CORNER)) {
            PortSide[] sides = PortRestorer.sortedTwoSideLoopPortSides(slLoop);
            this.addToTargetArea(slLoop, sides[0], PortSideArea.END, AddMode.PREPEND);
            this.addToTargetArea(slLoop, sides[1], PortSideArea.START, AddMode.APPEND);
        }
    }

    private void processTwoSideOpposingLoops() {
        for (SelfHyperLoop slLoop : this.slLoopsByType.get((Object)SelfLoopType.TWO_SIDES_OPPOSING)) {
            PortSide[] sides = PortRestorer.sortedTwoSideLoopPortSides(slLoop);
            this.addToTargetArea(slLoop, sides[0], PortSideArea.END, AddMode.PREPEND);
            this.addToTargetArea(slLoop, sides[1], PortSideArea.START, AddMode.APPEND);
        }
    }

    public static PortSide[] sortedTwoSideLoopPortSides(SelfHyperLoop slLoop) {
        Object[] sides = slLoop.getSLPortsBySide().keySet().toArray(new PortSide[2]);
        Arrays.sort(sides);
        assert (sides.length == 2);
        if (sides[0] == PortSide.NORTH && sides[1] == PortSide.WEST) {
            sides[0] = PortSide.WEST;
            sides[1] = PortSide.NORTH;
        }
        return sides;
    }

    private void processThreeSideLoops() {
        for (SelfHyperLoop slLoop : this.slLoopsByType.get((Object)SelfLoopType.THREE_SIDES)) {
            PortSide[] sides = this.determineLoopConstellation(slLoop);
            this.addToTargetArea(slLoop, sides[0], PortSideArea.END, AddMode.PREPEND);
            this.addToTargetArea(slLoop, sides[1], PortSideArea.MIDDLE, AddMode.APPEND);
            this.addToTargetArea(slLoop, sides[2], PortSideArea.START, AddMode.APPEND);
        }
    }

    private PortSide[] determineLoopConstellation(SelfHyperLoop slLoop) {
        Set portSides = slLoop.getSLPortsBySide().keySet();
        if (!portSides.contains(PortSide.NORTH)) {
            return ESW;
        }
        if (!portSides.contains(PortSide.EAST)) {
            return SWN;
        }
        if (!portSides.contains(PortSide.SOUTH)) {
            return WNE;
        }
        if (!portSides.contains(PortSide.WEST)) {
            return NES;
        }
        assert (false);
        return null;
    }

    private void processFourSideLoops() {
        for (SelfHyperLoop slLoop : this.slLoopsByType.get((Object)SelfLoopType.FOUR_SIDES)) {
            for (PortSide side : slLoop.getSLPortsBySide().keySet()) {
                this.addToTargetArea(slLoop, side, PortSideArea.MIDDLE, AddMode.APPEND);
            }
        }
    }

    private void addToTargetArea(SelfHyperLoop slLoop, PortSide portSide, PortSideArea area, AddMode addMode) {
        this.addToTargetArea(slLoop.getSLPortsBySide(portSide), portSide, area, addMode);
    }

    private void addToTargetArea(Collection<SelfLoopPort> slPorts, PortSide portSide, PortSideArea area, AddMode addMode) {
        List hiddenPorts = slPorts.stream().filter(slPort -> slPort.isHidden()).collect(Collectors.toList());
        List targetArea = (List)this.targetAreas.get((Object)portSide, (Object)area);
        if (addMode == AddMode.PREPEND) {
            targetArea.addAll(0, hiddenPorts);
        } else {
            targetArea.addAll(hiddenPorts);
        }
    }

    private void restorePorts(SelfLoopHolder slHolder) {
        LNode lNode = slHolder.getLNode();
        ArrayList<LPort> oldPortList = new ArrayList<LPort>(lNode.getPorts());
        int nextOldPortIndex = 0;
        List<LPort> newPortList = lNode.getPorts();
        newPortList.clear();
        this.addAll((List)this.targetAreas.get((Object)PortSide.NORTH, (Object)PortSideArea.START), lNode);
        nextOldPortIndex = this.addAllThat(oldPortList, nextOldPortIndex, lPort -> lPort.getSide() == PortSide.NORTH && this.isNorthSouthPortWithWestOrWestEastConnections((LPort)((Object)lPort)), newPortList);
        this.addAll((List)this.targetAreas.get((Object)PortSide.NORTH, (Object)PortSideArea.MIDDLE), lNode);
        nextOldPortIndex = this.addAllThat(oldPortList, nextOldPortIndex, lPort -> lPort.getSide() == PortSide.NORTH, newPortList);
        this.addAll((List)this.targetAreas.get((Object)PortSide.NORTH, (Object)PortSideArea.END), lNode);
        this.addAll((List)this.targetAreas.get((Object)PortSide.EAST, (Object)PortSideArea.START), lNode);
        this.addAll((List)this.targetAreas.get((Object)PortSide.EAST, (Object)PortSideArea.MIDDLE), lNode);
        nextOldPortIndex = this.addAllThat(oldPortList, nextOldPortIndex, lPort -> lPort.getSide() == PortSide.EAST, newPortList);
        this.addAll((List)this.targetAreas.get((Object)PortSide.EAST, (Object)PortSideArea.END), lNode);
        this.addAll((List)this.targetAreas.get((Object)PortSide.SOUTH, (Object)PortSideArea.START), lNode);
        nextOldPortIndex = this.addAllThat(oldPortList, nextOldPortIndex, lPort -> lPort.getSide() == PortSide.SOUTH && this.isNorthSouthPortWithEastConnections((LPort)((Object)lPort)), newPortList);
        this.addAll((List)this.targetAreas.get((Object)PortSide.SOUTH, (Object)PortSideArea.MIDDLE), lNode);
        nextOldPortIndex = this.addAllThat(oldPortList, nextOldPortIndex, lPort -> lPort.getSide() == PortSide.SOUTH, newPortList);
        this.addAll((List)this.targetAreas.get((Object)PortSide.SOUTH, (Object)PortSideArea.END), lNode);
        this.addAll((List)this.targetAreas.get((Object)PortSide.WEST, (Object)PortSideArea.START), lNode);
        nextOldPortIndex = this.addAllThat(oldPortList, nextOldPortIndex, lPort -> lPort.getSide() == PortSide.WEST, newPortList);
        this.addAll((List)this.targetAreas.get((Object)PortSide.WEST, (Object)PortSideArea.MIDDLE), lNode);
        this.addAll((List)this.targetAreas.get((Object)PortSide.WEST, (Object)PortSideArea.END), lNode);
        assert (newPortList.size() >= oldPortList.size() && newPortList.size() >= slHolder.getSLPortMap().size());
        assert (!slHolder.arePortsHidden() || newPortList.size() > oldPortList.size());
    }

    private void addAll(List<SelfLoopPort> slPorts, LNode lNode) {
        slPorts.stream().map(slPort -> slPort.getLPort()).forEach(lPort -> lPort.setNode(lNode));
    }

    private int addAllThat(List<LPort> lPorts, int fromIndex, Predicate<LPort> condition, List<LPort> target) {
        int i = fromIndex;
        while (i < lPorts.size()) {
            LPort lPort = lPorts.get(i);
            if (!condition.test(lPort)) {
                return i;
            }
            target.add(lPort);
            ++i;
        }
        return lPorts.size();
    }

    private boolean isNorthSouthPortWithWestOrWestEastConnections(LPort lPort) {
        Set<PortSide> connections = this.northSouthPortConnectionSides(lPort);
        boolean eastConnections = connections.contains(PortSide.EAST);
        boolean westConnections = connections.contains(PortSide.WEST);
        return westConnections || westConnections && eastConnections;
    }

    private boolean isNorthSouthPortWithEastConnections(LPort lPort) {
        Set<PortSide> connections = this.northSouthPortConnectionSides(lPort);
        return connections.contains(PortSide.EAST);
    }

    private Set<PortSide> northSouthPortConnectionSides(LPort lPort) {
        EnumSet<PortSide> connectionSides = EnumSet.noneOf(PortSide.class);
        LNode portDummy = (LNode)((Object)lPort.getProperty(InternalProperties.PORT_DUMMY));
        if (portDummy != null) {
            for (LPort dummyLPort : portDummy.getPorts()) {
                if (dummyLPort.getProperty(InternalProperties.ORIGIN) != lPort || !dummyLPort.getConnectedEdges().iterator().hasNext()) continue;
                connectionSides.add(dummyLPort.getSide());
            }
        }
        return connectionSides;
    }

    private static /* synthetic */ void lambda$2(ListMultimap listMultimap, SelfHyperLoop slLoop) {
        boolean bl = listMultimap.put((Object)slLoop.getSelfLoopType(), (Object)slLoop);
    }

    private static enum AddMode {
        PREPEND,
        APPEND;

    }

    private static enum PortSideArea {
        START,
        MIDDLE,
        END;

    }
}

