/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.editor.tools.internal.menu.refactoring.border;

import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.DescriptionPackage;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.editor.tools.internal.menu.refactoring.EdgeMappingRefactoringAction;
import org.eclipse.sirius.diagram.editor.tools.internal.menu.refactoring.border.BorderToContainedCommand;
import org.eclipse.sirius.diagram.editor.tools.internal.menu.refactoring.border.ContainedToBorderCommand;
import org.eclipse.sirius.editor.tools.api.menu.AbstractEObjectRefactoringAction;
import org.eclipse.ui.IEditorPart;

public class BorderRefactoringAction
extends AbstractEObjectRefactoringAction {
    private static final String TEXT_IF_DISABLE = "Move to Contained/Bordered Node";

    public BorderRefactoringAction(IEditorPart editor, ISelection selection) {
        super(editor, selection);
    }

    protected Command buildActionCommand(EditingDomain arg0, Collection<EObject> selection) {
        EObject elementToMove;
        Object result = UnexecutableCommand.INSTANCE;
        this.setSelectionValid(false);
        if (selection.size() == 1 && (elementToMove = selection.iterator().next()) instanceof AbstractNodeMapping) {
            this.setSelectionValid(true);
            this.setTextIfDisable(TEXT_IF_DISABLE);
            if (this.isInBorder(elementToMove) && this.mightHaveContainedNodes(elementToMove.eContainer())) {
                result = new BorderToContainedCommand(arg0.getResourceSet(), elementToMove);
            } else if (!this.isInBorder(elementToMove) && this.mightHaveBorderedNodes(elementToMove.eContainer())) {
                result = new ContainedToBorderCommand(arg0.getResourceSet(), elementToMove);
            }
        }
        return result;
    }

    private boolean mightHaveBorderedNodes(EObject container) {
        return container instanceof AbstractNodeMapping;
    }

    private boolean mightHaveContainedNodes(EObject container) {
        return container instanceof ContainerMapping;
    }

    private boolean isInBorder(EObject elementToMove) {
        return elementToMove.eContainingFeature() == DescriptionPackage.eINSTANCE.getAbstractNodeMapping_BorderedNodeMappings();
    }

    public static void forceNotification(NodeMapping elementToMove) {
        String name = elementToMove.getName();
        elementToMove.setName("_refactoring");
        elementToMove.setName(name);
        EdgeMappingRefactoringAction.refreshSelection((DiagramElementMapping)elementToMove);
    }
}

