/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.routers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.ITreeConnection;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.OrthogonalRouter;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.sirius.diagram.ui.tools.internal.routers.DBranchRouter;

public class DTreeRouter
extends BendpointConnectionRouter
implements OrthogonalRouter {
    private static final int DEFAULT_TRUNK_HEIGHT = 16;
    private final DBranchRouter branchRouter = new DBranchRouter(this);
    private final ArrayList connectionList = new ArrayList();
    private Dimension trunkVertex;
    private Orientation trunkOrientation;
    private boolean updatingPeers;

    public void invalidate(Connection conn) {
        if (conn.getSourceAnchor() == null || conn.getSourceAnchor().getOwner() == null || conn.getTargetAnchor() == null || conn.getTargetAnchor().getOwner() == null) {
            return;
        }
        ListIterator li = Lists.newArrayList((Iterable)this.connectionList).listIterator();
        while (li.hasNext()) {
            Connection connNext = (Connection)li.next();
            if (this.trunkVertexEqual(connNext, conn)) continue;
            this.updateConstraint(connNext);
        }
    }

    private boolean trunkVertexEqual(Connection connMaster, Connection connSlave) {
        PointList cmPts = connMaster.getPoints();
        PointList csPts = connSlave.getPoints();
        if (cmPts.size() > 2 && csPts.size() > 2) {
            return cmPts.getPoint(2).equals((Object)csPts.getPoint(2));
        }
        return false;
    }

    private Rectangle getTargetAnchorRelativeBounds(Connection conn) {
        Rectangle bounds = conn.getTargetAnchor().getOwner().getBounds().getCopy();
        conn.getTargetAnchor().getOwner().translateToAbsolute((Translatable)bounds);
        conn.translateToRelative((Translatable)bounds);
        return bounds;
    }

    private Rectangle getSourceAnchorRelativeBounds(Connection conn) {
        Rectangle bounds = conn.getSourceAnchor().getOwner().getBounds().getCopy();
        conn.getSourceAnchor().getOwner().translateToAbsolute((Translatable)bounds);
        conn.translateToRelative((Translatable)bounds);
        return bounds;
    }

    public Point getTrunkLocation(Connection conn) {
        Dimension vertex = this.getTrunkVertex();
        Point target = this.getTrunkOrientation().getEdge(this.getTargetAnchorRelativeBounds(conn));
        Point ptTrunkLoc = new Point(vertex.width, vertex.height);
        ptTrunkLoc = ptTrunkLoc.getTranslated(target);
        return ptTrunkLoc;
    }

    public void setTrunkLocation(Connection conn, Point ptTrunkLoc) {
        Point ptRelTrunkLoc = new Point(ptTrunkLoc);
        Rectangle targetAnchorBounds = this.getTargetAnchorRelativeBounds(conn);
        if (this.isTopDown(conn)) {
            if (ptTrunkLoc.y < targetAnchorBounds.getCenter().y) {
                this.setTrunkOrientation(Orientation.TOP);
            } else {
                this.setTrunkOrientation(Orientation.BOTTOM);
            }
        } else if (ptTrunkLoc.x < targetAnchorBounds.getCenter().x) {
            this.setTrunkOrientation(Orientation.LEFT);
        } else {
            this.setTrunkOrientation(Orientation.RIGHT);
        }
        Point target = this.getTrunkOrientation().getEdge(targetAnchorBounds);
        Dimension currentVertex = ptRelTrunkLoc.getDifference(target);
        this.setTrunkVertex(currentVertex);
    }

    protected void updateConstraint(Connection conn) {
        boolean update = conn != null && conn.getSourceAnchor() != null && conn.getTargetAnchor() != null;
        boolean bl = update = update && conn.getSourceAnchor().getOwner() != null && conn.getTargetAnchor().getOwner() != null;
        if (update) {
            if (this.isUpdatingPeers()) {
                return;
            }
            ArrayList<AbsoluteBendpoint> bendpoints = (ArrayList<AbsoluteBendpoint>)conn.getRoutingConstraint();
            if (bendpoints == null) {
                bendpoints = new ArrayList<AbsoluteBendpoint>(conn.getPoints().size());
            }
            Point sourceRefPoint = conn.getSourceAnchor().getReferencePoint();
            conn.translateToRelative((Translatable)sourceRefPoint);
            Point targetRefPoint = conn.getTargetAnchor().getReferencePoint();
            conn.translateToRelative((Translatable)targetRefPoint);
            Point ptTrunk = this.getTrunkLocation(conn);
            Point ptSource = this.getBranchRouter().getSourceLocation(conn, ptTrunk);
            bendpoints.clear();
            PointList pts = this.getBranchRouter().recreateBranch(conn, ptSource, ptTrunk);
            int i = 0;
            while (i < pts.size()) {
                AbsoluteBendpoint bp = new AbsoluteBendpoint(pts.getPoint(i));
                bendpoints.add(bp);
                ++i;
            }
            this.setUpdatingPeers(true);
            try {
                this.setConstraint(conn, bendpoints);
                conn.invalidate();
                conn.validate();
            }
            finally {
                this.setUpdatingPeers(false);
            }
        }
    }

    public PointList getPointsFromConstraint(Connection conn) {
        List bendpoints = (List)conn.getRoutingConstraint();
        if (bendpoints == null) {
            return new PointList();
        }
        PointList points = new PointList(bendpoints.size());
        int i = 0;
        while (i < bendpoints.size()) {
            Bendpoint bp = (Bendpoint)bendpoints.get(i);
            points.addPoint(bp.getLocation());
            ++i;
        }
        DTreeRouter.straightenPoints(points, MapModeUtil.getMapMode((IFigure)conn).DPtoLP(3));
        return points;
    }

    protected static void straightenPoints(PointList newLine, int tolerance) {
        int i = 0;
        while (i < newLine.size() - 1) {
            int yDelta;
            Point ptCurrent = newLine.getPoint(i);
            Point ptNext = newLine.getPoint(i + 1);
            int xDelta = Math.abs(ptNext.x - ptCurrent.x);
            if (xDelta < (yDelta = Math.abs(ptNext.y - ptCurrent.y))) {
                if (xDelta > tolerance) {
                    return;
                }
                if (i == newLine.size() - 2) {
                    ptCurrent.setX(ptNext.x);
                } else {
                    ptNext.setX(ptCurrent.x);
                }
            } else {
                if (yDelta > tolerance) {
                    return;
                }
                if (i == newLine.size() - 2) {
                    ptCurrent.setY(ptNext.y);
                } else {
                    ptNext.setY(ptCurrent.y);
                }
            }
            newLine.setPoint(ptNext, i + 1);
            ++i;
        }
    }

    protected DBranchRouter getBranchRouter() {
        return this.branchRouter;
    }

    public void remove(Connection conn) {
        if (conn.getSourceAnchor() == null || conn.getTargetAnchor() == null) {
            return;
        }
        int index = this.connectionList.indexOf(conn);
        this.connectionList.remove(conn);
        int i = index + 1;
        while (i < this.connectionList.size()) {
            ((Connection)this.connectionList.get(i)).revalidate();
            ++i;
        }
        this.getBranchRouter().remove(conn);
    }

    public boolean isTopDown(Connection conn) {
        if (conn instanceof ITreeConnection) {
            return ((ITreeConnection)conn).getOrientation().equals(ITreeConnection.Orientation.VERTICAL);
        }
        return true;
    }

    private void checkTrunkVertex(Connection conn) {
        if (this.getTrunkVertex() == null) {
            Rectangle sourceRect = this.getSourceAnchorRelativeBounds(conn);
            Rectangle targetRect = this.getTargetAnchorRelativeBounds(conn);
            Dimension defaultTrunk = new Dimension(0, 16);
            conn.translateToRelative((Translatable)defaultTrunk);
            if (this.isTopDown(conn)) {
                if (sourceRect.getCenter().y < targetRect.getCenter().y) {
                    this.setTrunkVertex(new Dimension(0, -defaultTrunk.height));
                    this.setTrunkOrientation(Orientation.TOP);
                } else {
                    this.setTrunkVertex(new Dimension(0, defaultTrunk.height));
                    this.setTrunkOrientation(Orientation.BOTTOM);
                }
            } else if (sourceRect.getCenter().x < targetRect.getCenter().x) {
                this.setTrunkVertex(new Dimension(-defaultTrunk.height, 0));
                this.setTrunkOrientation(Orientation.LEFT);
            } else {
                this.setTrunkVertex(new Dimension(defaultTrunk.height, 0));
                this.setTrunkOrientation(Orientation.RIGHT);
            }
        }
    }

    public void route(Connection conn) {
        this.internalRoute(conn);
    }

    private void internalRoute(Connection conn) {
        if (conn.getSourceAnchor() == null || conn.getSourceAnchor().getOwner() == null || conn.getTargetAnchor() == null || conn.getTargetAnchor().getOwner() == null) {
            super.route(conn);
            return;
        }
        if (!this.connectionList.contains(conn)) {
            this.connectionList.add(conn);
        }
        this.checkTrunkVertex(conn);
        this.getBranchRouter().route(conn);
        this.invalidate(conn);
    }

    protected Dimension getTrunkVertex() {
        return this.trunkVertex;
    }

    protected void setTrunkVertex(Dimension trunkVertex) {
        this.trunkVertex = trunkVertex;
    }

    protected Orientation getTrunkOrientation() {
        return this.trunkOrientation;
    }

    protected void setTrunkOrientation(Orientation trunkOrientation) {
        this.trunkOrientation = trunkOrientation;
    }

    public boolean isOrthogonalTreeBranch(Connection conn, PointList points) {
        boolean result = false;
        if (this.isTreeBranch(conn, points)) {
            LineSeg branch = new LineSeg(points.getPoint(0), points.getPoint(1));
            LineSeg trunkShoulder = new LineSeg(points.getPoint(1), points.getPoint(2));
            LineSeg trunk = new LineSeg(points.getPoint(2), points.getPoint(3));
            result = this.isTopDown(conn) ? branch.isVertical() && trunkShoulder.isHorizontal() && trunk.isVertical() : branch.isHorizontal() && trunkShoulder.isVertical() && trunk.isHorizontal();
        }
        return result;
    }

    public boolean isTreeBranch(Connection conn, PointList points) {
        boolean result = false;
        if (points.size() == 4) {
            Rectangle targetBounds = this.getTargetAnchorRelativeBounds(conn);
            Rectangle sourceBounds = this.getSourceAnchorRelativeBounds(conn);
            result = this.isTopDown(conn) ? points.getPoint((int)0).x > sourceBounds.x && points.getPoint((int)0).x < sourceBounds.x + sourceBounds.width && points.getPoint((int)3).x > targetBounds.x && points.getPoint((int)3).x < targetBounds.x + targetBounds.width : points.getPoint((int)0).y > sourceBounds.y && points.getPoint((int)0).y < sourceBounds.y + sourceBounds.height && points.getPoint((int)3).y > targetBounds.y && points.getPoint((int)3).y < targetBounds.y + targetBounds.height;
        }
        return result;
    }

    protected boolean isUpdatingPeers() {
        return this.updatingPeers;
    }

    protected void setUpdatingPeers(boolean updatingPeers) {
        this.updatingPeers = updatingPeers;
    }

    static final class Orientation {
        public static final Orientation TOP = new Orientation();
        public static final Orientation BOTTOM = new Orientation();
        public static final Orientation RIGHT = new Orientation();
        public static final Orientation LEFT = new Orientation();

        private Orientation() {
        }

        public Point getEdge(Rectangle bounds) {
            Point result = bounds.getLeft();
            if (this == TOP) {
                result = bounds.getTop();
            } else if (this == BOTTOM) {
                result = bounds.getBottom();
            } else if (this == RIGHT) {
                result = bounds.getRight();
            }
            return result;
        }
    }
}

