/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.graph.text.conversion;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.List;
import org.eclipse.elk.core.data.LayoutMetaDataService;
import org.eclipse.elk.core.data.LayoutOptionData;
import org.eclipse.elk.core.util.internal.LayoutOptionProxy;
import org.eclipse.elk.graph.impl.ElkPropertyToValueMapEntryImpl;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.IPropertyValueProxy;
import org.eclipse.elk.graph.text.naming.ElkGraphQualifiedNameConverter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.impl.AbstractValueConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class PropertyValueValueConverter
extends AbstractValueConverter<Object> {
    @Inject
    private ElkGraphQualifiedNameConverter qualifiedNameConverter;

    public String toString(Object value) throws ValueConverterException {
        Object _xifexpression = null;
        _xifexpression = value instanceof IPropertyValueProxy ? ((IPropertyValueProxy)value).toString() : value;
        Object v = _xifexpression;
        if (v == null) {
            return "null";
        }
        if (v instanceof Double && Math.floor((Double)v) == (Double)v) {
            return Integer.toString(((Double)v).intValue());
        }
        if (v instanceof Boolean || v instanceof Number || v instanceof Enum) {
            return v.toString();
        }
        if (v instanceof String) {
            if (Objects.equal((Object)v, (Object)"true") || Objects.equal((Object)v, (Object)"false") || Objects.equal((Object)v, (Object)"null")) {
                return (String)v;
            }
            try {
                Double.parseDouble((String)v);
                return (String)v;
            }
            catch (Throwable _t) {
                if (_t instanceof NumberFormatException) {
                    return this.quoteIfNecessary((String)v);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        return this.quoteIfNecessary(v.toString());
    }

    private String quoteIfNecessary(String s) {
        try {
            QualifiedName qname = QualifiedName.create((List)Strings.split((String)s, (String)"."));
            return this.qualifiedNameConverter.toString(qname);
        }
        catch (Throwable _t) {
            if (_t instanceof ValueConverterException) {
                return "\"" + s + "\"";
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public Object toValue(String string, INode node) throws ValueConverterException {
        if (!StringExtensions.isNullOrEmpty((String)string) && !Objects.equal((Object)string, (Object)"null")) {
            EObject semanticElem;
            String unquotedString = this.unquoteIfNecessary(string);
            EObject _semanticElement = null;
            if (node != null) {
                _semanticElement = node.getSemanticElement();
            }
            if ((semanticElem = _semanticElement) instanceof ElkPropertyToValueMapEntryImpl) {
                Object value;
                LayoutOptionData option = this.toLayoutOption(((ElkPropertyToValueMapEntryImpl)semanticElem).getKey());
                Object _parseValue = null;
                if (option != null) {
                    _parseValue = option.parseValue(unquotedString);
                }
                if ((value = _parseValue) != null) {
                    return value;
                }
            }
            return new LayoutOptionProxy(unquotedString);
        }
        return null;
    }

    private String unquoteIfNecessary(String s) {
        if (s.length() >= 2 && (s.startsWith("\"") && s.endsWith("\"") || s.startsWith("'") && s.endsWith("'"))) {
            int _length = s.length();
            int _minus = _length - 1;
            return s.substring(1, _minus);
        }
        if (s.length() >= 1 && (Character.isJavaIdentifierStart(s.charAt(0)) || s.startsWith("^"))) {
            QualifiedName qname = this.qualifiedNameConverter.toQualifiedName(s);
            return qname.toString(".");
        }
        return s;
    }

    private LayoutOptionData toLayoutOption(IProperty<?> property) {
        if (property instanceof LayoutOptionData) {
            return (LayoutOptionData)property;
        }
        if (property != null) {
            return LayoutMetaDataService.getInstance().getOptionData(property.getId());
        }
        return null;
    }
}

