/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.server.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import org.eclipse.sirius.server.internal.SiriusServerMatchResult;

public class SiriusServerPathMatcher {
    private static final char SLASH = '/';
    private static final char VARIABLE_START = '{';
    private static final char VARIABLE_END = '}';
    private static final String VARIABLE_REGEXP = "([^/]+?)";
    private static final String REMAINING_PATH_REGEXP = "(.*)";
    private List<String> variableNames = new ArrayList<String>();
    private Pattern pathPattern;

    public SiriusServerPathMatcher(String path) {
        this.initialize(path);
    }

    private void initialize(String path) {
        int startIndex;
        StringBuilder stringBuilder = new StringBuilder();
        int index = startIndex = this.computeStartIndex(path);
        while (index < path.length()) {
            char character = path.charAt(index);
            if ('{' == character) {
                int variableEndIndex = path.indexOf(125, index);
                String variable = path.substring(index + 1, variableEndIndex);
                this.variableNames.add(variable);
                stringBuilder.append(VARIABLE_REGEXP);
                index = variableEndIndex + 1;
                continue;
            }
            stringBuilder.append(character);
            ++index;
        }
        if (!path.endsWith(String.valueOf('/'))) {
            stringBuilder.append('/');
        }
        stringBuilder.append(REMAINING_PATH_REGEXP);
        this.pathPattern = Pattern.compile(stringBuilder.toString());
    }

    private int computeStartIndex(String path) {
        if (path.length() > 0 && '/' == path.charAt(0)) {
            return 1;
        }
        return 0;
    }

    public SiriusServerMatchResult match(String requestPath) {
        String path = requestPath;
        if (path.length() > 0 && '/' == path.charAt(0)) {
            path = path.substring(1);
        }
        if (path.length() > 0 && '/' != path.charAt(path.length() - 1)) {
            path = String.valueOf(path) + '/';
        }
        Matcher matcher = this.pathPattern.matcher(path);
        HashMap<String, String> variables = new HashMap<String, String>();
        String remainingPart = "";
        if (matcher.matches()) {
            if (this.variableNames.size() <= matcher.groupCount()) {
                IntStream.range(1, matcher.groupCount()).forEach(index -> {
                    String variable = this.variableNames.get(index - 1);
                    variables.put(variable, matcher.group(index));
                });
            }
            if (matcher.groupCount() > 0 && (remainingPart = matcher.group(matcher.groupCount())).length() > 0 && '/' == remainingPart.charAt(remainingPart.length() - 1)) {
                remainingPart = remainingPart.substring(0, remainingPart.length() - 1);
            }
        }
        return new SiriusServerMatchResult(variables, remainingPart, matcher.matches());
    }
}

