/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.graphql.internal.schema;

import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.sirius.services.graphql.common.api.ISiriusGraphQLTypeCustomizer;
import org.eclipse.sirius.services.graphql.common.api.SiriusGraphQLCommonPlugin;
import org.eclipse.sirius.services.graphql.common.api.SiriusGraphQLFilterStatus;
import org.eclipse.sirius.services.graphql.common.api.pagination.PageInfoTypeProvider;
import org.eclipse.sirius.services.graphql.common.api.pagination.SiriusGraphQLConnectionTypeProvider;
import org.eclipse.sirius.services.graphql.common.api.pagination.SiriusGraphQLEdgeTypeProvider;
import org.eclipse.sirius.services.graphql.internal.schema.SiriusGraphQLTypeCustomizer;
import org.eclipse.sirius.services.graphql.internal.schema.mutation.FileCreationDescriptionTypeProvider;
import org.eclipse.sirius.services.graphql.internal.schema.mutation.MutationTypeProvider;
import org.eclipse.sirius.services.graphql.internal.schema.mutation.ProjectCreationDescriptionTypeProvider;
import org.eclipse.sirius.services.graphql.internal.schema.mutation.RepresentationCreationDescriptionTypesProvider;
import org.eclipse.sirius.services.graphql.internal.schema.query.QueryTypeProvider;
import org.eclipse.sirius.services.graphql.internal.schema.query.user.UserTypesProvider;

public class SiriusGraphQLSchemaProvider {
    public GraphQLSchema getSchema() {
        SiriusGraphQLTypeCustomizer graphQLTypeCustomizer = new SiriusGraphQLTypeCustomizer();
        GraphQLSchema.Builder builder = this.initializeSchema(graphQLTypeCustomizer);
        Function<GraphQLType, SiriusGraphQLFilterStatus> pageInfoTypeFilter = graphQLType -> {
            if ("PageInfo".equals(graphQLType.getName())) {
                return SiriusGraphQLFilterStatus.REJECT;
            }
            return SiriusGraphQLFilterStatus.KEEP;
        };
        List customizers = SiriusGraphQLCommonPlugin.getPlugin().getGraphQLSchemaCustomizers();
        customizers.forEach(customizer -> {
            GraphQLSchema.Builder builder2 = customizer.customize(builder, pageInfoTypeFilter, graphQLTypeCustomizer);
        });
        return builder.build();
    }

    private GraphQLSchema.Builder initializeSchema(ISiriusGraphQLTypeCustomizer graphQLTypeCustomizer) {
        GraphQLObjectType query = new QueryTypeProvider().getType(graphQLTypeCustomizer);
        GraphQLObjectType mutation = new MutationTypeProvider().getType(graphQLTypeCustomizer);
        Set<GraphQLType> userTypes = new UserTypesProvider().getTypes(graphQLTypeCustomizer);
        GraphQLType pageInfoType = new PageInfoTypeProvider().getType(graphQLTypeCustomizer);
        GraphQLType projectCreationDescriptionType = new ProjectCreationDescriptionTypeProvider().getType(graphQLTypeCustomizer);
        GraphQLType fileCreationDescriptionType = new FileCreationDescriptionTypeProvider().getType(graphQLTypeCustomizer);
        GraphQLType representationCreationDescriptionType = new RepresentationCreationDescriptionTypesProvider().getType(graphQLTypeCustomizer);
        GraphQLObjectType representationDescriptionEPackageEdge = new SiriusGraphQLEdgeTypeProvider("RepresentationDescriptionEPackageEdge", "EPackage").getType(graphQLTypeCustomizer);
        GraphQLObjectType representationDescriptionEPackageConnection = new SiriusGraphQLConnectionTypeProvider("RepresentationDescriptionEPackageConnection", "RepresentationDescriptionEPackageEdge").getType(graphQLTypeCustomizer);
        GraphQLObjectType projectActivatedViewpointsEdge = new SiriusGraphQLEdgeTypeProvider("ProjectViewpointEdge", "Viewpoint").getType(graphQLTypeCustomizer);
        GraphQLObjectType projectActivatedViewpointsConnection = new SiriusGraphQLConnectionTypeProvider("ProjectViewpointConnection", "ProjectViewpointEdge").getType(graphQLTypeCustomizer);
        GraphQLObjectType fileEObjectsEdge = new SiriusGraphQLEdgeTypeProvider("FileEObjectEdge", "EObject").getType(graphQLTypeCustomizer);
        GraphQLObjectType fileEObjectsConnection = new SiriusGraphQLConnectionTypeProvider("FileEObjectConnection", "FileEObjectEdge").getType(graphQLTypeCustomizer);
        GraphQLObjectType fileRepresentationsEdge = new SiriusGraphQLEdgeTypeProvider("FileRepresentationEdge", "Representation").getType(graphQLTypeCustomizer);
        GraphQLObjectType fileRepresentationsConnection = new SiriusGraphQLConnectionTypeProvider("FileRepresentationConnection", "FileRepresentationEdge").getType(graphQLTypeCustomizer);
        GraphQLSchema.Builder builder = GraphQLSchema.newSchema().query(query).mutation(mutation).additionalTypes(userTypes).additionalType(pageInfoType).additionalType(projectCreationDescriptionType).additionalType(fileCreationDescriptionType).additionalType(representationCreationDescriptionType).additionalType((GraphQLType)representationDescriptionEPackageEdge).additionalType((GraphQLType)representationDescriptionEPackageConnection).additionalType((GraphQLType)projectActivatedViewpointsEdge).additionalType((GraphQLType)projectActivatedViewpointsConnection).additionalType((GraphQLType)fileEObjectsEdge).additionalType((GraphQLType)fileEObjectsConnection).additionalType((GraphQLType)fileRepresentationsEdge).additionalType((GraphQLType)fileRepresentationsConnection);
        return builder;
    }
}

